// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about how traffic is rerouted to instances in a replacement environment in
 * a blue/green deployment.
 */
class DeploymentReadyOption private constructor(builder: Builder) {
    /**
     * Information about when to reroute traffic from an original environment to a
     * replacement environment in a blue/green deployment.
     *
     *
     * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately
     * after the new application revision is installed on the instances in the
     * replacement environment.
     *
     * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless
     * traffic rerouting is started using ContinueDeployment. If
     * traffic rerouting is not started before the end of the specified wait period,
     * the deployment status is changed to Stopped.
     */
    val actionOnTimeout: aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyAction? = builder.actionOnTimeout
    /**
     * The number of minutes to wait before the status of a blue/green deployment is changed
     * to Stopped if rerouting is not started manually. Applies only to the
     * STOP_DEPLOYMENT option for actionOnTimeout.
     */
    val waitTimeInMinutes: kotlin.Int = builder.waitTimeInMinutes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentReadyOption(")
        append("actionOnTimeout=$actionOnTimeout,")
        append("waitTimeInMinutes=$waitTimeInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionOnTimeout?.hashCode() ?: 0
        result = 31 * result + (waitTimeInMinutes)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentReadyOption

        if (actionOnTimeout != other.actionOnTimeout) return false
        if (waitTimeInMinutes != other.waitTimeInMinutes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about when to reroute traffic from an original environment to a
         * replacement environment in a blue/green deployment.
         *
         *
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately
         * after the new application revision is installed on the instances in the
         * replacement environment.
         *
         * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless
         * traffic rerouting is started using ContinueDeployment. If
         * traffic rerouting is not started before the end of the specified wait period,
         * the deployment status is changed to Stopped.
         */
        var actionOnTimeout: aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyAction? = null
        /**
         * The number of minutes to wait before the status of a blue/green deployment is changed
         * to Stopped if rerouting is not started manually. Applies only to the
         * STOP_DEPLOYMENT option for actionOnTimeout.
         */
        var waitTimeInMinutes: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyOption) : this() {
            this.actionOnTimeout = x.actionOnTimeout
            this.waitTimeInMinutes = x.waitTimeInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyOption = DeploymentReadyOption(this)
    }
}
