// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a Lambda function specified in a deployment.
 */
class LambdaFunctionInfo private constructor(builder: Builder) {
    /**
     * The version of a Lambda function that production traffic points to.
     */
    val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases in the
     * AWS Lambda Developer Guide.
     */
    val functionAlias: kotlin.String? = builder.functionAlias
    /**
     * The name of a Lambda function.
     */
    val functionName: kotlin.String? = builder.functionName
    /**
     * The version of a Lambda function that production traffic points to after the Lambda
     * function is deployed.
     */
    val targetVersion: kotlin.String? = builder.targetVersion
    /**
     * The percentage of production traffic that the target version of a Lambda function
     * receives.
     */
    val targetVersionWeight: kotlin.Double = builder.targetVersionWeight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionInfo(")
        append("currentVersion=$currentVersion,")
        append("functionAlias=$functionAlias,")
        append("functionName=$functionName,")
        append("targetVersion=$targetVersion,")
        append("targetVersionWeight=$targetVersionWeight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentVersion?.hashCode() ?: 0
        result = 31 * result + (functionAlias?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (targetVersion?.hashCode() ?: 0)
        result = 31 * result + (targetVersionWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionInfo

        if (currentVersion != other.currentVersion) return false
        if (functionAlias != other.functionAlias) return false
        if (functionName != other.functionName) return false
        if (targetVersion != other.targetVersion) return false
        if (targetVersionWeight != other.targetVersionWeight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The version of a Lambda function that production traffic points to.
         */
        var currentVersion: kotlin.String? = null
        /**
         * The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases in the
         * AWS Lambda Developer Guide.
         */
        var functionAlias: kotlin.String? = null
        /**
         * The name of a Lambda function.
         */
        var functionName: kotlin.String? = null
        /**
         * The version of a Lambda function that production traffic points to after the Lambda
         * function is deployed.
         */
        var targetVersion: kotlin.String? = null
        /**
         * The percentage of production traffic that the target version of a Lambda function
         * receives.
         */
        var targetVersionWeight: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo) : this() {
            this.currentVersion = x.currentVersion
            this.functionAlias = x.functionAlias
            this.functionName = x.functionName
            this.targetVersion = x.targetVersion
            this.targetVersionWeight = x.targetVersionWeight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo = LambdaFunctionInfo(this)
    }
}
