// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the location of an application revision.
 */
class RevisionLocation private constructor(builder: Builder) {
    /**
     * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
     * content is formatted as JSON or YAML and stored as a RawString.
     */
    val appSpecContent: aws.sdk.kotlin.services.codedeploy.model.AppSpecContent? = builder.appSpecContent
    /**
     * Information about the location of application artifacts stored in GitHub.
     */
    val gitHubLocation: aws.sdk.kotlin.services.codedeploy.model.GitHubLocation? = builder.gitHubLocation
    /**
     * The type of application revision:
     *
     *
     * S3: An application revision stored in Amazon S3.
     *
     * GitHub: An application revision stored in GitHub (EC2/On-premises deployments
     * only).
     *
     * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments
     * only).
     *
     * AppSpecContent: An AppSpecContent object that contains the
     * contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
     * content is formatted as JSON or YAML stored as a RawString.
     */
    val revisionType: aws.sdk.kotlin.services.codedeploy.model.RevisionLocationType? = builder.revisionType
    /**
     * Information about the location of a revision stored in Amazon S3.
     */
    val s3Location: aws.sdk.kotlin.services.codedeploy.model.S3Location? = builder.s3Location
    /**
     * Information about the location of an AWS Lambda deployment revision stored as a
     * RawString.
     */
    val string: aws.sdk.kotlin.services.codedeploy.model.RawString? = builder.string

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.RevisionLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevisionLocation(")
        append("appSpecContent=$appSpecContent,")
        append("gitHubLocation=$gitHubLocation,")
        append("revisionType=$revisionType,")
        append("s3Location=$s3Location,")
        append("string=$string)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appSpecContent?.hashCode() ?: 0
        result = 31 * result + (gitHubLocation?.hashCode() ?: 0)
        result = 31 * result + (revisionType?.hashCode() ?: 0)
        result = 31 * result + (s3Location?.hashCode() ?: 0)
        result = 31 * result + (string?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevisionLocation

        if (appSpecContent != other.appSpecContent) return false
        if (gitHubLocation != other.gitHubLocation) return false
        if (revisionType != other.revisionType) return false
        if (s3Location != other.s3Location) return false
        if (string != other.string) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.RevisionLocation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
         * content is formatted as JSON or YAML and stored as a RawString.
         */
        var appSpecContent: aws.sdk.kotlin.services.codedeploy.model.AppSpecContent? = null
        /**
         * Information about the location of application artifacts stored in GitHub.
         */
        var gitHubLocation: aws.sdk.kotlin.services.codedeploy.model.GitHubLocation? = null
        /**
         * The type of application revision:
         *
         *
         * S3: An application revision stored in Amazon S3.
         *
         * GitHub: An application revision stored in GitHub (EC2/On-premises deployments
         * only).
         *
         * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments
         * only).
         *
         * AppSpecContent: An AppSpecContent object that contains the
         * contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
         * content is formatted as JSON or YAML stored as a RawString.
         */
        var revisionType: aws.sdk.kotlin.services.codedeploy.model.RevisionLocationType? = null
        /**
         * Information about the location of a revision stored in Amazon S3.
         */
        var s3Location: aws.sdk.kotlin.services.codedeploy.model.S3Location? = null
        /**
         * Information about the location of an AWS Lambda deployment revision stored as a
         * RawString.
         */
        var string: aws.sdk.kotlin.services.codedeploy.model.RawString? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation) : this() {
            this.appSpecContent = x.appSpecContent
            this.gitHubLocation = x.gitHubLocation
            this.revisionType = x.revisionType
            this.s3Location = x.s3Location
            this.string = x.string
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.RevisionLocation = RevisionLocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AppSpecContent] inside the given [block]
         */
        fun appSpecContent(block: aws.sdk.kotlin.services.codedeploy.model.AppSpecContent.Builder.() -> kotlin.Unit) {
            this.appSpecContent = aws.sdk.kotlin.services.codedeploy.model.AppSpecContent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.GitHubLocation] inside the given [block]
         */
        fun gitHubLocation(block: aws.sdk.kotlin.services.codedeploy.model.GitHubLocation.Builder.() -> kotlin.Unit) {
            this.gitHubLocation = aws.sdk.kotlin.services.codedeploy.model.GitHubLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.S3Location] inside the given [block]
         */
        fun s3Location(block: aws.sdk.kotlin.services.codedeploy.model.S3Location.Builder.() -> kotlin.Unit) {
            this.s3Location = aws.sdk.kotlin.services.codedeploy.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RawString] inside the given [block]
         */
        fun string(block: aws.sdk.kotlin.services.codedeploy.model.RawString.Builder.() -> kotlin.Unit) {
            this.string = aws.sdk.kotlin.services.codedeploy.model.RawString.invoke(block)
        }
    }
}
