// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of an UpdateDeploymentGroup operation.
 */
class UpdateDeploymentGroupRequest private constructor(builder: Builder) {
    /**
     * Information to add or change about Amazon CloudWatch alarms when the deployment group
     * is updated.
     */
    val alarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The application name that corresponds to the deployment group to update.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * Information for an automatic rollback configuration that is added or changed when a
     * deployment group is updated.
     */
    val autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * The replacement list of Auto Scaling groups to be included in the deployment group, if
     * you want to change them. To keep the Auto Scaling groups, enter their names. To remove
     * Auto Scaling groups, do not enter any Auto Scaling group names.
     */
    val autoScalingGroups: List<String>? = builder.autoScalingGroups
    /**
     * Information about blue/green deployment options for a deployment group.
     */
    val blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * The current name of the deployment group.
     */
    val currentDeploymentGroupName: kotlin.String? = builder.currentDeploymentGroupName
    /**
     * The replacement deployment configuration name to use, if you want to change it.
     */
    val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to
     * run and whether to route deployment traffic behind a load balancer.
     */
    val deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = builder.deploymentStyle
    /**
     * The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
     * To keep the existing tags, enter their names. To remove tags, do not enter any tag
     * names.
     */
    val ec2TagFilters: List<Ec2TagFilter>? = builder.ec2TagFilters
    /**
     * Information about groups of tags applied to on-premises instances. The deployment
     * group includes only EC2 instances identified by all the tag groups.
     */
    val ec2TagSet: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet? = builder.ec2TagSet
    /**
     * The target Amazon ECS services in the deployment group. This applies only to
     * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
     * is specified as an Amazon ECS cluster and service name pair using the format
     * <clustername>:<servicename>.
     */
    val ecsServices: List<EcsService>? = builder.ecsServices
    /**
     * Information about the load balancer used in a deployment.
     */
    val loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * The new name of the deployment group, if you want to change it.
     */
    val newDeploymentGroupName: kotlin.String? = builder.newDeploymentGroupName
    /**
     * The replacement set of on-premises instance tags on which to filter, if you want to
     * change them. To keep the existing tags, enter their names. To remove tags, do not enter
     * any tag names.
     */
    val onPremisesInstanceTagFilters: List<TagFilter>? = builder.onPremisesInstanceTagFilters
    /**
     * Information about an on-premises instance tag set. The deployment group includes only
     * on-premises instances identified by all the tag groups.
     */
    val onPremisesTagSet: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet? = builder.onPremisesTagSet
    /**
     * Indicates what happens when new EC2 instances are launched mid-deployment and do not
     * receive the deployed application revision.
     * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
     * one or more 'auto-update outdated instances' deployments to apply the deployed
     * application revision to the new EC2 instances.
     * If this option is set to IGNORE, CodeDeploy does not initiate a
     * deployment to update the new EC2 instances. This may result in instances having
     * different revisions.
     */
    val outdatedInstancesStrategy: aws.sdk.kotlin.services.codedeploy.model.OutdatedInstancesStrategy? = builder.outdatedInstancesStrategy
    /**
     * A replacement ARN for the service role, if you want to change it.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * Information about triggers to change when the deployment group is updated. For
     * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
     * CodeDeploy Deployment Group in the AWS CodeDeploy User
     * Guide.
     */
    val triggerConfigurations: List<TriggerConfig>? = builder.triggerConfigurations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDeploymentGroupRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("autoScalingGroups=$autoScalingGroups,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("currentDeploymentGroupName=$currentDeploymentGroupName,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentStyle=$deploymentStyle,")
        append("ec2TagFilters=$ec2TagFilters,")
        append("ec2TagSet=$ec2TagSet,")
        append("ecsServices=$ecsServices,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("newDeploymentGroupName=$newDeploymentGroupName,")
        append("onPremisesInstanceTagFilters=$onPremisesInstanceTagFilters,")
        append("onPremisesTagSet=$onPremisesTagSet,")
        append("outdatedInstancesStrategy=$outdatedInstancesStrategy,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("triggerConfigurations=$triggerConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroups?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (currentDeploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (ec2TagFilters?.hashCode() ?: 0)
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (ecsServices?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (newDeploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (onPremisesInstanceTagFilters?.hashCode() ?: 0)
        result = 31 * result + (onPremisesTagSet?.hashCode() ?: 0)
        result = 31 * result + (outdatedInstancesStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (triggerConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDeploymentGroupRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (autoScalingGroups != other.autoScalingGroups) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (currentDeploymentGroupName != other.currentDeploymentGroupName) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (ec2TagFilters != other.ec2TagFilters) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (ecsServices != other.ecsServices) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (newDeploymentGroupName != other.newDeploymentGroupName) return false
        if (onPremisesInstanceTagFilters != other.onPremisesInstanceTagFilters) return false
        if (onPremisesTagSet != other.onPremisesTagSet) return false
        if (outdatedInstancesStrategy != other.outdatedInstancesStrategy) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (triggerConfigurations != other.triggerConfigurations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information to add or change about Amazon CloudWatch alarms when the deployment group
         * is updated.
         */
        var alarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = null
        /**
         * The application name that corresponds to the deployment group to update.
         */
        var applicationName: kotlin.String? = null
        /**
         * Information for an automatic rollback configuration that is added or changed when a
         * deployment group is updated.
         */
        var autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = null
        /**
         * The replacement list of Auto Scaling groups to be included in the deployment group, if
         * you want to change them. To keep the Auto Scaling groups, enter their names. To remove
         * Auto Scaling groups, do not enter any Auto Scaling group names.
         */
        var autoScalingGroups: List<String>? = null
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        var blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = null
        /**
         * The current name of the deployment group.
         */
        var currentDeploymentGroupName: kotlin.String? = null
        /**
         * The replacement deployment configuration name to use, if you want to change it.
         */
        var deploymentConfigName: kotlin.String? = null
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        var deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = null
        /**
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
         * To keep the existing tags, enter their names. To remove tags, do not enter any tag
         * names.
         */
        var ec2TagFilters: List<Ec2TagFilter>? = null
        /**
         * Information about groups of tags applied to on-premises instances. The deployment
         * group includes only EC2 instances identified by all the tag groups.
         */
        var ec2TagSet: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet? = null
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        var ecsServices: List<EcsService>? = null
        /**
         * Information about the load balancer used in a deployment.
         */
        var loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = null
        /**
         * The new name of the deployment group, if you want to change it.
         */
        var newDeploymentGroupName: kotlin.String? = null
        /**
         * The replacement set of on-premises instance tags on which to filter, if you want to
         * change them. To keep the existing tags, enter their names. To remove tags, do not enter
         * any tag names.
         */
        var onPremisesInstanceTagFilters: List<TagFilter>? = null
        /**
         * Information about an on-premises instance tag set. The deployment group includes only
         * on-premises instances identified by all the tag groups.
         */
        var onPremisesTagSet: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet? = null
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        var outdatedInstancesStrategy: aws.sdk.kotlin.services.codedeploy.model.OutdatedInstancesStrategy? = null
        /**
         * A replacement ARN for the service role, if you want to change it.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * Information about triggers to change when the deployment group is updated. For
         * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
         * CodeDeploy Deployment Group in the AWS CodeDeploy User
         * Guide.
         */
        var triggerConfigurations: List<TriggerConfig>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.autoScalingGroups = x.autoScalingGroups
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.currentDeploymentGroupName = x.currentDeploymentGroupName
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentStyle = x.deploymentStyle
            this.ec2TagFilters = x.ec2TagFilters
            this.ec2TagSet = x.ec2TagSet
            this.ecsServices = x.ecsServices
            this.loadBalancerInfo = x.loadBalancerInfo
            this.newDeploymentGroupName = x.newDeploymentGroupName
            this.onPremisesInstanceTagFilters = x.onPremisesInstanceTagFilters
            this.onPremisesTagSet = x.onPremisesTagSet
            this.outdatedInstancesStrategy = x.outdatedInstancesStrategy
            this.serviceRoleArn = x.serviceRoleArn
            this.triggerConfigurations = x.triggerConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest = UpdateDeploymentGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        fun alarmConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        fun autoRollbackConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        fun blueGreenDeploymentConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        fun deploymentStyle(block: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.Builder.() -> kotlin.Unit) {
            this.deploymentStyle = aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        fun ec2TagSet(block: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet.Builder.() -> kotlin.Unit) {
            this.ec2TagSet = aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        fun loadBalancerInfo(block: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.Builder.() -> kotlin.Unit) {
            this.loadBalancerInfo = aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet] inside the given [block]
         */
        fun onPremisesTagSet(block: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet.Builder.() -> kotlin.Unit) {
            this.onPremisesTagSet = aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet.invoke(block)
        }
    }
}
