// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentGroupsResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeploymentGroupInfo
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetDeploymentGroupsOperationDeserializer: HttpDeserialize<BatchGetDeploymentGroupsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetDeploymentGroupsResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetDeploymentGroupsError(context, response)
        }
        val builder = BatchGetDeploymentGroupsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetDeploymentGroupsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetDeploymentGroupsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "BatchLimitExceededException" -> BatchLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetDeploymentGroupsOperationBody(builder: BatchGetDeploymentGroupsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTGROUPSINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deploymentGroupsInfo"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTGROUPSINFO_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTGROUPSINFO_DESCRIPTOR.index -> builder.deploymentGroupsInfo =
                    deserializer.deserializeList(DEPLOYMENTGROUPSINFO_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentGroupInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentGroupInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
