// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeploymentConfigInfo
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentConfigResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDeploymentConfigOperationDeserializer: HttpDeserialize<GetDeploymentConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeploymentConfigResponse {
        if (!response.status.isSuccess()) {
            throwGetDeploymentConfigError(context, response)
        }
        val builder = GetDeploymentConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeploymentConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDeploymentConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentConfigNameRequiredException" -> DeploymentConfigNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidComputePlatformException" -> InvalidComputePlatformExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeploymentConfigOperationBody(builder: GetDeploymentConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTCONFIGINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentConfigInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTCONFIGINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTCONFIGINFO_DESCRIPTOR.index -> builder.deploymentConfigInfo = deserializeDeploymentConfigInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
