// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.codedeploy.model.*
import aws.sdk.kotlin.services.codedeploy.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "CodeDeploy"
const val ServiceApiVersion: String = "2014-10-06"
const val SdkVersion: String = "0.16.5-beta"

internal class DefaultCodeDeployClient(override val config: CodeDeployClient.Config) : CodeDeployClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds tags to on-premises instances.
     */
    override suspend fun addTagsToOnPremisesInstances(input: AddTagsToOnPremisesInstancesRequest): AddTagsToOnPremisesInstancesResponse {
        val op = SdkHttpOperation.build<AddTagsToOnPremisesInstancesRequest, AddTagsToOnPremisesInstancesResponse> {
            serializer = AddTagsToOnPremisesInstancesOperationSerializer()
            deserializer = AddTagsToOnPremisesInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTagsToOnPremisesInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.
     */
    override suspend fun batchGetApplicationRevisions(input: BatchGetApplicationRevisionsRequest): BatchGetApplicationRevisionsResponse {
        val op = SdkHttpOperation.build<BatchGetApplicationRevisionsRequest, BatchGetApplicationRevisionsResponse> {
            serializer = BatchGetApplicationRevisionsOperationSerializer()
            deserializer = BatchGetApplicationRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetApplicationRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     */
    override suspend fun batchGetApplications(input: BatchGetApplicationsRequest): BatchGetApplicationsResponse {
        val op = SdkHttpOperation.build<BatchGetApplicationsRequest, BatchGetApplicationsResponse> {
            serializer = BatchGetApplicationsOperationSerializer()
            deserializer = BatchGetApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more deployment groups.
     */
    override suspend fun batchGetDeploymentGroups(input: BatchGetDeploymentGroupsRequest): BatchGetDeploymentGroupsResponse {
        val op = SdkHttpOperation.build<BatchGetDeploymentGroupsRequest, BatchGetDeploymentGroupsResponse> {
            serializer = BatchGetDeploymentGroupsOperationSerializer()
            deserializer = BatchGetDeploymentGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetDeploymentGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This method works, but is deprecated. Use `BatchGetDeploymentTargets` instead.
     *
     *  Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and AWS Lambda compute platforms. The newer `BatchGetDeploymentTargets` works with all compute platforms. The maximum number of instances that can be returned is 25.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun batchGetDeploymentInstances(input: BatchGetDeploymentInstancesRequest): BatchGetDeploymentInstancesResponse {
        val op = SdkHttpOperation.build<BatchGetDeploymentInstancesRequest, BatchGetDeploymentInstancesResponse> {
            serializer = BatchGetDeploymentInstancesOperationSerializer()
            deserializer = BatchGetDeploymentInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetDeploymentInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated `BatchGetDeploymentInstances`. The maximum number of targets that can be returned is 25.
     *
     *  The type of targets returned depends on the deployment's compute platform or deployment method:
     * + **EC2/On-premises**: Information about EC2 instance targets.
     * + **AWS Lambda**: Information about Lambda functions targets.
     * + **Amazon ECS**: Information about Amazon ECS service targets.
     * + **CloudFormation**: Information about targets of blue/green deployments initiated by a CloudFormation stack update.
     */
    override suspend fun batchGetDeploymentTargets(input: BatchGetDeploymentTargetsRequest): BatchGetDeploymentTargetsResponse {
        val op = SdkHttpOperation.build<BatchGetDeploymentTargetsRequest, BatchGetDeploymentTargetsResponse> {
            serializer = BatchGetDeploymentTargetsOperationSerializer()
            deserializer = BatchGetDeploymentTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetDeploymentTargets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     */
    override suspend fun batchGetDeployments(input: BatchGetDeploymentsRequest): BatchGetDeploymentsResponse {
        val op = SdkHttpOperation.build<BatchGetDeploymentsRequest, BatchGetDeploymentsResponse> {
            serializer = BatchGetDeploymentsOperationSerializer()
            deserializer = BatchGetDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetDeployments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.
     */
    override suspend fun batchGetOnPremisesInstances(input: BatchGetOnPremisesInstancesRequest): BatchGetOnPremisesInstancesResponse {
        val op = SdkHttpOperation.build<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResponse> {
            serializer = BatchGetOnPremisesInstancesOperationSerializer()
            deserializer = BatchGetOnPremisesInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetOnPremisesInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)
     */
    override suspend fun continueDeployment(input: ContinueDeploymentRequest): ContinueDeploymentResponse {
        val op = SdkHttpOperation.build<ContinueDeploymentRequest, ContinueDeploymentResponse> {
            serializer = ContinueDeploymentOperationSerializer()
            deserializer = ContinueDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ContinueDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an application.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deploys an application revision through the specified deployment group.
     */
    override suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse {
        val op = SdkHttpOperation.build<CreateDeploymentRequest, CreateDeploymentResponse> {
            serializer = CreateDeploymentOperationSerializer()
            deserializer = CreateDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a deployment configuration.
     */
    override suspend fun createDeploymentConfig(input: CreateDeploymentConfigRequest): CreateDeploymentConfigResponse {
        val op = SdkHttpOperation.build<CreateDeploymentConfigRequest, CreateDeploymentConfigResponse> {
            serializer = CreateDeploymentConfigOperationSerializer()
            deserializer = CreateDeploymentConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeploymentConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a deployment group to which application revisions are deployed.
     */
    override suspend fun createDeploymentGroup(input: CreateDeploymentGroupRequest): CreateDeploymentGroupResponse {
        val op = SdkHttpOperation.build<CreateDeploymentGroupRequest, CreateDeploymentGroupResponse> {
            serializer = CreateDeploymentGroupOperationSerializer()
            deserializer = CreateDeploymentGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeploymentGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an application.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a deployment configuration.
     *
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.
     */
    override suspend fun deleteDeploymentConfig(input: DeleteDeploymentConfigRequest): DeleteDeploymentConfigResponse {
        val op = SdkHttpOperation.build<DeleteDeploymentConfigRequest, DeleteDeploymentConfigResponse> {
            serializer = DeleteDeploymentConfigOperationSerializer()
            deserializer = DeleteDeploymentConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDeploymentConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a deployment group.
     */
    override suspend fun deleteDeploymentGroup(input: DeleteDeploymentGroupRequest): DeleteDeploymentGroupResponse {
        val op = SdkHttpOperation.build<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResponse> {
            serializer = DeleteDeploymentGroupOperationSerializer()
            deserializer = DeleteDeploymentGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDeploymentGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a GitHub account connection.
     */
    override suspend fun deleteGitHubAccountToken(input: DeleteGitHubAccountTokenRequest): DeleteGitHubAccountTokenResponse {
        val op = SdkHttpOperation.build<DeleteGitHubAccountTokenRequest, DeleteGitHubAccountTokenResponse> {
            serializer = DeleteGitHubAccountTokenOperationSerializer()
            deserializer = DeleteGitHubAccountTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGitHubAccountToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes resources linked to an external ID.
     */
    override suspend fun deleteResourcesByExternalId(input: DeleteResourcesByExternalIdRequest): DeleteResourcesByExternalIdResponse {
        val op = SdkHttpOperation.build<DeleteResourcesByExternalIdRequest, DeleteResourcesByExternalIdResponse> {
            serializer = DeleteResourcesByExternalIdOperationSerializer()
            deserializer = DeleteResourcesByExternalIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResourcesByExternalId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an on-premises instance.
     */
    override suspend fun deregisterOnPremisesInstance(input: DeregisterOnPremisesInstanceRequest): DeregisterOnPremisesInstanceResponse {
        val op = SdkHttpOperation.build<DeregisterOnPremisesInstanceRequest, DeregisterOnPremisesInstanceResponse> {
            serializer = DeregisterOnPremisesInstanceOperationSerializer()
            deserializer = DeregisterOnPremisesInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterOnPremisesInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an application.
     */
    override suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse {
        val op = SdkHttpOperation.build<GetApplicationRequest, GetApplicationResponse> {
            serializer = GetApplicationOperationSerializer()
            deserializer = GetApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an application revision.
     */
    override suspend fun getApplicationRevision(input: GetApplicationRevisionRequest): GetApplicationRevisionResponse {
        val op = SdkHttpOperation.build<GetApplicationRevisionRequest, GetApplicationRevisionResponse> {
            serializer = GetApplicationRevisionOperationSerializer()
            deserializer = GetApplicationRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApplicationRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a deployment.
     *
     *  The `content` property of the `appSpecContent` object in the returned revision is always null. Use `GetApplicationRevision` and the `sha256` property of the returned `appSpecContent` object to get the content of the deployment’s AppSpec file.
     */
    override suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse {
        val op = SdkHttpOperation.build<GetDeploymentRequest, GetDeploymentResponse> {
            serializer = GetDeploymentOperationSerializer()
            deserializer = GetDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a deployment configuration.
     */
    override suspend fun getDeploymentConfig(input: GetDeploymentConfigRequest): GetDeploymentConfigResponse {
        val op = SdkHttpOperation.build<GetDeploymentConfigRequest, GetDeploymentConfigResponse> {
            serializer = GetDeploymentConfigOperationSerializer()
            deserializer = GetDeploymentConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeploymentConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a deployment group.
     */
    override suspend fun getDeploymentGroup(input: GetDeploymentGroupRequest): GetDeploymentGroupResponse {
        val op = SdkHttpOperation.build<GetDeploymentGroupRequest, GetDeploymentGroupResponse> {
            serializer = GetDeploymentGroupOperationSerializer()
            deserializer = GetDeploymentGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeploymentGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an instance as part of a deployment.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getDeploymentInstance(input: GetDeploymentInstanceRequest): GetDeploymentInstanceResponse {
        val op = SdkHttpOperation.build<GetDeploymentInstanceRequest, GetDeploymentInstanceResponse> {
            serializer = GetDeploymentInstanceOperationSerializer()
            deserializer = GetDeploymentInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeploymentInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a deployment target.
     */
    override suspend fun getDeploymentTarget(input: GetDeploymentTargetRequest): GetDeploymentTargetResponse {
        val op = SdkHttpOperation.build<GetDeploymentTargetRequest, GetDeploymentTargetResponse> {
            serializer = GetDeploymentTargetOperationSerializer()
            deserializer = GetDeploymentTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeploymentTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an on-premises instance.
     */
    override suspend fun getOnPremisesInstance(input: GetOnPremisesInstanceRequest): GetOnPremisesInstanceResponse {
        val op = SdkHttpOperation.build<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResponse> {
            serializer = GetOnPremisesInstanceOperationSerializer()
            deserializer = GetOnPremisesInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOnPremisesInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about revisions for an application.
     */
    override suspend fun listApplicationRevisions(input: ListApplicationRevisionsRequest): ListApplicationRevisionsResponse {
        val op = SdkHttpOperation.build<ListApplicationRevisionsRequest, ListApplicationRevisionsResponse> {
            serializer = ListApplicationRevisionsOperationSerializer()
            deserializer = ListApplicationRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplicationRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the applications registered with the IAM user or AWS account.
     */
    override suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse {
        val op = SdkHttpOperation.build<ListApplicationsRequest, ListApplicationsResponse> {
            serializer = ListApplicationsOperationSerializer()
            deserializer = ListApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the deployment configurations with the IAM user or AWS account.
     */
    override suspend fun listDeploymentConfigs(input: ListDeploymentConfigsRequest): ListDeploymentConfigsResponse {
        val op = SdkHttpOperation.build<ListDeploymentConfigsRequest, ListDeploymentConfigsResponse> {
            serializer = ListDeploymentConfigsOperationSerializer()
            deserializer = ListDeploymentConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeploymentConfigs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     */
    override suspend fun listDeploymentGroups(input: ListDeploymentGroupsRequest): ListDeploymentGroupsResponse {
        val op = SdkHttpOperation.build<ListDeploymentGroupsRequest, ListDeploymentGroupsResponse> {
            serializer = ListDeploymentGroupsOperationSerializer()
            deserializer = ListDeploymentGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeploymentGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The newer `BatchGetDeploymentTargets` should be used instead because it works with all compute types. `ListDeploymentInstances` throws an exception if it is used with a compute platform other than EC2/On-premises or AWS Lambda.
     *
     *  Lists the instance for a deployment associated with the IAM user or AWS account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listDeploymentInstances(input: ListDeploymentInstancesRequest): ListDeploymentInstancesResponse {
        val op = SdkHttpOperation.build<ListDeploymentInstancesRequest, ListDeploymentInstancesResponse> {
            serializer = ListDeploymentInstancesOperationSerializer()
            deserializer = ListDeploymentInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeploymentInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of target IDs that are associated a deployment.
     */
    override suspend fun listDeploymentTargets(input: ListDeploymentTargetsRequest): ListDeploymentTargetsResponse {
        val op = SdkHttpOperation.build<ListDeploymentTargetsRequest, ListDeploymentTargetsResponse> {
            serializer = ListDeploymentTargetsOperationSerializer()
            deserializer = ListDeploymentTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeploymentTargets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     */
    override suspend fun listDeployments(input: ListDeploymentsRequest): ListDeploymentsResponse {
        val op = SdkHttpOperation.build<ListDeploymentsRequest, ListDeploymentsResponse> {
            serializer = ListDeploymentsOperationSerializer()
            deserializer = ListDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeployments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the names of stored connections to GitHub accounts.
     */
    override suspend fun listGitHubAccountTokenNames(input: ListGitHubAccountTokenNamesRequest): ListGitHubAccountTokenNamesResponse {
        val op = SdkHttpOperation.build<ListGitHubAccountTokenNamesRequest, ListGitHubAccountTokenNamesResponse> {
            serializer = ListGitHubAccountTokenNamesOperationSerializer()
            deserializer = ListGitHubAccountTokenNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGitHubAccountTokenNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of names for one or more on-premises instances.
     *
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.
     */
    override suspend fun listOnPremisesInstances(input: ListOnPremisesInstancesRequest): ListOnPremisesInstancesResponse {
        val op = SdkHttpOperation.build<ListOnPremisesInstancesRequest, ListOnPremisesInstancesResponse> {
            serializer = ListOnPremisesInstancesOperationSerializer()
            deserializer = ListOnPremisesInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOnPremisesInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For Amazon ECS deployments, the available lifecycle hooks are `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`, `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation functions return `Succeeded` or `Failed`. For more information, see [AppSpec 'hooks' Section for an AWS Lambda Deployment ](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda) and [AppSpec 'hooks' Section for an Amazon ECS Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
     */
    override suspend fun putLifecycleEventHookExecutionStatus(input: PutLifecycleEventHookExecutionStatusRequest): PutLifecycleEventHookExecutionStatusResponse {
        val op = SdkHttpOperation.build<PutLifecycleEventHookExecutionStatusRequest, PutLifecycleEventHookExecutionStatusResponse> {
            serializer = PutLifecycleEventHookExecutionStatusOperationSerializer()
            deserializer = PutLifecycleEventHookExecutionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutLifecycleEventHookExecutionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers with AWS CodeDeploy a revision for the specified application.
     */
    override suspend fun registerApplicationRevision(input: RegisterApplicationRevisionRequest): RegisterApplicationRevisionResponse {
        val op = SdkHttpOperation.build<RegisterApplicationRevisionRequest, RegisterApplicationRevisionResponse> {
            serializer = RegisterApplicationRevisionOperationSerializer()
            deserializer = RegisterApplicationRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterApplicationRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an on-premises instance.
     *
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     */
    override suspend fun registerOnPremisesInstance(input: RegisterOnPremisesInstanceRequest): RegisterOnPremisesInstanceResponse {
        val op = SdkHttpOperation.build<RegisterOnPremisesInstanceRequest, RegisterOnPremisesInstanceResponse> {
            serializer = RegisterOnPremisesInstanceOperationSerializer()
            deserializer = RegisterOnPremisesInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterOnPremisesInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from one or more on-premises instances.
     */
    override suspend fun removeTagsFromOnPremisesInstances(input: RemoveTagsFromOnPremisesInstancesRequest): RemoveTagsFromOnPremisesInstancesResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromOnPremisesInstancesRequest, RemoveTagsFromOnPremisesInstancesResponse> {
            serializer = RemoveTagsFromOnPremisesInstancesOperationSerializer()
            deserializer = RemoveTagsFromOnPremisesInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTagsFromOnPremisesInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun skipWaitTimeForInstanceTermination(input: SkipWaitTimeForInstanceTerminationRequest): SkipWaitTimeForInstanceTerminationResponse {
        val op = SdkHttpOperation.build<SkipWaitTimeForInstanceTerminationRequest, SkipWaitTimeForInstanceTerminationResponse> {
            serializer = SkipWaitTimeForInstanceTerminationOperationSerializer()
            deserializer = SkipWaitTimeForInstanceTerminationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SkipWaitTimeForInstanceTermination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to stop an ongoing deployment.
     */
    override suspend fun stopDeployment(input: StopDeploymentRequest): StopDeploymentResponse {
        val op = SdkHttpOperation.build<StopDeploymentRequest, StopDeploymentResponse> {
            serializer = StopDeploymentOperationSerializer()
            deserializer = StopDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the list of tags in the input `Tags` parameter with the resource identified by the `ResourceArn` input parameter.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a resource from a list of tags. The resource is identified by the `ResourceArn` input parameter. The tags are identified by the list of keys in the `TagKeys` input parameter.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the name of an application.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a deployment group.
     */
    override suspend fun updateDeploymentGroup(input: UpdateDeploymentGroupRequest): UpdateDeploymentGroupResponse {
        val op = SdkHttpOperation.build<UpdateDeploymentGroupRequest, UpdateDeploymentGroupResponse> {
            serializer = UpdateDeploymentGroupOperationSerializer()
            deserializer = UpdateDeploymentGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDeploymentGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeDeploy_20141006", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codedeploy"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "codedeploy")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
