// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `ListApplicationRevisions` operation.
 */
class ListApplicationRevisionsRequest private constructor(builder: Builder) {
    /**
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * Whether to list revisions based on whether the revision is the target revision of a deployment group:
     * + `include`: List revisions that are target revisions of a deployment group.
     * + `exclude`: Do not list revisions that are target revisions of a deployment group.
     * + `ignore`: List all revisions.
     */
    val deployed: aws.sdk.kotlin.services.codedeploy.model.ListStateFilterAction? = builder.deployed
    /**
     * An identifier returned from the previous `ListApplicationRevisions` call. It can be used to return the next set of applications in the list.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * An Amazon S3 bucket name to limit the search for revisions.
     *
     *  If set to null, all of the user's buckets are searched.
     */
    val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     */
    val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * The column name to use to sort the list results:
     * + `registerTime`: Sort by the time the revisions were registered with AWS CodeDeploy.
     * + `firstUsedTime`: Sort by the time the revisions were first used in a deployment.
     * + `lastUsedTime`: Sort by the time the revisions were last used in a deployment.
     *
     *  If not specified or set to null, the results are returned in an arbitrary order.
     */
    val sortBy: aws.sdk.kotlin.services.codedeploy.model.ApplicationRevisionSortBy? = builder.sortBy
    /**
     * The order in which to sort the list results:
     * + `ascending`: ascending order.
     * + `descending`: descending order.
     *
     * If not specified, the results are sorted in ascending order.
     *
     * If set to null, the results are sorted in an arbitrary order.
     */
    val sortOrder: aws.sdk.kotlin.services.codedeploy.model.SortOrder? = builder.sortOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListApplicationRevisionsRequest(")
        append("applicationName=$applicationName,")
        append("deployed=$deployed,")
        append("nextToken=$nextToken,")
        append("s3Bucket=$s3Bucket,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (deployed?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListApplicationRevisionsRequest

        if (applicationName != other.applicationName) return false
        if (deployed != other.deployed) return false
        if (nextToken != other.nextToken) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
         */
        var applicationName: kotlin.String? = null
        /**
         * Whether to list revisions based on whether the revision is the target revision of a deployment group:
         * + `include`: List revisions that are target revisions of a deployment group.
         * + `exclude`: Do not list revisions that are target revisions of a deployment group.
         * + `ignore`: List all revisions.
         */
        var deployed: aws.sdk.kotlin.services.codedeploy.model.ListStateFilterAction? = null
        /**
         * An identifier returned from the previous `ListApplicationRevisions` call. It can be used to return the next set of applications in the list.
         */
        var nextToken: kotlin.String? = null
        /**
         * An Amazon S3 bucket name to limit the search for revisions.
         *
         *  If set to null, all of the user's buckets are searched.
         */
        var s3Bucket: kotlin.String? = null
        /**
         * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         */
        var s3KeyPrefix: kotlin.String? = null
        /**
         * The column name to use to sort the list results:
         * + `registerTime`: Sort by the time the revisions were registered with AWS CodeDeploy.
         * + `firstUsedTime`: Sort by the time the revisions were first used in a deployment.
         * + `lastUsedTime`: Sort by the time the revisions were last used in a deployment.
         *
         *  If not specified or set to null, the results are returned in an arbitrary order.
         */
        var sortBy: aws.sdk.kotlin.services.codedeploy.model.ApplicationRevisionSortBy? = null
        /**
         * The order in which to sort the list results:
         * + `ascending`: ascending order.
         * + `descending`: descending order.
         *
         * If not specified, the results are sorted in ascending order.
         *
         * If set to null, the results are sorted in an arbitrary order.
         */
        var sortOrder: aws.sdk.kotlin.services.codedeploy.model.SortOrder? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest) : this() {
            this.applicationName = x.applicationName
            this.deployed = x.deployed
            this.nextToken = x.nextToken
            this.s3Bucket = x.s3Bucket
            this.s3KeyPrefix = x.s3KeyPrefix
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest = ListApplicationRevisionsRequest(this)
    }
}
