// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the location of application artifacts stored in Amazon S3.
 */
public class S3Location private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket where the application revision is stored.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The file type of the application revision. Must be one of the following:
     * + `tar`: A tar archive file.
     * + `tgz`: A compressed tar archive file.
     * + `zip`: A zip archive file.
     */
    public val bundleType: aws.sdk.kotlin.services.codedeploy.model.BundleType? = builder.bundleType
    /**
     * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
     *
     * If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
     */
    public val key: kotlin.String? = builder.key
    /**
     * A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.
     *
     * If the version is not specified, the system uses the most recent version by default.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucket=$bucket,")
        append("bundleType=$bundleType,")
        append("eTag=$eTag,")
        append("key=$key,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (bundleType?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (bucket != other.bucket) return false
        if (bundleType != other.bundleType) return false
        if (eTag != other.eTag) return false
        if (key != other.key) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.S3Location = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Amazon S3 bucket where the application revision is stored.
         */
        public var bucket: kotlin.String? = null
        /**
         * The file type of the application revision. Must be one of the following:
         * + `tar`: A tar archive file.
         * + `tgz`: A compressed tar archive file.
         * + `zip`: A zip archive file.
         */
        public var bundleType: aws.sdk.kotlin.services.codedeploy.model.BundleType? = null
        /**
         * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
         *
         * If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
         */
        public var eTag: kotlin.String? = null
        /**
         * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
         */
        public var key: kotlin.String? = null
        /**
         * A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.
         *
         * If the version is not specified, the system uses the most recent version by default.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.S3Location) : this() {
            this.bucket = x.bucket
            this.bundleType = x.bundleType
            this.eTag = x.eTag
            this.key = x.key
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.S3Location = S3Location(this)
    }
}
