// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.waiters

import aws.sdk.kotlin.services.codedeploy.CodeDeployClient
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentRequest
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun CodeDeployClient.waitUntilDeploymentSuccessful(request: GetDeploymentRequest): Outcome<GetDeploymentResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetDeploymentRequest, GetDeploymentResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val deploymentInfo = it?.deploymentInfo
            val status = deploymentInfo?.status
            status?.toString() == "Succeeded"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val deploymentInfo = it?.deploymentInfo
            val status = deploymentInfo?.status
            status?.toString() == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val deploymentInfo = it?.deploymentInfo
            val status = deploymentInfo?.status
            status?.toString() == "Stopped"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getDeployment(request) }
}

public suspend fun CodeDeployClient.waitUntilDeploymentSuccessful(block: GetDeploymentRequest.Builder.() -> Unit): Outcome<GetDeploymentResponse> =
    waitUntilDeploymentSuccessful(GetDeploymentRequest.Builder().apply(block).build())
