// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `CreateDeploymentGroup` operation.
 */
public class CreateDeploymentGroupRequest private constructor(builder: Builder) {
    /**
     * Information to add about Amazon CloudWatch alarms when the deployment group is created.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * Configuration information for an automatic rollback that is added when a deployment group is created.
     */
    public val autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * A list of associated Amazon EC2 Auto Scaling groups.
     */
    public val autoScalingGroups: List<String>? = builder.autoScalingGroups
    /**
     * Information about blue/green deployment options for a deployment group.
     */
    public val blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * If specified, the deployment configuration name can be either one of the predefined configurations provided with CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.
     *
     * `CodeDeployDefault.OneAtATime` is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.
     *
     * For more information about the predefined deployment configurations in CodeDeploy, see [Working with Deployment Configurations in CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html) in the *CodeDeploy User Guide*.
     */
    public val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * The name of a new deployment group for the specified application.
     */
    public val deploymentGroupName: kotlin.String? = builder.deploymentGroupName
    /**
     * Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.
     */
    public val deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = builder.deploymentStyle
    /**
     * The Amazon EC2 tags on which to filter. The deployment group includes Amazon EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.
     */
    public val ec2TagFilters: List<Ec2TagFilter>? = builder.ec2TagFilters
    /**
     * Information about groups of tags applied to Amazon EC2 instances. The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as `ec2TagFilters`.
     */
    public val ec2TagSet: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet? = builder.ec2TagSet
    /**
     * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format `<clustername>:<servicename>`.
     */
    public val ecsServices: List<EcsService>? = builder.ecsServices
    /**
     * Information about the load balancer used in a deployment.
     */
    public val loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as `OnPremisesTagSet`.
     */
    public val onPremisesInstanceTagFilters: List<TagFilter>? = builder.onPremisesInstanceTagFilters
    /**
     * Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as `onPremisesInstanceTagFilters`.
     */
    public val onPremisesTagSet: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet? = builder.onPremisesTagSet
    /**
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
     *
     * If this option is set to `UPDATE` or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     *
     * If this option is set to `IGNORE`, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
     */
    public val outdatedInstancesStrategy: aws.sdk.kotlin.services.codedeploy.model.OutdatedInstancesStrategy? = builder.outdatedInstancesStrategy
    /**
     * A service role Amazon Resource Name (ARN) that allows CodeDeploy to act on the user's behalf when interacting with Amazon Web Services services.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Information about triggers to create when the deployment group is created. For examples, see [Create a Trigger for an CodeDeploy Event](https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html) in the *CodeDeploy User Guide*.
     */
    public val triggerConfigurations: List<TriggerConfig>? = builder.triggerConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentGroupRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("autoScalingGroups=$autoScalingGroups,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("deploymentStyle=$deploymentStyle,")
        append("ec2TagFilters=$ec2TagFilters,")
        append("ec2TagSet=$ec2TagSet,")
        append("ecsServices=$ecsServices,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("onPremisesInstanceTagFilters=$onPremisesInstanceTagFilters,")
        append("onPremisesTagSet=$onPremisesTagSet,")
        append("outdatedInstancesStrategy=$outdatedInstancesStrategy,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("tags=$tags,")
        append("triggerConfigurations=$triggerConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroups?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (ec2TagFilters?.hashCode() ?: 0)
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (ecsServices?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (onPremisesInstanceTagFilters?.hashCode() ?: 0)
        result = 31 * result + (onPremisesTagSet?.hashCode() ?: 0)
        result = 31 * result + (outdatedInstancesStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (triggerConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentGroupRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (autoScalingGroups != other.autoScalingGroups) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (ec2TagFilters != other.ec2TagFilters) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (ecsServices != other.ecsServices) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (onPremisesInstanceTagFilters != other.onPremisesInstanceTagFilters) return false
        if (onPremisesTagSet != other.onPremisesTagSet) return false
        if (outdatedInstancesStrategy != other.outdatedInstancesStrategy) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (tags != other.tags) return false
        if (triggerConfigurations != other.triggerConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information to add about Amazon CloudWatch alarms when the deployment group is created.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = null
        /**
         * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Configuration information for an automatic rollback that is added when a deployment group is created.
         */
        public var autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = null
        /**
         * A list of associated Amazon EC2 Auto Scaling groups.
         */
        public var autoScalingGroups: List<String>? = null
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        public var blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = null
        /**
         * If specified, the deployment configuration name can be either one of the predefined configurations provided with CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.
         *
         * `CodeDeployDefault.OneAtATime` is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.
         *
         * For more information about the predefined deployment configurations in CodeDeploy, see [Working with Deployment Configurations in CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html) in the *CodeDeploy User Guide*.
         */
        public var deploymentConfigName: kotlin.String? = null
        /**
         * The name of a new deployment group for the specified application.
         */
        public var deploymentGroupName: kotlin.String? = null
        /**
         * Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.
         */
        public var deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = null
        /**
         * The Amazon EC2 tags on which to filter. The deployment group includes Amazon EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.
         */
        public var ec2TagFilters: List<Ec2TagFilter>? = null
        /**
         * Information about groups of tags applied to Amazon EC2 instances. The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as `ec2TagFilters`.
         */
        public var ec2TagSet: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet? = null
        /**
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format `<clustername>:<servicename>`.
         */
        public var ecsServices: List<EcsService>? = null
        /**
         * Information about the load balancer used in a deployment.
         */
        public var loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = null
        /**
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as `OnPremisesTagSet`.
         */
        public var onPremisesInstanceTagFilters: List<TagFilter>? = null
        /**
         * Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as `onPremisesInstanceTagFilters`.
         */
        public var onPremisesTagSet: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet? = null
        /**
         * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
         *
         * If this option is set to `UPDATE` or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
         *
         * If this option is set to `IGNORE`, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
         */
        public var outdatedInstancesStrategy: aws.sdk.kotlin.services.codedeploy.model.OutdatedInstancesStrategy? = null
        /**
         * A service role Amazon Resource Name (ARN) that allows CodeDeploy to act on the user's behalf when interacting with Amazon Web Services services.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define.
         */
        public var tags: List<Tag>? = null
        /**
         * Information about triggers to create when the deployment group is created. For examples, see [Create a Trigger for an CodeDeploy Event](https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html) in the *CodeDeploy User Guide*.
         */
        public var triggerConfigurations: List<TriggerConfig>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentGroupRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.autoScalingGroups = x.autoScalingGroups
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupName = x.deploymentGroupName
            this.deploymentStyle = x.deploymentStyle
            this.ec2TagFilters = x.ec2TagFilters
            this.ec2TagSet = x.ec2TagSet
            this.ecsServices = x.ecsServices
            this.loadBalancerInfo = x.loadBalancerInfo
            this.onPremisesInstanceTagFilters = x.onPremisesInstanceTagFilters
            this.onPremisesTagSet = x.onPremisesTagSet
            this.outdatedInstancesStrategy = x.outdatedInstancesStrategy
            this.serviceRoleArn = x.serviceRoleArn
            this.tags = x.tags
            this.triggerConfigurations = x.triggerConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentGroupRequest = CreateDeploymentGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        public fun autoRollbackConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        public fun blueGreenDeploymentConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        public fun deploymentStyle(block: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.Builder.() -> kotlin.Unit) {
            this.deploymentStyle = aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        public fun ec2TagSet(block: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet.Builder.() -> kotlin.Unit) {
            this.ec2TagSet = aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        public fun loadBalancerInfo(block: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.Builder.() -> kotlin.Unit) {
            this.loadBalancerInfo = aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet] inside the given [block]
         */
        public fun onPremisesTagSet(block: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet.Builder.() -> kotlin.Unit) {
            this.onPremisesTagSet = aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet.invoke(block)
        }
    }
}
