// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a deployment.
 */
public class DeploymentInfo private constructor(builder: Builder) {
    /**
     * Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.
     */
    public val additionalDeploymentStatusInfo: kotlin.String? = builder.additionalDeploymentStatusInfo
    /**
     * The application name.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * Information about the automatic rollback configuration associated with the deployment.
     */
    public val autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * Information about blue/green deployment options for this deployment.
     */
    public val blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * A timestamp that indicates when the deployment was complete.
     */
    public val completeTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completeTime
    /**
     * The destination platform type for the deployment (`Lambda`, `Server`, or `ECS`).
     */
    public val computePlatform: aws.sdk.kotlin.services.codedeploy.model.ComputePlatform? = builder.computePlatform
    /**
     * A timestamp that indicates when the deployment was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The means by which the deployment was created:
     * + `user`: A user created the deployment.
     * + `autoscaling`: Amazon EC2 Auto Scaling created the deployment.
     * + `codeDeployRollback`: A rollback process created the deployment.
     * + `CodeDeployAutoUpdate`: An auto-update process created the deployment when it detected outdated Amazon EC2 instances.
     */
    public val creator: aws.sdk.kotlin.services.codedeploy.model.DeploymentCreator? = builder.creator
    /**
     * The deployment configuration name.
     */
    public val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * The deployment group name.
     */
    public val deploymentGroupName: kotlin.String? = builder.deploymentGroupName
    /**
     * The unique ID of a deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * A summary of the deployment status of the instances in the deployment.
     */
    public val deploymentOverview: aws.sdk.kotlin.services.codedeploy.model.DeploymentOverview? = builder.deploymentOverview
    /**
     * Messages that contain information about the status of a deployment.
     */
    public val deploymentStatusMessages: List<String>? = builder.deploymentStatusMessages
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.
     */
    public val deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = builder.deploymentStyle
    /**
     * A comment about the deployment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Information about any error associated with this deployment.
     */
    public val errorInformation: aws.sdk.kotlin.services.codedeploy.model.ErrorInformation? = builder.errorInformation
    /**
     * The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.
     * + `DISALLOW`: The deployment fails. This is also the default behavior if no option is specified.
     * + `OVERWRITE`: The version of the file from the application revision currently being deployed replaces the version already on the instance.
     * + `RETAIN`: The version of the file already on the instance is kept and used as part of the new deployment.
     */
    public val fileExistsBehavior: aws.sdk.kotlin.services.codedeploy.model.FileExistsBehavior? = builder.fileExistsBehavior
    /**
     * If true, then if an `ApplicationStop`, `BeforeBlockTraffic`, or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if `ApplicationStop` fails, the deployment continues with DownloadBundle. If `BeforeBlockTraffic` fails, the deployment continues with `BlockTraffic`. If `AfterBlockTraffic` fails, the deployment continues with `ApplicationStop`.
     *
     *  If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
     *
     *  During a deployment, the CodeDeploy agent runs the scripts specified for `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
     *
     *  If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use `ignoreApplicationStopFailures` to specify that the `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` failures should be ignored.
     */
    public val ignoreApplicationStopFailures: kotlin.Boolean = builder.ignoreApplicationStopFailures
    /**
     * Indicates whether the wait period set for the termination of instances in the original environment has started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period starts.
     */
    public val instanceTerminationWaitTimeStarted: kotlin.Boolean = builder.instanceTerminationWaitTimeStarted
    /**
     * Information about the load balancer used in the deployment.
     */
    public val loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * Information about alarms associated with a deployment or deployment group.
     */
    public val overrideAlarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = builder.overrideAlarmConfiguration
    /**
     * Information about the application revision that was deployed to the deployment group before the most recent successful deployment.
     */
    public val previousRevision: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation? = builder.previousRevision
    /**
     * Information about deployments related to the specified deployment.
     */
    public val relatedDeployments: aws.sdk.kotlin.services.codedeploy.model.RelatedDeployments? = builder.relatedDeployments
    /**
     * Information about the location of stored application artifacts and the service from which to retrieve them.
     */
    public val revision: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation? = builder.revision
    /**
     * Information about a deployment rollback.
     */
    public val rollbackInfo: aws.sdk.kotlin.services.codedeploy.model.RollbackInfo? = builder.rollbackInfo
    /**
     * A timestamp that indicates when the deployment was deployed to the deployment group.
     *
     * In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current state of the deployment as a whole.
     */
    public val status: aws.sdk.kotlin.services.codedeploy.model.DeploymentStatus? = builder.status
    /**
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     */
    public val targetInstances: aws.sdk.kotlin.services.codedeploy.model.TargetInstances? = builder.targetInstances
    /**
     * Indicates whether only instances that are not running the latest application revision are to be deployed to.
     */
    public val updateOutdatedInstancesOnly: kotlin.Boolean = builder.updateOutdatedInstancesOnly

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.DeploymentInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentInfo(")
        append("additionalDeploymentStatusInfo=$additionalDeploymentStatusInfo,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("completeTime=$completeTime,")
        append("computePlatform=$computePlatform,")
        append("createTime=$createTime,")
        append("creator=$creator,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("deploymentId=$deploymentId,")
        append("deploymentOverview=$deploymentOverview,")
        append("deploymentStatusMessages=$deploymentStatusMessages,")
        append("deploymentStyle=$deploymentStyle,")
        append("description=$description,")
        append("errorInformation=$errorInformation,")
        append("externalId=$externalId,")
        append("fileExistsBehavior=$fileExistsBehavior,")
        append("ignoreApplicationStopFailures=$ignoreApplicationStopFailures,")
        append("instanceTerminationWaitTimeStarted=$instanceTerminationWaitTimeStarted,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("overrideAlarmConfiguration=$overrideAlarmConfiguration,")
        append("previousRevision=$previousRevision,")
        append("relatedDeployments=$relatedDeployments,")
        append("revision=$revision,")
        append("rollbackInfo=$rollbackInfo,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("targetInstances=$targetInstances,")
        append("updateOutdatedInstancesOnly=$updateOutdatedInstancesOnly)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalDeploymentStatusInfo?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (completeTime?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (creator?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentOverview?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatusMessages?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorInformation?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (fileExistsBehavior?.hashCode() ?: 0)
        result = 31 * result + (ignoreApplicationStopFailures.hashCode())
        result = 31 * result + (instanceTerminationWaitTimeStarted.hashCode())
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (overrideAlarmConfiguration?.hashCode() ?: 0)
        result = 31 * result + (previousRevision?.hashCode() ?: 0)
        result = 31 * result + (relatedDeployments?.hashCode() ?: 0)
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (rollbackInfo?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetInstances?.hashCode() ?: 0)
        result = 31 * result + (updateOutdatedInstancesOnly.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentInfo

        if (additionalDeploymentStatusInfo != other.additionalDeploymentStatusInfo) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (completeTime != other.completeTime) return false
        if (computePlatform != other.computePlatform) return false
        if (createTime != other.createTime) return false
        if (creator != other.creator) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentOverview != other.deploymentOverview) return false
        if (deploymentStatusMessages != other.deploymentStatusMessages) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (description != other.description) return false
        if (errorInformation != other.errorInformation) return false
        if (externalId != other.externalId) return false
        if (fileExistsBehavior != other.fileExistsBehavior) return false
        if (ignoreApplicationStopFailures != other.ignoreApplicationStopFailures) return false
        if (instanceTerminationWaitTimeStarted != other.instanceTerminationWaitTimeStarted) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (overrideAlarmConfiguration != other.overrideAlarmConfiguration) return false
        if (previousRevision != other.previousRevision) return false
        if (relatedDeployments != other.relatedDeployments) return false
        if (revision != other.revision) return false
        if (rollbackInfo != other.rollbackInfo) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (targetInstances != other.targetInstances) return false
        if (updateOutdatedInstancesOnly != other.updateOutdatedInstancesOnly) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.DeploymentInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.
         */
        public var additionalDeploymentStatusInfo: kotlin.String? = null
        /**
         * The application name.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Information about the automatic rollback configuration associated with the deployment.
         */
        public var autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = null
        /**
         * Information about blue/green deployment options for this deployment.
         */
        public var blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = null
        /**
         * A timestamp that indicates when the deployment was complete.
         */
        public var completeTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The destination platform type for the deployment (`Lambda`, `Server`, or `ECS`).
         */
        public var computePlatform: aws.sdk.kotlin.services.codedeploy.model.ComputePlatform? = null
        /**
         * A timestamp that indicates when the deployment was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The means by which the deployment was created:
         * + `user`: A user created the deployment.
         * + `autoscaling`: Amazon EC2 Auto Scaling created the deployment.
         * + `codeDeployRollback`: A rollback process created the deployment.
         * + `CodeDeployAutoUpdate`: An auto-update process created the deployment when it detected outdated Amazon EC2 instances.
         */
        public var creator: aws.sdk.kotlin.services.codedeploy.model.DeploymentCreator? = null
        /**
         * The deployment configuration name.
         */
        public var deploymentConfigName: kotlin.String? = null
        /**
         * The deployment group name.
         */
        public var deploymentGroupName: kotlin.String? = null
        /**
         * The unique ID of a deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * A summary of the deployment status of the instances in the deployment.
         */
        public var deploymentOverview: aws.sdk.kotlin.services.codedeploy.model.DeploymentOverview? = null
        /**
         * Messages that contain information about the status of a deployment.
         */
        public var deploymentStatusMessages: List<String>? = null
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.
         */
        public var deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = null
        /**
         * A comment about the deployment.
         */
        public var description: kotlin.String? = null
        /**
         * Information about any error associated with this deployment.
         */
        public var errorInformation: aws.sdk.kotlin.services.codedeploy.model.ErrorInformation? = null
        /**
         * The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.
         */
        public var externalId: kotlin.String? = null
        /**
         * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.
         * + `DISALLOW`: The deployment fails. This is also the default behavior if no option is specified.
         * + `OVERWRITE`: The version of the file from the application revision currently being deployed replaces the version already on the instance.
         * + `RETAIN`: The version of the file already on the instance is kept and used as part of the new deployment.
         */
        public var fileExistsBehavior: aws.sdk.kotlin.services.codedeploy.model.FileExistsBehavior? = null
        /**
         * If true, then if an `ApplicationStop`, `BeforeBlockTraffic`, or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if `ApplicationStop` fails, the deployment continues with DownloadBundle. If `BeforeBlockTraffic` fails, the deployment continues with `BlockTraffic`. If `AfterBlockTraffic` fails, the deployment continues with `ApplicationStop`.
         *
         *  If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
         *
         *  During a deployment, the CodeDeploy agent runs the scripts specified for `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
         *
         *  If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use `ignoreApplicationStopFailures` to specify that the `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` failures should be ignored.
         */
        public var ignoreApplicationStopFailures: kotlin.Boolean = false
        /**
         * Indicates whether the wait period set for the termination of instances in the original environment has started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period starts.
         */
        public var instanceTerminationWaitTimeStarted: kotlin.Boolean = false
        /**
         * Information about the load balancer used in the deployment.
         */
        public var loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = null
        /**
         * Information about alarms associated with a deployment or deployment group.
         */
        public var overrideAlarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = null
        /**
         * Information about the application revision that was deployed to the deployment group before the most recent successful deployment.
         */
        public var previousRevision: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation? = null
        /**
         * Information about deployments related to the specified deployment.
         */
        public var relatedDeployments: aws.sdk.kotlin.services.codedeploy.model.RelatedDeployments? = null
        /**
         * Information about the location of stored application artifacts and the service from which to retrieve them.
         */
        public var revision: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation? = null
        /**
         * Information about a deployment rollback.
         */
        public var rollbackInfo: aws.sdk.kotlin.services.codedeploy.model.RollbackInfo? = null
        /**
         * A timestamp that indicates when the deployment was deployed to the deployment group.
         *
         * In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of the deployment as a whole.
         */
        public var status: aws.sdk.kotlin.services.codedeploy.model.DeploymentStatus? = null
        /**
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         */
        public var targetInstances: aws.sdk.kotlin.services.codedeploy.model.TargetInstances? = null
        /**
         * Indicates whether only instances that are not running the latest application revision are to be deployed to.
         */
        public var updateOutdatedInstancesOnly: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.DeploymentInfo) : this() {
            this.additionalDeploymentStatusInfo = x.additionalDeploymentStatusInfo
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.completeTime = x.completeTime
            this.computePlatform = x.computePlatform
            this.createTime = x.createTime
            this.creator = x.creator
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupName = x.deploymentGroupName
            this.deploymentId = x.deploymentId
            this.deploymentOverview = x.deploymentOverview
            this.deploymentStatusMessages = x.deploymentStatusMessages
            this.deploymentStyle = x.deploymentStyle
            this.description = x.description
            this.errorInformation = x.errorInformation
            this.externalId = x.externalId
            this.fileExistsBehavior = x.fileExistsBehavior
            this.ignoreApplicationStopFailures = x.ignoreApplicationStopFailures
            this.instanceTerminationWaitTimeStarted = x.instanceTerminationWaitTimeStarted
            this.loadBalancerInfo = x.loadBalancerInfo
            this.overrideAlarmConfiguration = x.overrideAlarmConfiguration
            this.previousRevision = x.previousRevision
            this.relatedDeployments = x.relatedDeployments
            this.revision = x.revision
            this.rollbackInfo = x.rollbackInfo
            this.startTime = x.startTime
            this.status = x.status
            this.targetInstances = x.targetInstances
            this.updateOutdatedInstancesOnly = x.updateOutdatedInstancesOnly
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.DeploymentInfo = DeploymentInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        public fun autoRollbackConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        public fun blueGreenDeploymentConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentOverview] inside the given [block]
         */
        public fun deploymentOverview(block: aws.sdk.kotlin.services.codedeploy.model.DeploymentOverview.Builder.() -> kotlin.Unit) {
            this.deploymentOverview = aws.sdk.kotlin.services.codedeploy.model.DeploymentOverview.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        public fun deploymentStyle(block: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.Builder.() -> kotlin.Unit) {
            this.deploymentStyle = aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.ErrorInformation] inside the given [block]
         */
        public fun errorInformation(block: aws.sdk.kotlin.services.codedeploy.model.ErrorInformation.Builder.() -> kotlin.Unit) {
            this.errorInformation = aws.sdk.kotlin.services.codedeploy.model.ErrorInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        public fun loadBalancerInfo(block: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.Builder.() -> kotlin.Unit) {
            this.loadBalancerInfo = aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        public fun overrideAlarmConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.overrideAlarmConfiguration = aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        public fun previousRevision(block: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation.Builder.() -> kotlin.Unit) {
            this.previousRevision = aws.sdk.kotlin.services.codedeploy.model.RevisionLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RelatedDeployments] inside the given [block]
         */
        public fun relatedDeployments(block: aws.sdk.kotlin.services.codedeploy.model.RelatedDeployments.Builder.() -> kotlin.Unit) {
            this.relatedDeployments = aws.sdk.kotlin.services.codedeploy.model.RelatedDeployments.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        public fun revision(block: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation.Builder.() -> kotlin.Unit) {
            this.revision = aws.sdk.kotlin.services.codedeploy.model.RevisionLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RollbackInfo] inside the given [block]
         */
        public fun rollbackInfo(block: aws.sdk.kotlin.services.codedeploy.model.RollbackInfo.Builder.() -> kotlin.Unit) {
            this.rollbackInfo = aws.sdk.kotlin.services.codedeploy.model.RollbackInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TargetInstances] inside the given [block]
         */
        public fun targetInstances(block: aws.sdk.kotlin.services.codedeploy.model.TargetInstances.Builder.() -> kotlin.Unit) {
            this.targetInstances = aws.sdk.kotlin.services.codedeploy.model.TargetInstances.invoke(block)
        }
    }
}
