// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target of an Amazon ECS deployment.
 */
public class EcsTarget private constructor(builder: Builder) {
    /**
     * The unique ID of a deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The date and time when the target Amazon ECS application was updated by a deployment.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the deployment to this target Amazon ECS application.
     */
    public val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The status an Amazon ECS deployment's target ECS application.
     */
    public val status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    public val targetArn: kotlin.String? = builder.targetArn
    /**
     * The unique ID of a deployment target that has a type of `ecsTarget`.
     */
    public val targetId: kotlin.String? = builder.targetId
    /**
     * The `ECSTaskSet` objects associated with the ECS target.
     */
    public val taskSetsInfo: List<EcsTaskSet>? = builder.taskSetsInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.EcsTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsTarget(")
        append("deploymentId=$deploymentId,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("targetId=$targetId,")
        append("taskSetsInfo=$taskSetsInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (taskSetsInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsTarget

        if (deploymentId != other.deploymentId) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (targetId != other.targetId) return false
        if (taskSetsInfo != other.taskSetsInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.EcsTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of a deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The date and time when the target Amazon ECS application was updated by a deployment.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle events of the deployment to this target Amazon ECS application.
         */
        public var lifecycleEvents: List<LifecycleEvent>? = null
        /**
         * The status an Amazon ECS deployment's target ECS application.
         */
        public var status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        public var targetArn: kotlin.String? = null
        /**
         * The unique ID of a deployment target that has a type of `ecsTarget`.
         */
        public var targetId: kotlin.String? = null
        /**
         * The `ECSTaskSet` objects associated with the ECS target.
         */
        public var taskSetsInfo: List<EcsTaskSet>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.EcsTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.status = x.status
            this.targetArn = x.targetArn
            this.targetId = x.targetId
            this.taskSetsInfo = x.taskSetsInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.EcsTarget = EcsTarget(this)
    }
}
