// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `ListDeployments` operation.
 */
public class ListDeploymentsRequest private constructor(builder: Builder) {
    /**
     * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
     *
     * If `applicationName` is specified, then `deploymentGroupName` must be specified. If it is not specified, then `deploymentGroupName` must not be specified.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * A time range (start and end) for returning a subset of the list of deployments.
     */
    public val createTimeRange: aws.sdk.kotlin.services.codedeploy.model.TimeRange? = builder.createTimeRange
    /**
     * The name of a deployment group for the specified application.
     *
     * If `deploymentGroupName` is specified, then `applicationName` must be specified. If it is not specified, then `applicationName` must not be specified.
     */
    public val deploymentGroupName: kotlin.String? = builder.deploymentGroupName
    /**
     * The unique ID of an external resource for returning deployments linked to the external resource.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * A subset of deployments to list by status:
     * + `Created`: Include created deployments in the resulting list.
     * + `Queued`: Include queued deployments in the resulting list.
     * + `In Progress`: Include in-progress deployments in the resulting list.
     * + `Succeeded`: Include successful deployments in the resulting list.
     * + `Failed`: Include failed deployments in the resulting list.
     * + `Stopped`: Include stopped deployments in the resulting list.
     */
    public val includeOnlyStatuses: List<DeploymentStatus>? = builder.includeOnlyStatuses
    /**
     * An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeploymentsRequest(")
        append("applicationName=$applicationName,")
        append("createTimeRange=$createTimeRange,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("externalId=$externalId,")
        append("includeOnlyStatuses=$includeOnlyStatuses,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (createTimeRange?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (includeOnlyStatuses?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDeploymentsRequest

        if (applicationName != other.applicationName) return false
        if (createTimeRange != other.createTimeRange) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (externalId != other.externalId) return false
        if (includeOnlyStatuses != other.includeOnlyStatuses) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
         *
         * If `applicationName` is specified, then `deploymentGroupName` must be specified. If it is not specified, then `deploymentGroupName` must not be specified.
         */
        public var applicationName: kotlin.String? = null
        /**
         * A time range (start and end) for returning a subset of the list of deployments.
         */
        public var createTimeRange: aws.sdk.kotlin.services.codedeploy.model.TimeRange? = null
        /**
         * The name of a deployment group for the specified application.
         *
         * If `deploymentGroupName` is specified, then `applicationName` must be specified. If it is not specified, then `applicationName` must not be specified.
         */
        public var deploymentGroupName: kotlin.String? = null
        /**
         * The unique ID of an external resource for returning deployments linked to the external resource.
         */
        public var externalId: kotlin.String? = null
        /**
         * A subset of deployments to list by status:
         * + `Created`: Include created deployments in the resulting list.
         * + `Queued`: Include queued deployments in the resulting list.
         * + `In Progress`: Include in-progress deployments in the resulting list.
         * + `Succeeded`: Include successful deployments in the resulting list.
         * + `Failed`: Include failed deployments in the resulting list.
         * + `Stopped`: Include stopped deployments in the resulting list.
         */
        public var includeOnlyStatuses: List<DeploymentStatus>? = null
        /**
         * An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsRequest) : this() {
            this.applicationName = x.applicationName
            this.createTimeRange = x.createTimeRange
            this.deploymentGroupName = x.deploymentGroupName
            this.externalId = x.externalId
            this.includeOnlyStatuses = x.includeOnlyStatuses
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsRequest = ListDeploymentsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TimeRange] inside the given [block]
         */
        public fun createTimeRange(block: aws.sdk.kotlin.services.codedeploy.model.TimeRange.Builder.() -> kotlin.Unit) {
            this.createTimeRange = aws.sdk.kotlin.services.codedeploy.model.TimeRange.invoke(block)
        }
    }
}
