// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AddTagsToOnPremisesInstancesOperationDeserializer: HttpDeserialize<AddTagsToOnPremisesInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AddTagsToOnPremisesInstancesResponse {
        if (!response.status.isSuccess()) {
            throwAddTagsToOnPremisesInstancesError(context, response)
        }
        val builder = AddTagsToOnPremisesInstancesResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAddTagsToOnPremisesInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InstanceLimitExceededException" -> InstanceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InstanceNameRequiredException" -> InstanceNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InstanceNotRegisteredException" -> InstanceNotRegisteredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInstanceNameException" -> InvalidInstanceNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedResponse)
        "TagLimitExceededException" -> TagLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "TagRequiredException" -> TagRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
