// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeleteGitHubAccountTokenResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteGitHubAccountTokenOperationDeserializer: HttpDeserialize<DeleteGitHubAccountTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteGitHubAccountTokenResponse {
        if (!response.status.isSuccess()) {
            throwDeleteGitHubAccountTokenError(context, response)
        }
        val builder = DeleteGitHubAccountTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteGitHubAccountTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteGitHubAccountTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "GitHubAccountTokenDoesNotExistException" -> GitHubAccountTokenDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "GitHubAccountTokenNameRequiredException" -> GitHubAccountTokenNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGitHubAccountTokenNameException" -> InvalidGitHubAccountTokenNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceValidationException" -> ResourceValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteGitHubAccountTokenOperationBody(builder: DeleteGitHubAccountTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TOKENNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TOKENNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TOKENNAME_DESCRIPTOR.index -> builder.tokenName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
