// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codedeploy.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codedeploy.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codedeploy.model.*
import aws.sdk.kotlin.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetApplicationRevisionsRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetApplicationRevisionsResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetApplicationsRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetApplicationsResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentGroupsRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentGroupsResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentTargetsRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentTargetsResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentsRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentsResponse
import aws.sdk.kotlin.services.codedeploy.model.BatchGetOnPremisesInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.BatchGetOnPremisesInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.ContinueDeploymentRequest
import aws.sdk.kotlin.services.codedeploy.model.ContinueDeploymentResponse
import aws.sdk.kotlin.services.codedeploy.model.CreateApplicationRequest
import aws.sdk.kotlin.services.codedeploy.model.CreateApplicationResponse
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigRequest
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigResponse
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentGroupRequest
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentGroupResponse
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.codedeploy.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.codedeploy.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.codedeploy.model.DeleteDeploymentConfigRequest
import aws.sdk.kotlin.services.codedeploy.model.DeleteDeploymentConfigResponse
import aws.sdk.kotlin.services.codedeploy.model.DeleteDeploymentGroupRequest
import aws.sdk.kotlin.services.codedeploy.model.DeleteDeploymentGroupResponse
import aws.sdk.kotlin.services.codedeploy.model.DeleteGitHubAccountTokenRequest
import aws.sdk.kotlin.services.codedeploy.model.DeleteGitHubAccountTokenResponse
import aws.sdk.kotlin.services.codedeploy.model.DeleteResourcesByExternalIdRequest
import aws.sdk.kotlin.services.codedeploy.model.DeleteResourcesByExternalIdResponse
import aws.sdk.kotlin.services.codedeploy.model.DeregisterOnPremisesInstanceRequest
import aws.sdk.kotlin.services.codedeploy.model.DeregisterOnPremisesInstanceResponse
import aws.sdk.kotlin.services.codedeploy.model.GetApplicationRequest
import aws.sdk.kotlin.services.codedeploy.model.GetApplicationResponse
import aws.sdk.kotlin.services.codedeploy.model.GetApplicationRevisionRequest
import aws.sdk.kotlin.services.codedeploy.model.GetApplicationRevisionResponse
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentConfigRequest
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentConfigResponse
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentGroupRequest
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentGroupResponse
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentInstanceRequest
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentInstanceResponse
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentRequest
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentResponse
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentTargetRequest
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentTargetResponse
import aws.sdk.kotlin.services.codedeploy.model.GetOnPremisesInstanceRequest
import aws.sdk.kotlin.services.codedeploy.model.GetOnPremisesInstanceResponse
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentConfigsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentConfigsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentGroupsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentGroupsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentTargetsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentTargetsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListGitHubAccountTokenNamesRequest
import aws.sdk.kotlin.services.codedeploy.model.ListGitHubAccountTokenNamesResponse
import aws.sdk.kotlin.services.codedeploy.model.ListOnPremisesInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.ListOnPremisesInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codedeploy.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest
import aws.sdk.kotlin.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse
import aws.sdk.kotlin.services.codedeploy.model.RegisterApplicationRevisionRequest
import aws.sdk.kotlin.services.codedeploy.model.RegisterApplicationRevisionResponse
import aws.sdk.kotlin.services.codedeploy.model.RegisterOnPremisesInstanceRequest
import aws.sdk.kotlin.services.codedeploy.model.RegisterOnPremisesInstanceResponse
import aws.sdk.kotlin.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.SkipWaitTimeForInstanceTerminationRequest
import aws.sdk.kotlin.services.codedeploy.model.SkipWaitTimeForInstanceTerminationResponse
import aws.sdk.kotlin.services.codedeploy.model.StopDeploymentRequest
import aws.sdk.kotlin.services.codedeploy.model.StopDeploymentResponse
import aws.sdk.kotlin.services.codedeploy.model.TagResourceRequest
import aws.sdk.kotlin.services.codedeploy.model.TagResourceResponse
import aws.sdk.kotlin.services.codedeploy.model.UntagResourceRequest
import aws.sdk.kotlin.services.codedeploy.model.UntagResourceResponse
import aws.sdk.kotlin.services.codedeploy.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.codedeploy.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest
import aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances, on-premises instances running in your own facility, serverless Lambda functions, or applications in an Amazon ECS service.
 *
 * You can deploy a nearly unlimited variety of application content, such as an updated Lambda function, updated applications in an Amazon ECS service, code, web and configuration files, executables, packages, scripts, multimedia files, and so on. CodeDeploy can deploy application content stored in Amazon S3 buckets, GitHub repositories, or Bitbucket repositories. You do not need to make changes to your existing code before you can use CodeDeploy.
 *
 * CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application deployment, and handles the complexity of updating your applications, without many of the risks associated with error-prone manual deployments.
 *
 * **CodeDeploy Components**
 *
 * Use the information in this guide to help you work with the following CodeDeploy components:
 * + **Application**: A name that uniquely identifies the application you want to deploy. CodeDeploy uses this name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and deployment group are referenced during a deployment.
 * + **Deployment group**: A set of individual instances, CodeDeploy Lambda deployment configuration settings, or an Amazon ECS service and network details. A Lambda deployment group specifies how to route traffic to a new version of a Lambda function. An Amazon ECS deployment group specifies the service created in Amazon ECS to deploy, a load balancer, and a listener to reroute production traffic to an updated containerized application. An Amazon EC2/On-premises deployment group contains individually tagged instances, Amazon EC2 instances in Amazon EC2 Auto Scaling groups, or both. All deployment groups can specify optional trigger, alarm, and rollback settings.
 * + **Deployment configuration**: A set of deployment rules and deployment success and failure conditions used by CodeDeploy during a deployment.
 * + **Deployment**: The process and the components used when updating a Lambda function, a containerized application in an Amazon ECS service, or of installing content on one or more instances.
 * + **Application revisions**: For an Lambda deployment, this is an AppSpec file that specifies the Lambda function to be updated and one or more functions to validate deployment lifecycle events. For an Amazon ECS deployment, this is an AppSpec file that specifies the Amazon ECS task definition, container, and port where production traffic is rerouted. For an EC2/On-premises deployment, this is an archive file that contains source content—source code, webpages, executable files, and deployment scripts—along with an AppSpec file. Revisions are stored in Amazon S3 buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3 object key and its ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.
 *
 * This guide also contains information to help you get details about the instances in your deployments, to make on-premises instances available for CodeDeploy deployments, to get details about a Lambda function deployment, and to get details about Amazon ECS service deployments.
 *
 * **CodeDeploy Information Resources**
 * + [CodeDeploy User Guide](https://docs.aws.amazon.com/codedeploy/latest/userguide)
 * + [CodeDeploy API Reference Guide](https://docs.aws.amazon.com/codedeploy/latest/APIReference/)
 * + [CLI Reference for CodeDeploy](https://docs.aws.amazon.com/cli/latest/reference/deploy/index.html)
 * + [CodeDeploy Developer Forum](https://forums.aws.amazon.com/forum.jspa?forumID=179)
 */
public interface CodeDeployClient : SdkClient {

    override val serviceName: String
        get() = "CodeDeploy"
    /**
     * CodeDeployClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CodeDeployClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeDeployClient(config)
        }

        public operator fun invoke(config: Config): CodeDeployClient = DefaultCodeDeployClient(config)

        /**
         * Construct a [CodeDeployClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeDeployClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCodeDeployClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CodeDeploy")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds tags to on-premises instances.
     */
    public suspend fun addTagsToOnPremisesInstances(input: AddTagsToOnPremisesInstancesRequest): AddTagsToOnPremisesInstancesResponse

    /**
     * Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.
     */
    public suspend fun batchGetApplicationRevisions(input: BatchGetApplicationRevisionsRequest): BatchGetApplicationRevisionsResponse

    /**
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     */
    public suspend fun batchGetApplications(input: BatchGetApplicationsRequest): BatchGetApplicationsResponse

    /**
     * Gets information about one or more deployment groups.
     */
    public suspend fun batchGetDeploymentGroups(input: BatchGetDeploymentGroupsRequest): BatchGetDeploymentGroupsResponse

    /**
     * This method works, but is deprecated. Use `BatchGetDeploymentTargets` instead.
     *
     *  Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and Lambda compute platforms. The newer `BatchGetDeploymentTargets` works with all compute platforms. The maximum number of instances that can be returned is 25.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun batchGetDeploymentInstances(input: BatchGetDeploymentInstancesRequest): BatchGetDeploymentInstancesResponse

    /**
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated `BatchGetDeploymentInstances`. The maximum number of targets that can be returned is 25.
     *
     *  The type of targets returned depends on the deployment's compute platform or deployment method:
     * + **EC2/On-premises**: Information about Amazon EC2 instance targets.
     * + **Lambda**: Information about Lambda functions targets.
     * + **Amazon ECS**: Information about Amazon ECS service targets.
     * + **CloudFormation**: Information about targets of blue/green deployments initiated by a CloudFormation stack update.
     */
    public suspend fun batchGetDeploymentTargets(input: BatchGetDeploymentTargetsRequest = BatchGetDeploymentTargetsRequest {}): BatchGetDeploymentTargetsResponse

    /**
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     */
    public suspend fun batchGetDeployments(input: BatchGetDeploymentsRequest): BatchGetDeploymentsResponse

    /**
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.
     */
    public suspend fun batchGetOnPremisesInstances(input: BatchGetOnPremisesInstancesRequest): BatchGetOnPremisesInstancesResponse

    /**
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)
     */
    public suspend fun continueDeployment(input: ContinueDeploymentRequest = ContinueDeploymentRequest {}): ContinueDeploymentResponse

    /**
     * Creates an application.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Deploys an application revision through the specified deployment group.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a deployment configuration.
     */
    public suspend fun createDeploymentConfig(input: CreateDeploymentConfigRequest): CreateDeploymentConfigResponse

    /**
     * Creates a deployment group to which application revisions are deployed.
     */
    public suspend fun createDeploymentGroup(input: CreateDeploymentGroupRequest): CreateDeploymentGroupResponse

    /**
     * Deletes an application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes a deployment configuration.
     *
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.
     */
    public suspend fun deleteDeploymentConfig(input: DeleteDeploymentConfigRequest): DeleteDeploymentConfigResponse

    /**
     * Deletes a deployment group.
     */
    public suspend fun deleteDeploymentGroup(input: DeleteDeploymentGroupRequest): DeleteDeploymentGroupResponse

    /**
     * Deletes a GitHub account connection.
     */
    public suspend fun deleteGitHubAccountToken(input: DeleteGitHubAccountTokenRequest = DeleteGitHubAccountTokenRequest {}): DeleteGitHubAccountTokenResponse

    /**
     * Deletes resources linked to an external ID.
     */
    public suspend fun deleteResourcesByExternalId(input: DeleteResourcesByExternalIdRequest = DeleteResourcesByExternalIdRequest {}): DeleteResourcesByExternalIdResponse

    /**
     * Deregisters an on-premises instance.
     */
    public suspend fun deregisterOnPremisesInstance(input: DeregisterOnPremisesInstanceRequest): DeregisterOnPremisesInstanceResponse

    /**
     * Gets information about an application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets information about an application revision.
     */
    public suspend fun getApplicationRevision(input: GetApplicationRevisionRequest): GetApplicationRevisionResponse

    /**
     * Gets information about a deployment.
     *
     *  The `content` property of the `appSpecContent` object in the returned revision is always null. Use `GetApplicationRevision` and the `sha256` property of the returned `appSpecContent` object to get the content of the deployment’s AppSpec file.
     */
    public suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets information about a deployment configuration.
     */
    public suspend fun getDeploymentConfig(input: GetDeploymentConfigRequest): GetDeploymentConfigResponse

    /**
     * Gets information about a deployment group.
     */
    public suspend fun getDeploymentGroup(input: GetDeploymentGroupRequest): GetDeploymentGroupResponse

    /**
     * Gets information about an instance as part of a deployment.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getDeploymentInstance(input: GetDeploymentInstanceRequest): GetDeploymentInstanceResponse

    /**
     * Returns information about a deployment target.
     */
    public suspend fun getDeploymentTarget(input: GetDeploymentTargetRequest = GetDeploymentTargetRequest {}): GetDeploymentTargetResponse

    /**
     * Gets information about an on-premises instance.
     */
    public suspend fun getOnPremisesInstance(input: GetOnPremisesInstanceRequest): GetOnPremisesInstanceResponse

    /**
     * Lists information about revisions for an application.
     */
    public suspend fun listApplicationRevisions(input: ListApplicationRevisionsRequest): ListApplicationRevisionsResponse

    /**
     * Lists the applications registered with the IAM user or Amazon Web Services account.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Lists the deployment configurations with the IAM user or Amazon Web Services account.
     */
    public suspend fun listDeploymentConfigs(input: ListDeploymentConfigsRequest = ListDeploymentConfigsRequest {}): ListDeploymentConfigsResponse

    /**
     * Lists the deployment groups for an application registered with the IAM user or Amazon Web Services account.
     */
    public suspend fun listDeploymentGroups(input: ListDeploymentGroupsRequest): ListDeploymentGroupsResponse

    /**
     * The newer `BatchGetDeploymentTargets` should be used instead because it works with all compute types. `ListDeploymentInstances` throws an exception if it is used with a compute platform other than EC2/On-premises or Lambda.
     *
     *  Lists the instance for a deployment associated with the IAM user or Amazon Web Services account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listDeploymentInstances(input: ListDeploymentInstancesRequest): ListDeploymentInstancesResponse

    /**
     * Returns an array of target IDs that are associated a deployment.
     */
    public suspend fun listDeploymentTargets(input: ListDeploymentTargetsRequest = ListDeploymentTargetsRequest {}): ListDeploymentTargetsResponse

    /**
     * Lists the deployments in a deployment group for an application registered with the IAM user or Amazon Web Services account.
     */
    public suspend fun listDeployments(input: ListDeploymentsRequest = ListDeploymentsRequest {}): ListDeploymentsResponse

    /**
     * Lists the names of stored connections to GitHub accounts.
     */
    public suspend fun listGitHubAccountTokenNames(input: ListGitHubAccountTokenNamesRequest = ListGitHubAccountTokenNamesRequest {}): ListGitHubAccountTokenNamesResponse

    /**
     * Gets a list of names for one or more on-premises instances.
     *
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.
     */
    public suspend fun listOnPremisesInstances(input: ListOnPremisesInstancesRequest = ListOnPremisesInstancesRequest {}): ListOnPremisesInstancesResponse

    /**
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the Lambda or Amazon ECS compute platform. For Lambda deployments, the available lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For Amazon ECS deployments, the available lifecycle hooks are `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`, `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation functions return `Succeeded` or `Failed`. For more information, see [AppSpec 'hooks' Section for an Lambda Deployment ](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda) and [AppSpec 'hooks' Section for an Amazon ECS Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
     */
    public suspend fun putLifecycleEventHookExecutionStatus(input: PutLifecycleEventHookExecutionStatusRequest = PutLifecycleEventHookExecutionStatusRequest {}): PutLifecycleEventHookExecutionStatusResponse

    /**
     * Registers with CodeDeploy a revision for the specified application.
     */
    public suspend fun registerApplicationRevision(input: RegisterApplicationRevisionRequest): RegisterApplicationRevisionResponse

    /**
     * Registers an on-premises instance.
     *
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     */
    public suspend fun registerOnPremisesInstance(input: RegisterOnPremisesInstanceRequest): RegisterOnPremisesInstanceResponse

    /**
     * Removes one or more tags from one or more on-premises instances.
     */
    public suspend fun removeTagsFromOnPremisesInstances(input: RemoveTagsFromOnPremisesInstancesRequest): RemoveTagsFromOnPremisesInstancesResponse

    /**
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun skipWaitTimeForInstanceTermination(input: SkipWaitTimeForInstanceTerminationRequest = SkipWaitTimeForInstanceTerminationRequest {}): SkipWaitTimeForInstanceTerminationResponse

    /**
     * Attempts to stop an ongoing deployment.
     */
    public suspend fun stopDeployment(input: StopDeploymentRequest): StopDeploymentResponse

    /**
     * Associates the list of tags in the input `Tags` parameter with the resource identified by the `ResourceArn` input parameter.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates a resource from a list of tags. The resource is identified by the `ResourceArn` input parameter. The tags are identified by the list of keys in the `TagKeys` input parameter.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Changes the name of an application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest = UpdateApplicationRequest {}): UpdateApplicationResponse

    /**
     * Changes information about a deployment group.
     */
    public suspend fun updateDeploymentGroup(input: UpdateDeploymentGroupRequest): UpdateDeploymentGroupResponse
}

/**
 * Adds tags to on-premises instances.
 */
public suspend inline fun CodeDeployClient.addTagsToOnPremisesInstances(crossinline block: AddTagsToOnPremisesInstancesRequest.Builder.() -> Unit): AddTagsToOnPremisesInstancesResponse = addTagsToOnPremisesInstances(AddTagsToOnPremisesInstancesRequest.Builder().apply(block).build())

/**
 * Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.
 */
public suspend inline fun CodeDeployClient.batchGetApplicationRevisions(crossinline block: BatchGetApplicationRevisionsRequest.Builder.() -> Unit): BatchGetApplicationRevisionsResponse = batchGetApplicationRevisions(BatchGetApplicationRevisionsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
 */
public suspend inline fun CodeDeployClient.batchGetApplications(crossinline block: BatchGetApplicationsRequest.Builder.() -> Unit): BatchGetApplicationsResponse = batchGetApplications(BatchGetApplicationsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more deployment groups.
 */
public suspend inline fun CodeDeployClient.batchGetDeploymentGroups(crossinline block: BatchGetDeploymentGroupsRequest.Builder.() -> Unit): BatchGetDeploymentGroupsResponse = batchGetDeploymentGroups(BatchGetDeploymentGroupsRequest.Builder().apply(block).build())

/**
 * This method works, but is deprecated. Use `BatchGetDeploymentTargets` instead.
 *
 *  Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and Lambda compute platforms. The newer `BatchGetDeploymentTargets` works with all compute platforms. The maximum number of instances that can be returned is 25.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun CodeDeployClient.batchGetDeploymentInstances(crossinline block: BatchGetDeploymentInstancesRequest.Builder.() -> Unit): BatchGetDeploymentInstancesResponse = batchGetDeploymentInstances(BatchGetDeploymentInstancesRequest.Builder().apply(block).build())

/**
 * Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated `BatchGetDeploymentInstances`. The maximum number of targets that can be returned is 25.
 *
 *  The type of targets returned depends on the deployment's compute platform or deployment method:
 * + **EC2/On-premises**: Information about Amazon EC2 instance targets.
 * + **Lambda**: Information about Lambda functions targets.
 * + **Amazon ECS**: Information about Amazon ECS service targets.
 * + **CloudFormation**: Information about targets of blue/green deployments initiated by a CloudFormation stack update.
 */
public suspend inline fun CodeDeployClient.batchGetDeploymentTargets(crossinline block: BatchGetDeploymentTargetsRequest.Builder.() -> Unit): BatchGetDeploymentTargetsResponse = batchGetDeploymentTargets(BatchGetDeploymentTargetsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
 */
public suspend inline fun CodeDeployClient.batchGetDeployments(crossinline block: BatchGetDeploymentsRequest.Builder.() -> Unit): BatchGetDeploymentsResponse = batchGetDeployments(BatchGetDeploymentsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.
 */
public suspend inline fun CodeDeployClient.batchGetOnPremisesInstances(crossinline block: BatchGetOnPremisesInstancesRequest.Builder.() -> Unit): BatchGetOnPremisesInstancesResponse = batchGetOnPremisesInstances(BatchGetOnPremisesInstancesRequest.Builder().apply(block).build())

/**
 * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)
 */
public suspend inline fun CodeDeployClient.continueDeployment(crossinline block: ContinueDeploymentRequest.Builder.() -> Unit): ContinueDeploymentResponse = continueDeployment(ContinueDeploymentRequest.Builder().apply(block).build())

/**
 * Creates an application.
 */
public suspend inline fun CodeDeployClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Deploys an application revision through the specified deployment group.
 */
public suspend inline fun CodeDeployClient.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a deployment configuration.
 */
public suspend inline fun CodeDeployClient.createDeploymentConfig(crossinline block: CreateDeploymentConfigRequest.Builder.() -> Unit): CreateDeploymentConfigResponse = createDeploymentConfig(CreateDeploymentConfigRequest.Builder().apply(block).build())

/**
 * Creates a deployment group to which application revisions are deployed.
 */
public suspend inline fun CodeDeployClient.createDeploymentGroup(crossinline block: CreateDeploymentGroupRequest.Builder.() -> Unit): CreateDeploymentGroupResponse = createDeploymentGroup(CreateDeploymentGroupRequest.Builder().apply(block).build())

/**
 * Deletes an application.
 */
public suspend inline fun CodeDeployClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a deployment configuration.
 *
 * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.
 */
public suspend inline fun CodeDeployClient.deleteDeploymentConfig(crossinline block: DeleteDeploymentConfigRequest.Builder.() -> Unit): DeleteDeploymentConfigResponse = deleteDeploymentConfig(DeleteDeploymentConfigRequest.Builder().apply(block).build())

/**
 * Deletes a deployment group.
 */
public suspend inline fun CodeDeployClient.deleteDeploymentGroup(crossinline block: DeleteDeploymentGroupRequest.Builder.() -> Unit): DeleteDeploymentGroupResponse = deleteDeploymentGroup(DeleteDeploymentGroupRequest.Builder().apply(block).build())

/**
 * Deletes a GitHub account connection.
 */
public suspend inline fun CodeDeployClient.deleteGitHubAccountToken(crossinline block: DeleteGitHubAccountTokenRequest.Builder.() -> Unit): DeleteGitHubAccountTokenResponse = deleteGitHubAccountToken(DeleteGitHubAccountTokenRequest.Builder().apply(block).build())

/**
 * Deletes resources linked to an external ID.
 */
public suspend inline fun CodeDeployClient.deleteResourcesByExternalId(crossinline block: DeleteResourcesByExternalIdRequest.Builder.() -> Unit): DeleteResourcesByExternalIdResponse = deleteResourcesByExternalId(DeleteResourcesByExternalIdRequest.Builder().apply(block).build())

/**
 * Deregisters an on-premises instance.
 */
public suspend inline fun CodeDeployClient.deregisterOnPremisesInstance(crossinline block: DeregisterOnPremisesInstanceRequest.Builder.() -> Unit): DeregisterOnPremisesInstanceResponse = deregisterOnPremisesInstance(DeregisterOnPremisesInstanceRequest.Builder().apply(block).build())

/**
 * Gets information about an application.
 */
public suspend inline fun CodeDeployClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Gets information about an application revision.
 */
public suspend inline fun CodeDeployClient.getApplicationRevision(crossinline block: GetApplicationRevisionRequest.Builder.() -> Unit): GetApplicationRevisionResponse = getApplicationRevision(GetApplicationRevisionRequest.Builder().apply(block).build())

/**
 * Gets information about a deployment.
 *
 *  The `content` property of the `appSpecContent` object in the returned revision is always null. Use `GetApplicationRevision` and the `sha256` property of the returned `appSpecContent` object to get the content of the deployment’s AppSpec file.
 */
public suspend inline fun CodeDeployClient.getDeployment(crossinline block: GetDeploymentRequest.Builder.() -> Unit): GetDeploymentResponse = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

/**
 * Gets information about a deployment configuration.
 */
public suspend inline fun CodeDeployClient.getDeploymentConfig(crossinline block: GetDeploymentConfigRequest.Builder.() -> Unit): GetDeploymentConfigResponse = getDeploymentConfig(GetDeploymentConfigRequest.Builder().apply(block).build())

/**
 * Gets information about a deployment group.
 */
public suspend inline fun CodeDeployClient.getDeploymentGroup(crossinline block: GetDeploymentGroupRequest.Builder.() -> Unit): GetDeploymentGroupResponse = getDeploymentGroup(GetDeploymentGroupRequest.Builder().apply(block).build())

/**
 * Gets information about an instance as part of a deployment.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun CodeDeployClient.getDeploymentInstance(crossinline block: GetDeploymentInstanceRequest.Builder.() -> Unit): GetDeploymentInstanceResponse = getDeploymentInstance(GetDeploymentInstanceRequest.Builder().apply(block).build())

/**
 * Returns information about a deployment target.
 */
public suspend inline fun CodeDeployClient.getDeploymentTarget(crossinline block: GetDeploymentTargetRequest.Builder.() -> Unit): GetDeploymentTargetResponse = getDeploymentTarget(GetDeploymentTargetRequest.Builder().apply(block).build())

/**
 * Gets information about an on-premises instance.
 */
public suspend inline fun CodeDeployClient.getOnPremisesInstance(crossinline block: GetOnPremisesInstanceRequest.Builder.() -> Unit): GetOnPremisesInstanceResponse = getOnPremisesInstance(GetOnPremisesInstanceRequest.Builder().apply(block).build())

/**
 * Lists information about revisions for an application.
 */
public suspend inline fun CodeDeployClient.listApplicationRevisions(crossinline block: ListApplicationRevisionsRequest.Builder.() -> Unit): ListApplicationRevisionsResponse = listApplicationRevisions(ListApplicationRevisionsRequest.Builder().apply(block).build())

/**
 * Lists the applications registered with the IAM user or Amazon Web Services account.
 */
public suspend inline fun CodeDeployClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the deployment configurations with the IAM user or Amazon Web Services account.
 */
public suspend inline fun CodeDeployClient.listDeploymentConfigs(crossinline block: ListDeploymentConfigsRequest.Builder.() -> Unit): ListDeploymentConfigsResponse = listDeploymentConfigs(ListDeploymentConfigsRequest.Builder().apply(block).build())

/**
 * Lists the deployment groups for an application registered with the IAM user or Amazon Web Services account.
 */
public suspend inline fun CodeDeployClient.listDeploymentGroups(crossinline block: ListDeploymentGroupsRequest.Builder.() -> Unit): ListDeploymentGroupsResponse = listDeploymentGroups(ListDeploymentGroupsRequest.Builder().apply(block).build())

/**
 * The newer `BatchGetDeploymentTargets` should be used instead because it works with all compute types. `ListDeploymentInstances` throws an exception if it is used with a compute platform other than EC2/On-premises or Lambda.
 *
 *  Lists the instance for a deployment associated with the IAM user or Amazon Web Services account.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun CodeDeployClient.listDeploymentInstances(crossinline block: ListDeploymentInstancesRequest.Builder.() -> Unit): ListDeploymentInstancesResponse = listDeploymentInstances(ListDeploymentInstancesRequest.Builder().apply(block).build())

/**
 * Returns an array of target IDs that are associated a deployment.
 */
public suspend inline fun CodeDeployClient.listDeploymentTargets(crossinline block: ListDeploymentTargetsRequest.Builder.() -> Unit): ListDeploymentTargetsResponse = listDeploymentTargets(ListDeploymentTargetsRequest.Builder().apply(block).build())

/**
 * Lists the deployments in a deployment group for an application registered with the IAM user or Amazon Web Services account.
 */
public suspend inline fun CodeDeployClient.listDeployments(crossinline block: ListDeploymentsRequest.Builder.() -> Unit): ListDeploymentsResponse = listDeployments(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * Lists the names of stored connections to GitHub accounts.
 */
public suspend inline fun CodeDeployClient.listGitHubAccountTokenNames(crossinline block: ListGitHubAccountTokenNamesRequest.Builder.() -> Unit): ListGitHubAccountTokenNamesResponse = listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest.Builder().apply(block).build())

/**
 * Gets a list of names for one or more on-premises instances.
 *
 * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.
 */
public suspend inline fun CodeDeployClient.listOnPremisesInstances(crossinline block: ListOnPremisesInstancesRequest.Builder.() -> Unit): ListOnPremisesInstancesResponse = listOnPremisesInstances(ListOnPremisesInstancesRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources.
 */
public suspend inline fun CodeDeployClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the Lambda or Amazon ECS compute platform. For Lambda deployments, the available lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For Amazon ECS deployments, the available lifecycle hooks are `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`, `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation functions return `Succeeded` or `Failed`. For more information, see [AppSpec 'hooks' Section for an Lambda Deployment ](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda) and [AppSpec 'hooks' Section for an Amazon ECS Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
 */
public suspend inline fun CodeDeployClient.putLifecycleEventHookExecutionStatus(crossinline block: PutLifecycleEventHookExecutionStatusRequest.Builder.() -> Unit): PutLifecycleEventHookExecutionStatusResponse = putLifecycleEventHookExecutionStatus(PutLifecycleEventHookExecutionStatusRequest.Builder().apply(block).build())

/**
 * Registers with CodeDeploy a revision for the specified application.
 */
public suspend inline fun CodeDeployClient.registerApplicationRevision(crossinline block: RegisterApplicationRevisionRequest.Builder.() -> Unit): RegisterApplicationRevisionResponse = registerApplicationRevision(RegisterApplicationRevisionRequest.Builder().apply(block).build())

/**
 * Registers an on-premises instance.
 *
 * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
 */
public suspend inline fun CodeDeployClient.registerOnPremisesInstance(crossinline block: RegisterOnPremisesInstanceRequest.Builder.() -> Unit): RegisterOnPremisesInstanceResponse = registerOnPremisesInstance(RegisterOnPremisesInstanceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from one or more on-premises instances.
 */
public suspend inline fun CodeDeployClient.removeTagsFromOnPremisesInstances(crossinline block: RemoveTagsFromOnPremisesInstancesRequest.Builder.() -> Unit): RemoveTagsFromOnPremisesInstancesResponse = removeTagsFromOnPremisesInstances(RemoveTagsFromOnPremisesInstancesRequest.Builder().apply(block).build())

/**
 * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun CodeDeployClient.skipWaitTimeForInstanceTermination(crossinline block: SkipWaitTimeForInstanceTerminationRequest.Builder.() -> Unit): SkipWaitTimeForInstanceTerminationResponse = skipWaitTimeForInstanceTermination(SkipWaitTimeForInstanceTerminationRequest.Builder().apply(block).build())

/**
 * Attempts to stop an ongoing deployment.
 */
public suspend inline fun CodeDeployClient.stopDeployment(crossinline block: StopDeploymentRequest.Builder.() -> Unit): StopDeploymentResponse = stopDeployment(StopDeploymentRequest.Builder().apply(block).build())

/**
 * Associates the list of tags in the input `Tags` parameter with the resource identified by the `ResourceArn` input parameter.
 */
public suspend inline fun CodeDeployClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates a resource from a list of tags. The resource is identified by the `ResourceArn` input parameter. The tags are identified by the list of keys in the `TagKeys` input parameter.
 */
public suspend inline fun CodeDeployClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Changes the name of an application.
 */
public suspend inline fun CodeDeployClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Changes information about a deployment group.
 */
public suspend inline fun CodeDeployClient.updateDeploymentGroup(crossinline block: UpdateDeploymentGroupRequest.Builder.() -> Unit): UpdateDeploymentGroupResponse = updateDeploymentGroup(UpdateDeploymentGroupRequest.Builder().apply(block).build())
