// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `CreateDeploymentConfig` operation.
 */
public class CreateDeploymentConfigRequest private constructor(builder: Builder) {
    /**
     * The destination platform type for the deployment (`Lambda`, `Server`, or `ECS`).
     */
    public val computePlatform: aws.sdk.kotlin.services.codedeploy.model.ComputePlatform? = builder.computePlatform
    /**
     * The name of the deployment configuration to create.
     */
    public val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.
     *
     * The type parameter takes either of the following values:
     * + HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     * + FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.
     *
     * The value parameter takes an integer.
     *
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     */
    public val minimumHealthyHosts: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts? = builder.minimumHealthyHosts
    /**
     * The configuration that specifies how the deployment traffic is routed.
     */
    public val trafficRoutingConfig: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig? = builder.trafficRoutingConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentConfigRequest(")
        append("computePlatform=$computePlatform,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("minimumHealthyHosts=$minimumHealthyHosts,")
        append("trafficRoutingConfig=$trafficRoutingConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computePlatform?.hashCode() ?: 0
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (minimumHealthyHosts?.hashCode() ?: 0)
        result = 31 * result + (trafficRoutingConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentConfigRequest

        if (computePlatform != other.computePlatform) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (minimumHealthyHosts != other.minimumHealthyHosts) return false
        if (trafficRoutingConfig != other.trafficRoutingConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination platform type for the deployment (`Lambda`, `Server`, or `ECS`).
         */
        public var computePlatform: aws.sdk.kotlin.services.codedeploy.model.ComputePlatform? = null
        /**
         * The name of the deployment configuration to create.
         */
        public var deploymentConfigName: kotlin.String? = null
        /**
         * The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.
         *
         * The type parameter takes either of the following values:
         * + HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
         * + FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.
         *
         * The value parameter takes an integer.
         *
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         */
        public var minimumHealthyHosts: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts? = null
        /**
         * The configuration that specifies how the deployment traffic is routed.
         */
        public var trafficRoutingConfig: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigRequest) : this() {
            this.computePlatform = x.computePlatform
            this.deploymentConfigName = x.deploymentConfigName
            this.minimumHealthyHosts = x.minimumHealthyHosts
            this.trafficRoutingConfig = x.trafficRoutingConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigRequest = CreateDeploymentConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts] inside the given [block]
         */
        public fun minimumHealthyHosts(block: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts.Builder.() -> kotlin.Unit) {
            this.minimumHealthyHosts = aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig] inside the given [block]
         */
        public fun trafficRoutingConfig(block: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig.Builder.() -> kotlin.Unit) {
            this.trafficRoutingConfig = aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig.invoke(block)
        }
    }
}
