// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about alarms associated with the deployment group.
 */
class AlarmConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A list of alarms configured for the deployment group. A maximum of 10 alarms can be
     * added to a deployment group.
     */
    val alarms: List<Alarm>? = builder.alarms
    /**
     * Indicates whether the alarm configuration is enabled.
     */
    val enabled: Boolean = builder.enabled
    /**
     * Indicates whether a deployment should continue if information about the current state
     * of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.
     * true: The deployment proceeds even if alarm status information
     * can't be retrieved from Amazon CloudWatch.
     * false: The deployment stops if alarm status information can't be
     * retrieved from Amazon CloudWatch.
     */
    val ignorePollAlarmFailure: Boolean = builder.ignorePollAlarmFailure

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AlarmConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmConfiguration(")
        append("alarms=$alarms,")
        append("enabled=$enabled,")
        append("ignorePollAlarmFailure=$ignorePollAlarmFailure)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (ignorePollAlarmFailure.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AlarmConfiguration

        if (alarms != other.alarms) return false
        if (enabled != other.enabled) return false
        if (ignorePollAlarmFailure != other.ignorePollAlarmFailure) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AlarmConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AlarmConfiguration
        /**
         * A list of alarms configured for the deployment group. A maximum of 10 alarms can be
         * added to a deployment group.
         */
        fun alarms(alarms: List<Alarm>): FluentBuilder
        /**
         * Indicates whether the alarm configuration is enabled.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * Indicates whether a deployment should continue if information about the current state
         * of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.
         * true: The deployment proceeds even if alarm status information
         * can't be retrieved from Amazon CloudWatch.
         * false: The deployment stops if alarm status information can't be
         * retrieved from Amazon CloudWatch.
         */
        fun ignorePollAlarmFailure(ignorePollAlarmFailure: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of alarms configured for the deployment group. A maximum of 10 alarms can be
         * added to a deployment group.
         */
        var alarms: List<Alarm>?
        /**
         * Indicates whether the alarm configuration is enabled.
         */
        var enabled: Boolean
        /**
         * Indicates whether a deployment should continue if information about the current state
         * of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.
         * true: The deployment proceeds even if alarm status information
         * can't be retrieved from Amazon CloudWatch.
         * false: The deployment stops if alarm status information can't be
         * retrieved from Amazon CloudWatch.
         */
        var ignorePollAlarmFailure: Boolean

        fun build(): AlarmConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarms: List<Alarm>? = null
        override var enabled: Boolean = false
        override var ignorePollAlarmFailure: Boolean = false

        constructor(x: AlarmConfiguration) : this() {
            this.alarms = x.alarms
            this.enabled = x.enabled
            this.ignorePollAlarmFailure = x.ignorePollAlarmFailure
        }

        override fun build(): AlarmConfiguration = AlarmConfiguration(this)
        override fun alarms(alarms: List<Alarm>): FluentBuilder = apply { this.alarms = alarms }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun ignorePollAlarmFailure(ignorePollAlarmFailure: Boolean): FluentBuilder = apply { this.ignorePollAlarmFailure = ignorePollAlarmFailure }
    }
}
