// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * A revision for an AWS Lambda or Amazon ECS deployment that is a YAML-formatted or
 * JSON-formatted string. For AWS Lambda and Amazon ECS deployments, the revision is the
 * same as the AppSpec file. This method replaces the deprecated RawString
 * data type.
 */
class AppSpecContent private constructor(builder: BuilderImpl) {
    /**
     * The YAML-formatted or JSON-formatted revision string.
     * For an AWS Lambda deployment, the content includes a Lambda function name, the alias
     * for its original version, and the alias for its replacement version. The deployment
     * shifts traffic from the original version of the Lambda function to the replacement
     * version.
     * For an Amazon ECS deployment, the content includes the task name, information about
     * the load balancer that serves traffic to the container, and more.
     * For both types of deployments, the content can specify Lambda functions that run at
     * specified hooks, such as BeforeInstall, during a deployment.
     */
    val content: String? = builder.content
    /**
     * The SHA256 hash value of the revision content.
     */
    val sha256: String? = builder.sha256

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AppSpecContent = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AppSpecContent(")
        append("content=$content,")
        append("sha256=$sha256)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (sha256?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AppSpecContent

        if (content != other.content) return false
        if (sha256 != other.sha256) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AppSpecContent = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AppSpecContent
        /**
         * The YAML-formatted or JSON-formatted revision string.
         * For an AWS Lambda deployment, the content includes a Lambda function name, the alias
         * for its original version, and the alias for its replacement version. The deployment
         * shifts traffic from the original version of the Lambda function to the replacement
         * version.
         * For an Amazon ECS deployment, the content includes the task name, information about
         * the load balancer that serves traffic to the container, and more.
         * For both types of deployments, the content can specify Lambda functions that run at
         * specified hooks, such as BeforeInstall, during a deployment.
         */
        fun content(content: String): FluentBuilder
        /**
         * The SHA256 hash value of the revision content.
         */
        fun sha256(sha256: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The YAML-formatted or JSON-formatted revision string.
         * For an AWS Lambda deployment, the content includes a Lambda function name, the alias
         * for its original version, and the alias for its replacement version. The deployment
         * shifts traffic from the original version of the Lambda function to the replacement
         * version.
         * For an Amazon ECS deployment, the content includes the task name, information about
         * the load balancer that serves traffic to the container, and more.
         * For both types of deployments, the content can specify Lambda functions that run at
         * specified hooks, such as BeforeInstall, during a deployment.
         */
        var content: String?
        /**
         * The SHA256 hash value of the revision content.
         */
        var sha256: String?

        fun build(): AppSpecContent
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var content: String? = null
        override var sha256: String? = null

        constructor(x: AppSpecContent) : this() {
            this.content = x.content
            this.sha256 = x.sha256
        }

        override fun build(): AppSpecContent = AppSpecContent(this)
        override fun content(content: String): FluentBuilder = apply { this.content = content }
        override fun sha256(sha256: String): FluentBuilder = apply { this.sha256 = sha256 }
    }
}
