// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an application.
 */
class ApplicationInfo private constructor(builder: BuilderImpl) {
    /**
     * The application ID.
     */
    val applicationId: String? = builder.applicationId
    /**
     * The application name.
     */
    val applicationName: String? = builder.applicationName
    /**
     * The destination platform type for deployment of the application (Lambda
     * or Server).
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The time at which the application was created.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The name for a connection to a GitHub account.
     */
    val gitHubAccountName: String? = builder.gitHubAccountName
    /**
     * True if the user has authenticated with GitHub for the specified application.
     * Otherwise, false.
     */
    val linkedToGitHub: Boolean = builder.linkedToGitHub

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApplicationInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationInfo(")
        append("applicationId=$applicationId,")
        append("applicationName=$applicationName,")
        append("computePlatform=$computePlatform,")
        append("createTime=$createTime,")
        append("gitHubAccountName=$gitHubAccountName,")
        append("linkedToGitHub=$linkedToGitHub)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (gitHubAccountName?.hashCode() ?: 0)
        result = 31 * result + (linkedToGitHub.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationInfo

        if (applicationId != other.applicationId) return false
        if (applicationName != other.applicationName) return false
        if (computePlatform != other.computePlatform) return false
        if (createTime != other.createTime) return false
        if (gitHubAccountName != other.gitHubAccountName) return false
        if (linkedToGitHub != other.linkedToGitHub) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApplicationInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApplicationInfo
        /**
         * The application ID.
         */
        fun applicationId(applicationId: String): FluentBuilder
        /**
         * The application name.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * The destination platform type for deployment of the application (Lambda
         * or Server).
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The time at which the application was created.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The name for a connection to a GitHub account.
         */
        fun gitHubAccountName(gitHubAccountName: String): FluentBuilder
        /**
         * True if the user has authenticated with GitHub for the specified application.
         * Otherwise, false.
         */
        fun linkedToGitHub(linkedToGitHub: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The application ID.
         */
        var applicationId: String?
        /**
         * The application name.
         */
        var applicationName: String?
        /**
         * The destination platform type for deployment of the application (Lambda
         * or Server).
         */
        var computePlatform: ComputePlatform?
        /**
         * The time at which the application was created.
         */
        var createTime: Instant?
        /**
         * The name for a connection to a GitHub account.
         */
        var gitHubAccountName: String?
        /**
         * True if the user has authenticated with GitHub for the specified application.
         * Otherwise, false.
         */
        var linkedToGitHub: Boolean

        fun build(): ApplicationInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationId: String? = null
        override var applicationName: String? = null
        override var computePlatform: ComputePlatform? = null
        override var createTime: Instant? = null
        override var gitHubAccountName: String? = null
        override var linkedToGitHub: Boolean = false

        constructor(x: ApplicationInfo) : this() {
            this.applicationId = x.applicationId
            this.applicationName = x.applicationName
            this.computePlatform = x.computePlatform
            this.createTime = x.createTime
            this.gitHubAccountName = x.gitHubAccountName
            this.linkedToGitHub = x.linkedToGitHub
        }

        override fun build(): ApplicationInfo = ApplicationInfo(this)
        override fun applicationId(applicationId: String): FluentBuilder = apply { this.applicationId = applicationId }
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun gitHubAccountName(gitHubAccountName: String): FluentBuilder = apply { this.gitHubAccountName = gitHubAccountName }
        override fun linkedToGitHub(linkedToGitHub: Boolean): FluentBuilder = apply { this.linkedToGitHub = linkedToGitHub }
    }
}
