// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the output of a BatchGetApplicationRevisions operation.
 */
class BatchGetApplicationRevisionsResponse private constructor(builder: BuilderImpl) {
    /**
     * The name of the application that corresponds to the revisions.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Information about errors that might have occurred during the API call.
     */
    val errorMessage: String? = builder.errorMessage
    /**
     * Additional information about the revisions, including the type and location.
     */
    val revisions: List<RevisionInfo>? = builder.revisions

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchGetApplicationRevisionsResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetApplicationRevisionsResponse(")
        append("applicationName=$applicationName,")
        append("errorMessage=$errorMessage,")
        append("revisions=$revisions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (revisions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchGetApplicationRevisionsResponse

        if (applicationName != other.applicationName) return false
        if (errorMessage != other.errorMessage) return false
        if (revisions != other.revisions) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchGetApplicationRevisionsResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchGetApplicationRevisionsResponse
        /**
         * The name of the application that corresponds to the revisions.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Information about errors that might have occurred during the API call.
         */
        fun errorMessage(errorMessage: String): FluentBuilder
        /**
         * Additional information about the revisions, including the type and location.
         */
        fun revisions(revisions: List<RevisionInfo>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the application that corresponds to the revisions.
         */
        var applicationName: String?
        /**
         * Information about errors that might have occurred during the API call.
         */
        var errorMessage: String?
        /**
         * Additional information about the revisions, including the type and location.
         */
        var revisions: List<RevisionInfo>?

        fun build(): BatchGetApplicationRevisionsResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationName: String? = null
        override var errorMessage: String? = null
        override var revisions: List<RevisionInfo>? = null

        constructor(x: BatchGetApplicationRevisionsResponse) : this() {
            this.applicationName = x.applicationName
            this.errorMessage = x.errorMessage
            this.revisions = x.revisions
        }

        override fun build(): BatchGetApplicationRevisionsResponse = BatchGetApplicationRevisionsResponse(this)
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun errorMessage(errorMessage: String): FluentBuilder = apply { this.errorMessage = errorMessage }
        override fun revisions(revisions: List<RevisionInfo>): FluentBuilder = apply { this.revisions = revisions }
    }
}
