// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



class BatchGetDeploymentTargetsRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The unique IDs of the deployment targets. The compute platform of the deployment
     * determines the type of the targets and their formats. The maximum number of deployment
     * target IDs you can specify is 25.
     * For deployments that use the EC2/On-premises compute platform, the target IDs
     * are EC2 or on-premises instances IDs, and their target type is
     * instanceTarget.
     * For deployments that use the AWS Lambda compute platform, the target IDs are
     * the names of Lambda functions, and their target type is
     * instanceTarget.
     * For deployments that use the Amazon ECS compute platform, the target IDs are
     * pairs of Amazon ECS clusters and services specified using the format
     * <clustername>:<servicename>. Their target type is
     * ecsTarget.
     * For deployments that are deployed with AWS CloudFormation, the target IDs are
     * CloudFormation stack IDs. Their target type is
     * cloudFormationTarget.
     */
    val targetIds: List<String>? = builder.targetIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchGetDeploymentTargetsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetDeploymentTargetsRequest(")
        append("deploymentId=$deploymentId,")
        append("targetIds=$targetIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (targetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchGetDeploymentTargetsRequest

        if (deploymentId != other.deploymentId) return false
        if (targetIds != other.targetIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchGetDeploymentTargetsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchGetDeploymentTargetsRequest
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The unique IDs of the deployment targets. The compute platform of the deployment
         * determines the type of the targets and their formats. The maximum number of deployment
         * target IDs you can specify is 25.
         * For deployments that use the EC2/On-premises compute platform, the target IDs
         * are EC2 or on-premises instances IDs, and their target type is
         * instanceTarget.
         * For deployments that use the AWS Lambda compute platform, the target IDs are
         * the names of Lambda functions, and their target type is
         * instanceTarget.
         * For deployments that use the Amazon ECS compute platform, the target IDs are
         * pairs of Amazon ECS clusters and services specified using the format
         * <clustername>:<servicename>. Their target type is
         * ecsTarget.
         * For deployments that are deployed with AWS CloudFormation, the target IDs are
         * CloudFormation stack IDs. Their target type is
         * cloudFormationTarget.
         */
        fun targetIds(targetIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * The unique IDs of the deployment targets. The compute platform of the deployment
         * determines the type of the targets and their formats. The maximum number of deployment
         * target IDs you can specify is 25.
         * For deployments that use the EC2/On-premises compute platform, the target IDs
         * are EC2 or on-premises instances IDs, and their target type is
         * instanceTarget.
         * For deployments that use the AWS Lambda compute platform, the target IDs are
         * the names of Lambda functions, and their target type is
         * instanceTarget.
         * For deployments that use the Amazon ECS compute platform, the target IDs are
         * pairs of Amazon ECS clusters and services specified using the format
         * <clustername>:<servicename>. Their target type is
         * ecsTarget.
         * For deployments that are deployed with AWS CloudFormation, the target IDs are
         * CloudFormation stack IDs. Their target type is
         * cloudFormationTarget.
         */
        var targetIds: List<String>?

        fun build(): BatchGetDeploymentTargetsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var targetIds: List<String>? = null

        constructor(x: BatchGetDeploymentTargetsRequest) : this() {
            this.deploymentId = x.deploymentId
            this.targetIds = x.targetIds
        }

        override fun build(): BatchGetDeploymentTargetsRequest = BatchGetDeploymentTargetsRequest(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun targetIds(targetIds: List<String>): FluentBuilder = apply { this.targetIds = targetIds }
    }
}
