// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about blue/green deployment options for a deployment group.
 */
class BlueGreenDeploymentConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Information about the action to take when newly provisioned instances are ready to
     * receive traffic in a blue/green deployment.
     */
    val deploymentReadyOption: DeploymentReadyOption? = builder.deploymentReadyOption
    /**
     * Information about how instances are provisioned for a replacement environment in a
     * blue/green deployment.
     */
    val greenFleetProvisioningOption: GreenFleetProvisioningOption? = builder.greenFleetProvisioningOption
    /**
     * Information about whether to terminate instances in the original fleet during a
     * blue/green deployment.
     */
    val terminateBlueInstancesOnDeploymentSuccess: BlueInstanceTerminationOption? = builder.terminateBlueInstancesOnDeploymentSuccess

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BlueGreenDeploymentConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BlueGreenDeploymentConfiguration(")
        append("deploymentReadyOption=$deploymentReadyOption,")
        append("greenFleetProvisioningOption=$greenFleetProvisioningOption,")
        append("terminateBlueInstancesOnDeploymentSuccess=$terminateBlueInstancesOnDeploymentSuccess)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentReadyOption?.hashCode() ?: 0
        result = 31 * result + (greenFleetProvisioningOption?.hashCode() ?: 0)
        result = 31 * result + (terminateBlueInstancesOnDeploymentSuccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BlueGreenDeploymentConfiguration

        if (deploymentReadyOption != other.deploymentReadyOption) return false
        if (greenFleetProvisioningOption != other.greenFleetProvisioningOption) return false
        if (terminateBlueInstancesOnDeploymentSuccess != other.terminateBlueInstancesOnDeploymentSuccess) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BlueGreenDeploymentConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BlueGreenDeploymentConfiguration
        /**
         * Information about the action to take when newly provisioned instances are ready to
         * receive traffic in a blue/green deployment.
         */
        fun deploymentReadyOption(deploymentReadyOption: DeploymentReadyOption): FluentBuilder
        /**
         * Information about how instances are provisioned for a replacement environment in a
         * blue/green deployment.
         */
        fun greenFleetProvisioningOption(greenFleetProvisioningOption: GreenFleetProvisioningOption): FluentBuilder
        /**
         * Information about whether to terminate instances in the original fleet during a
         * blue/green deployment.
         */
        fun terminateBlueInstancesOnDeploymentSuccess(terminateBlueInstancesOnDeploymentSuccess: BlueInstanceTerminationOption): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the action to take when newly provisioned instances are ready to
         * receive traffic in a blue/green deployment.
         */
        var deploymentReadyOption: DeploymentReadyOption?
        /**
         * Information about how instances are provisioned for a replacement environment in a
         * blue/green deployment.
         */
        var greenFleetProvisioningOption: GreenFleetProvisioningOption?
        /**
         * Information about whether to terminate instances in the original fleet during a
         * blue/green deployment.
         */
        var terminateBlueInstancesOnDeploymentSuccess: BlueInstanceTerminationOption?

        fun build(): BlueGreenDeploymentConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentReadyOption] inside the given [block]
         */
        fun deploymentReadyOption(block: DeploymentReadyOption.DslBuilder.() -> kotlin.Unit) {
            this.deploymentReadyOption = DeploymentReadyOption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.GreenFleetProvisioningOption] inside the given [block]
         */
        fun greenFleetProvisioningOption(block: GreenFleetProvisioningOption.DslBuilder.() -> kotlin.Unit) {
            this.greenFleetProvisioningOption = GreenFleetProvisioningOption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueInstanceTerminationOption] inside the given [block]
         */
        fun terminateBlueInstancesOnDeploymentSuccess(block: BlueInstanceTerminationOption.DslBuilder.() -> kotlin.Unit) {
            this.terminateBlueInstancesOnDeploymentSuccess = BlueInstanceTerminationOption.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentReadyOption: DeploymentReadyOption? = null
        override var greenFleetProvisioningOption: GreenFleetProvisioningOption? = null
        override var terminateBlueInstancesOnDeploymentSuccess: BlueInstanceTerminationOption? = null

        constructor(x: BlueGreenDeploymentConfiguration) : this() {
            this.deploymentReadyOption = x.deploymentReadyOption
            this.greenFleetProvisioningOption = x.greenFleetProvisioningOption
            this.terminateBlueInstancesOnDeploymentSuccess = x.terminateBlueInstancesOnDeploymentSuccess
        }

        override fun build(): BlueGreenDeploymentConfiguration = BlueGreenDeploymentConfiguration(this)
        override fun deploymentReadyOption(deploymentReadyOption: DeploymentReadyOption): FluentBuilder = apply { this.deploymentReadyOption = deploymentReadyOption }
        override fun greenFleetProvisioningOption(greenFleetProvisioningOption: GreenFleetProvisioningOption): FluentBuilder = apply { this.greenFleetProvisioningOption = greenFleetProvisioningOption }
        override fun terminateBlueInstancesOnDeploymentSuccess(terminateBlueInstancesOnDeploymentSuccess: BlueInstanceTerminationOption): FluentBuilder = apply { this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess }
    }
}
