// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about whether instances in the original environment are terminated when a
 * blue/green deployment is successful. BlueInstanceTerminationOption does not
 * apply to Lambda deployments.
 */
class BlueInstanceTerminationOption private constructor(builder: BuilderImpl) {
    /**
     * The action to take on instances in the original environment after a successful
     * blue/green deployment.
     * TERMINATE: Instances are terminated after a specified wait
     * time.
     * KEEP_ALIVE: Instances are left running after they are
     * deregistered from the load balancer and removed from the deployment
     * group.
     */
    val action: InstanceAction? = builder.action
    /**
     * For an Amazon EC2 deployment, the number of minutes to wait after a successful
     * blue/green deployment before terminating instances from the original environment.
     * For an Amazon ECS deployment, the number of minutes before deleting the original
     * (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the
     * original (blue) task set to a replacement (green) task set.
     * The maximum setting is 2880 minutes (2 days).
     */
    val terminationWaitTimeInMinutes: Int = builder.terminationWaitTimeInMinutes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BlueInstanceTerminationOption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BlueInstanceTerminationOption(")
        append("action=$action,")
        append("terminationWaitTimeInMinutes=$terminationWaitTimeInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (terminationWaitTimeInMinutes)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BlueInstanceTerminationOption

        if (action != other.action) return false
        if (terminationWaitTimeInMinutes != other.terminationWaitTimeInMinutes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BlueInstanceTerminationOption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BlueInstanceTerminationOption
        /**
         * The action to take on instances in the original environment after a successful
         * blue/green deployment.
         * TERMINATE: Instances are terminated after a specified wait
         * time.
         * KEEP_ALIVE: Instances are left running after they are
         * deregistered from the load balancer and removed from the deployment
         * group.
         */
        fun action(action: InstanceAction): FluentBuilder
        /**
         * For an Amazon EC2 deployment, the number of minutes to wait after a successful
         * blue/green deployment before terminating instances from the original environment.
         * For an Amazon ECS deployment, the number of minutes before deleting the original
         * (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the
         * original (blue) task set to a replacement (green) task set.
         * The maximum setting is 2880 minutes (2 days).
         */
        fun terminationWaitTimeInMinutes(terminationWaitTimeInMinutes: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action to take on instances in the original environment after a successful
         * blue/green deployment.
         * TERMINATE: Instances are terminated after a specified wait
         * time.
         * KEEP_ALIVE: Instances are left running after they are
         * deregistered from the load balancer and removed from the deployment
         * group.
         */
        var action: InstanceAction?
        /**
         * For an Amazon EC2 deployment, the number of minutes to wait after a successful
         * blue/green deployment before terminating instances from the original environment.
         * For an Amazon ECS deployment, the number of minutes before deleting the original
         * (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the
         * original (blue) task set to a replacement (green) task set.
         * The maximum setting is 2880 minutes (2 days).
         */
        var terminationWaitTimeInMinutes: Int

        fun build(): BlueInstanceTerminationOption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: InstanceAction? = null
        override var terminationWaitTimeInMinutes: Int = 0

        constructor(x: BlueInstanceTerminationOption) : this() {
            this.action = x.action
            this.terminationWaitTimeInMinutes = x.terminationWaitTimeInMinutes
        }

        override fun build(): BlueInstanceTerminationOption = BlueInstanceTerminationOption(this)
        override fun action(action: InstanceAction): FluentBuilder = apply { this.action = action }
        override fun terminationWaitTimeInMinutes(terminationWaitTimeInMinutes: Int): FluentBuilder = apply { this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes }
    }
}
