// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target to be updated by an AWS CloudFormation blue/green
 * deployment. This target type is used for all deployments initiated by a CloudFormation
 * stack update.
 */
class CloudFormationTarget private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of an AWS CloudFormation blue/green deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The date and time when the target application was updated by an AWS CloudFormation
     * blue/green deployment.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the AWS CloudFormation blue/green deployment to this target
     * application.
     */
    val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The resource type for the AWS CloudFormation blue/green deployment.
     */
    val resourceType: String? = builder.resourceType
    /**
     * The status of an AWS CloudFormation blue/green deployment's target application.
     */
    val status: TargetStatus? = builder.status
    /**
     * The unique ID of a deployment target that has a type
     * of CloudFormationTarget.
     */
    val targetId: String? = builder.targetId
    /**
     * The percentage of production traffic that the target version of an AWS CloudFormation
     * blue/green deployment receives.
     */
    val targetVersionWeight: Double = builder.targetVersionWeight

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudFormationTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFormationTarget(")
        append("deploymentId=$deploymentId,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("targetId=$targetId,")
        append("targetVersionWeight=$targetVersionWeight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetVersionWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudFormationTarget

        if (deploymentId != other.deploymentId) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (targetId != other.targetId) return false
        if (targetVersionWeight != other.targetVersionWeight) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudFormationTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudFormationTarget
        /**
         * The unique ID of an AWS CloudFormation blue/green deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The date and time when the target application was updated by an AWS CloudFormation
         * blue/green deployment.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The lifecycle events of the AWS CloudFormation blue/green deployment to this target
         * application.
         */
        fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder
        /**
         * The resource type for the AWS CloudFormation blue/green deployment.
         */
        fun resourceType(resourceType: String): FluentBuilder
        /**
         * The status of an AWS CloudFormation blue/green deployment's target application.
         */
        fun status(status: TargetStatus): FluentBuilder
        /**
         * The unique ID of a deployment target that has a type
         * of CloudFormationTarget.
         */
        fun targetId(targetId: String): FluentBuilder
        /**
         * The percentage of production traffic that the target version of an AWS CloudFormation
         * blue/green deployment receives.
         */
        fun targetVersionWeight(targetVersionWeight: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of an AWS CloudFormation blue/green deployment.
         */
        var deploymentId: String?
        /**
         * The date and time when the target application was updated by an AWS CloudFormation
         * blue/green deployment.
         */
        var lastUpdatedAt: Instant?
        /**
         * The lifecycle events of the AWS CloudFormation blue/green deployment to this target
         * application.
         */
        var lifecycleEvents: List<LifecycleEvent>?
        /**
         * The resource type for the AWS CloudFormation blue/green deployment.
         */
        var resourceType: String?
        /**
         * The status of an AWS CloudFormation blue/green deployment's target application.
         */
        var status: TargetStatus?
        /**
         * The unique ID of a deployment target that has a type
         * of CloudFormationTarget.
         */
        var targetId: String?
        /**
         * The percentage of production traffic that the target version of an AWS CloudFormation
         * blue/green deployment receives.
         */
        var targetVersionWeight: Double

        fun build(): CloudFormationTarget
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var lastUpdatedAt: Instant? = null
        override var lifecycleEvents: List<LifecycleEvent>? = null
        override var resourceType: String? = null
        override var status: TargetStatus? = null
        override var targetId: String? = null
        override var targetVersionWeight: Double = 0.0

        constructor(x: CloudFormationTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.resourceType = x.resourceType
            this.status = x.status
            this.targetId = x.targetId
            this.targetVersionWeight = x.targetVersionWeight
        }

        override fun build(): CloudFormationTarget = CloudFormationTarget(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder = apply { this.lifecycleEvents = lifecycleEvents }
        override fun resourceType(resourceType: String): FluentBuilder = apply { this.resourceType = resourceType }
        override fun status(status: TargetStatus): FluentBuilder = apply { this.status = status }
        override fun targetId(targetId: String): FluentBuilder = apply { this.targetId = targetId }
        override fun targetVersionWeight(targetVersionWeight: Double): FluentBuilder = apply { this.targetVersionWeight = targetVersionWeight }
    }
}
