// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a CreateApplication operation.
 */
class CreateApplicationRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the application. This name must be unique with the applicable IAM user or
     * AWS account.
     */
    val applicationName: String? = builder.applicationName
    /**
     * The destination platform type for the deployment (Lambda,
     * Server, or ECS).
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The metadata that you apply to CodeDeploy applications to help you organize and
     * categorize them. Each tag consists of a key and an optional value, both of which you
     * define.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateApplicationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("applicationName=$applicationName,")
        append("computePlatform=$computePlatform,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateApplicationRequest

        if (applicationName != other.applicationName) return false
        if (computePlatform != other.computePlatform) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateApplicationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateApplicationRequest
        /**
         * The name of the application. This name must be unique with the applicable IAM user or
         * AWS account.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The metadata that you apply to CodeDeploy applications to help you organize and
         * categorize them. Each tag consists of a key and an optional value, both of which you
         * define.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the application. This name must be unique with the applicable IAM user or
         * AWS account.
         */
        var applicationName: String?
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        var computePlatform: ComputePlatform?
        /**
         * The metadata that you apply to CodeDeploy applications to help you organize and
         * categorize them. Each tag consists of a key and an optional value, both of which you
         * define.
         */
        var tags: List<Tag>?

        fun build(): CreateApplicationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationName: String? = null
        override var computePlatform: ComputePlatform? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateApplicationRequest) : this() {
            this.applicationName = x.applicationName
            this.computePlatform = x.computePlatform
            this.tags = x.tags
        }

        override fun build(): CreateApplicationRequest = CreateApplicationRequest(this)
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
