// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a CreateDeploymentConfig operation.
 */
class CreateDeploymentConfigRequest private constructor(builder: BuilderImpl) {
    /**
     * The destination platform type for the deployment (Lambda,
     * Server, or ECS).
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The name of the deployment configuration to create.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * The minimum number of healthy instances that should be available at any time during
     * the deployment. There are two parameters expected in the input: type and value.
     * The type parameter takes either of the following values:
     * HOST_COUNT: The value parameter represents the minimum number of healthy
     * instances as an absolute value.
     * FLEET_PERCENT: The value parameter represents the minimum number of healthy
     * instances as a percentage of the total number of instances in the deployment. If
     * you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy
     * converts the percentage to the equivalent number of instances and rounds up
     * fractional instances.
     * The value parameter takes an integer.
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT
     * and a value of 95.
     */
    val minimumHealthyHosts: MinimumHealthyHosts? = builder.minimumHealthyHosts
    /**
     * The configuration that specifies how the deployment traffic is routed.
     */
    val trafficRoutingConfig: TrafficRoutingConfig? = builder.trafficRoutingConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDeploymentConfigRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentConfigRequest(")
        append("computePlatform=$computePlatform,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("minimumHealthyHosts=$minimumHealthyHosts,")
        append("trafficRoutingConfig=$trafficRoutingConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computePlatform?.hashCode() ?: 0
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (minimumHealthyHosts?.hashCode() ?: 0)
        result = 31 * result + (trafficRoutingConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDeploymentConfigRequest

        if (computePlatform != other.computePlatform) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (minimumHealthyHosts != other.minimumHealthyHosts) return false
        if (trafficRoutingConfig != other.trafficRoutingConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDeploymentConfigRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDeploymentConfigRequest
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The name of the deployment configuration to create.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * The minimum number of healthy instances that should be available at any time during
         * the deployment. There are two parameters expected in the input: type and value.
         * The type parameter takes either of the following values:
         * HOST_COUNT: The value parameter represents the minimum number of healthy
         * instances as an absolute value.
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy
         * instances as a percentage of the total number of instances in the deployment. If
         * you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy
         * converts the percentage to the equivalent number of instances and rounds up
         * fractional instances.
         * The value parameter takes an integer.
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT
         * and a value of 95.
         */
        fun minimumHealthyHosts(minimumHealthyHosts: MinimumHealthyHosts): FluentBuilder
        /**
         * The configuration that specifies how the deployment traffic is routed.
         */
        fun trafficRoutingConfig(trafficRoutingConfig: TrafficRoutingConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        var computePlatform: ComputePlatform?
        /**
         * The name of the deployment configuration to create.
         */
        var deploymentConfigName: String?
        /**
         * The minimum number of healthy instances that should be available at any time during
         * the deployment. There are two parameters expected in the input: type and value.
         * The type parameter takes either of the following values:
         * HOST_COUNT: The value parameter represents the minimum number of healthy
         * instances as an absolute value.
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy
         * instances as a percentage of the total number of instances in the deployment. If
         * you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy
         * converts the percentage to the equivalent number of instances and rounds up
         * fractional instances.
         * The value parameter takes an integer.
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT
         * and a value of 95.
         */
        var minimumHealthyHosts: MinimumHealthyHosts?
        /**
         * The configuration that specifies how the deployment traffic is routed.
         */
        var trafficRoutingConfig: TrafficRoutingConfig?

        fun build(): CreateDeploymentConfigRequest
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts] inside the given [block]
         */
        fun minimumHealthyHosts(block: MinimumHealthyHosts.DslBuilder.() -> kotlin.Unit) {
            this.minimumHealthyHosts = MinimumHealthyHosts.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig] inside the given [block]
         */
        fun trafficRoutingConfig(block: TrafficRoutingConfig.DslBuilder.() -> kotlin.Unit) {
            this.trafficRoutingConfig = TrafficRoutingConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var computePlatform: ComputePlatform? = null
        override var deploymentConfigName: String? = null
        override var minimumHealthyHosts: MinimumHealthyHosts? = null
        override var trafficRoutingConfig: TrafficRoutingConfig? = null

        constructor(x: CreateDeploymentConfigRequest) : this() {
            this.computePlatform = x.computePlatform
            this.deploymentConfigName = x.deploymentConfigName
            this.minimumHealthyHosts = x.minimumHealthyHosts
            this.trafficRoutingConfig = x.trafficRoutingConfig
        }

        override fun build(): CreateDeploymentConfigRequest = CreateDeploymentConfigRequest(this)
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun minimumHealthyHosts(minimumHealthyHosts: MinimumHealthyHosts): FluentBuilder = apply { this.minimumHealthyHosts = minimumHealthyHosts }
        override fun trafficRoutingConfig(trafficRoutingConfig: TrafficRoutingConfig): FluentBuilder = apply { this.trafficRoutingConfig = trafficRoutingConfig }
    }
}
