// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a CreateDeploymentGroup operation.
 */
class CreateDeploymentGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * Information to add about Amazon CloudWatch alarms when the deployment group is
     * created.
     */
    val alarmConfiguration: AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS
     * account.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Configuration information for an automatic rollback that is added when a deployment
     * group is created.
     */
    val autoRollbackConfiguration: AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * A list of associated Amazon EC2 Auto Scaling groups.
     */
    val autoScalingGroups: List<String>? = builder.autoScalingGroups
    /**
     * Information about blue/green deployment options for a deployment group.
     */
    val blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * If specified, the deployment configuration name can be either one of the predefined
     * configurations provided with AWS CodeDeploy or a custom deployment configuration that
     * you create by calling the create deployment configuration operation.
     * CodeDeployDefault.OneAtATime is the default deployment configuration. It
     * is used if a configuration isn't specified for the deployment or deployment
     * group.
     * For more information about the predefined deployment configurations in AWS CodeDeploy,
     * see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with
     * Deployment Configurations in CodeDeploy in the AWS CodeDeploy User
     * Guide.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * The name of a new deployment group for the specified application.
     */
    val deploymentGroupName: String? = builder.deploymentGroupName
    /**
     * Information about the type of deployment, in-place or blue/green, that you want to run
     * and whether to route deployment traffic behind a load balancer.
     */
    val deploymentStyle: DeploymentStyle? = builder.deploymentStyle
    /**
     * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
     * with any of the specified tags. Cannot be used in the same call as ec2TagSet.
     */
    val ec2TagFilters: List<Ec2TagFilter>? = builder.ec2TagFilters
    /**
     * Information about groups of tags applied to EC2 instances. The deployment group
     * includes only EC2 instances identified by all the tag groups. Cannot be used in the same
     * call as ec2TagFilters.
     */
    val ec2TagSet: Ec2TagSet? = builder.ec2TagSet
    /**
     * The target Amazon ECS services in the deployment group. This applies only to
     * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
     * is specified as an Amazon ECS cluster and service name pair using the format
     * <clustername>:<servicename>.
     */
    val ecsServices: List<EcsService>? = builder.ecsServices
    /**
     * Information about the load balancer used in a deployment.
     */
    val loadBalancerInfo: LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * The on-premises instance tags on which to filter. The deployment group includes
     * on-premises instances with any of the specified tags. Cannot be used in the same call as
     * OnPremisesTagSet.
     */
    val onPremisesInstanceTagFilters: List<TagFilter>? = builder.onPremisesInstanceTagFilters
    /**
     * Information about groups of tags applied to on-premises instances. The deployment
     * group includes only on-premises instances identified by all of the tag groups. Cannot be
     * used in the same call as onPremisesInstanceTagFilters.
     */
    val onPremisesTagSet: OnPremisesTagSet? = builder.onPremisesTagSet
    /**
     * Indicates what happens when new EC2 instances are launched mid-deployment and do not
     * receive the deployed application revision.
     * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
     * one or more 'auto-update outdated instances' deployments to apply the deployed
     * application revision to the new EC2 instances.
     * If this option is set to IGNORE, CodeDeploy does not initiate a
     * deployment to update the new EC2 instances. This may result in instances having
     * different revisions.
     */
    val outdatedInstancesStrategy: OutdatedInstancesStrategy? = builder.outdatedInstancesStrategy
    /**
     * A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the
     * user's behalf when interacting with AWS services.
     */
    val serviceRoleArn: String? = builder.serviceRoleArn
    /**
     * The metadata that you apply to CodeDeploy deployment groups to help you organize and
     * categorize them. Each tag consists of a key and an optional value, both of which you
     * define.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Information about triggers to create when the deployment group is created. For
     * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an
     * AWS CodeDeploy Event in the AWS CodeDeploy User
     * Guide.
     */
    val triggerConfigurations: List<TriggerConfig>? = builder.triggerConfigurations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDeploymentGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentGroupRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("autoScalingGroups=$autoScalingGroups,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("deploymentStyle=$deploymentStyle,")
        append("ec2TagFilters=$ec2TagFilters,")
        append("ec2TagSet=$ec2TagSet,")
        append("ecsServices=$ecsServices,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("onPremisesInstanceTagFilters=$onPremisesInstanceTagFilters,")
        append("onPremisesTagSet=$onPremisesTagSet,")
        append("outdatedInstancesStrategy=$outdatedInstancesStrategy,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("tags=$tags,")
        append("triggerConfigurations=$triggerConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroups?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (ec2TagFilters?.hashCode() ?: 0)
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (ecsServices?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (onPremisesInstanceTagFilters?.hashCode() ?: 0)
        result = 31 * result + (onPremisesTagSet?.hashCode() ?: 0)
        result = 31 * result + (outdatedInstancesStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (triggerConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDeploymentGroupRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (autoScalingGroups != other.autoScalingGroups) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (ec2TagFilters != other.ec2TagFilters) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (ecsServices != other.ecsServices) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (onPremisesInstanceTagFilters != other.onPremisesInstanceTagFilters) return false
        if (onPremisesTagSet != other.onPremisesTagSet) return false
        if (outdatedInstancesStrategy != other.outdatedInstancesStrategy) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (tags != other.tags) return false
        if (triggerConfigurations != other.triggerConfigurations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDeploymentGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDeploymentGroupRequest
        /**
         * Information to add about Amazon CloudWatch alarms when the deployment group is
         * created.
         */
        fun alarmConfiguration(alarmConfiguration: AlarmConfiguration): FluentBuilder
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Configuration information for an automatic rollback that is added when a deployment
         * group is created.
         */
        fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder
        /**
         * A list of associated Amazon EC2 Auto Scaling groups.
         */
        fun autoScalingGroups(autoScalingGroups: List<String>): FluentBuilder
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder
        /**
         * If specified, the deployment configuration name can be either one of the predefined
         * configurations provided with AWS CodeDeploy or a custom deployment configuration that
         * you create by calling the create deployment configuration operation.
         * CodeDeployDefault.OneAtATime is the default deployment configuration. It
         * is used if a configuration isn't specified for the deployment or deployment
         * group.
         * For more information about the predefined deployment configurations in AWS CodeDeploy,
         * see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with
         * Deployment Configurations in CodeDeploy in the AWS CodeDeploy User
         * Guide.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * The name of a new deployment group for the specified application.
         */
        fun deploymentGroupName(deploymentGroupName: String): FluentBuilder
        /**
         * Information about the type of deployment, in-place or blue/green, that you want to run
         * and whether to route deployment traffic behind a load balancer.
         */
        fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder
        /**
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
         * with any of the specified tags. Cannot be used in the same call as ec2TagSet.
         */
        fun ec2TagFilters(ec2TagFilters: List<Ec2TagFilter>): FluentBuilder
        /**
         * Information about groups of tags applied to EC2 instances. The deployment group
         * includes only EC2 instances identified by all the tag groups. Cannot be used in the same
         * call as ec2TagFilters.
         */
        fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        fun ecsServices(ecsServices: List<EcsService>): FluentBuilder
        /**
         * Information about the load balancer used in a deployment.
         */
        fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder
        /**
         * The on-premises instance tags on which to filter. The deployment group includes
         * on-premises instances with any of the specified tags. Cannot be used in the same call as
         * OnPremisesTagSet.
         */
        fun onPremisesInstanceTagFilters(onPremisesInstanceTagFilters: List<TagFilter>): FluentBuilder
        /**
         * Information about groups of tags applied to on-premises instances. The deployment
         * group includes only on-premises instances identified by all of the tag groups. Cannot be
         * used in the same call as onPremisesInstanceTagFilters.
         */
        fun onPremisesTagSet(onPremisesTagSet: OnPremisesTagSet): FluentBuilder
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        fun outdatedInstancesStrategy(outdatedInstancesStrategy: OutdatedInstancesStrategy): FluentBuilder
        /**
         * A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the
         * user's behalf when interacting with AWS services.
         */
        fun serviceRoleArn(serviceRoleArn: String): FluentBuilder
        /**
         * The metadata that you apply to CodeDeploy deployment groups to help you organize and
         * categorize them. Each tag consists of a key and an optional value, both of which you
         * define.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * Information about triggers to create when the deployment group is created. For
         * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an
         * AWS CodeDeploy Event in the AWS CodeDeploy User
         * Guide.
         */
        fun triggerConfigurations(triggerConfigurations: List<TriggerConfig>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information to add about Amazon CloudWatch alarms when the deployment group is
         * created.
         */
        var alarmConfiguration: AlarmConfiguration?
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         */
        var applicationName: String?
        /**
         * Configuration information for an automatic rollback that is added when a deployment
         * group is created.
         */
        var autoRollbackConfiguration: AutoRollbackConfiguration?
        /**
         * A list of associated Amazon EC2 Auto Scaling groups.
         */
        var autoScalingGroups: List<String>?
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration?
        /**
         * If specified, the deployment configuration name can be either one of the predefined
         * configurations provided with AWS CodeDeploy or a custom deployment configuration that
         * you create by calling the create deployment configuration operation.
         * CodeDeployDefault.OneAtATime is the default deployment configuration. It
         * is used if a configuration isn't specified for the deployment or deployment
         * group.
         * For more information about the predefined deployment configurations in AWS CodeDeploy,
         * see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with
         * Deployment Configurations in CodeDeploy in the AWS CodeDeploy User
         * Guide.
         */
        var deploymentConfigName: String?
        /**
         * The name of a new deployment group for the specified application.
         */
        var deploymentGroupName: String?
        /**
         * Information about the type of deployment, in-place or blue/green, that you want to run
         * and whether to route deployment traffic behind a load balancer.
         */
        var deploymentStyle: DeploymentStyle?
        /**
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
         * with any of the specified tags. Cannot be used in the same call as ec2TagSet.
         */
        var ec2TagFilters: List<Ec2TagFilter>?
        /**
         * Information about groups of tags applied to EC2 instances. The deployment group
         * includes only EC2 instances identified by all the tag groups. Cannot be used in the same
         * call as ec2TagFilters.
         */
        var ec2TagSet: Ec2TagSet?
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        var ecsServices: List<EcsService>?
        /**
         * Information about the load balancer used in a deployment.
         */
        var loadBalancerInfo: LoadBalancerInfo?
        /**
         * The on-premises instance tags on which to filter. The deployment group includes
         * on-premises instances with any of the specified tags. Cannot be used in the same call as
         * OnPremisesTagSet.
         */
        var onPremisesInstanceTagFilters: List<TagFilter>?
        /**
         * Information about groups of tags applied to on-premises instances. The deployment
         * group includes only on-premises instances identified by all of the tag groups. Cannot be
         * used in the same call as onPremisesInstanceTagFilters.
         */
        var onPremisesTagSet: OnPremisesTagSet?
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        var outdatedInstancesStrategy: OutdatedInstancesStrategy?
        /**
         * A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the
         * user's behalf when interacting with AWS services.
         */
        var serviceRoleArn: String?
        /**
         * The metadata that you apply to CodeDeploy deployment groups to help you organize and
         * categorize them. Each tag consists of a key and an optional value, both of which you
         * define.
         */
        var tags: List<Tag>?
        /**
         * Information about triggers to create when the deployment group is created. For
         * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an
         * AWS CodeDeploy Event in the AWS CodeDeploy User
         * Guide.
         */
        var triggerConfigurations: List<TriggerConfig>?

        fun build(): CreateDeploymentGroupRequest
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        fun alarmConfiguration(block: AlarmConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.alarmConfiguration = AlarmConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        fun autoRollbackConfiguration(block: AutoRollbackConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = AutoRollbackConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        fun blueGreenDeploymentConfiguration(block: BlueGreenDeploymentConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = BlueGreenDeploymentConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        fun deploymentStyle(block: DeploymentStyle.DslBuilder.() -> kotlin.Unit) {
            this.deploymentStyle = DeploymentStyle.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        fun ec2TagSet(block: Ec2TagSet.DslBuilder.() -> kotlin.Unit) {
            this.ec2TagSet = Ec2TagSet.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        fun loadBalancerInfo(block: LoadBalancerInfo.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancerInfo = LoadBalancerInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet] inside the given [block]
         */
        fun onPremisesTagSet(block: OnPremisesTagSet.DslBuilder.() -> kotlin.Unit) {
            this.onPremisesTagSet = OnPremisesTagSet.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarmConfiguration: AlarmConfiguration? = null
        override var applicationName: String? = null
        override var autoRollbackConfiguration: AutoRollbackConfiguration? = null
        override var autoScalingGroups: List<String>? = null
        override var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = null
        override var deploymentConfigName: String? = null
        override var deploymentGroupName: String? = null
        override var deploymentStyle: DeploymentStyle? = null
        override var ec2TagFilters: List<Ec2TagFilter>? = null
        override var ec2TagSet: Ec2TagSet? = null
        override var ecsServices: List<EcsService>? = null
        override var loadBalancerInfo: LoadBalancerInfo? = null
        override var onPremisesInstanceTagFilters: List<TagFilter>? = null
        override var onPremisesTagSet: OnPremisesTagSet? = null
        override var outdatedInstancesStrategy: OutdatedInstancesStrategy? = null
        override var serviceRoleArn: String? = null
        override var tags: List<Tag>? = null
        override var triggerConfigurations: List<TriggerConfig>? = null

        constructor(x: CreateDeploymentGroupRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.autoScalingGroups = x.autoScalingGroups
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupName = x.deploymentGroupName
            this.deploymentStyle = x.deploymentStyle
            this.ec2TagFilters = x.ec2TagFilters
            this.ec2TagSet = x.ec2TagSet
            this.ecsServices = x.ecsServices
            this.loadBalancerInfo = x.loadBalancerInfo
            this.onPremisesInstanceTagFilters = x.onPremisesInstanceTagFilters
            this.onPremisesTagSet = x.onPremisesTagSet
            this.outdatedInstancesStrategy = x.outdatedInstancesStrategy
            this.serviceRoleArn = x.serviceRoleArn
            this.tags = x.tags
            this.triggerConfigurations = x.triggerConfigurations
        }

        override fun build(): CreateDeploymentGroupRequest = CreateDeploymentGroupRequest(this)
        override fun alarmConfiguration(alarmConfiguration: AlarmConfiguration): FluentBuilder = apply { this.alarmConfiguration = alarmConfiguration }
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder = apply { this.autoRollbackConfiguration = autoRollbackConfiguration }
        override fun autoScalingGroups(autoScalingGroups: List<String>): FluentBuilder = apply { this.autoScalingGroups = autoScalingGroups }
        override fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder = apply { this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun deploymentGroupName(deploymentGroupName: String): FluentBuilder = apply { this.deploymentGroupName = deploymentGroupName }
        override fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder = apply { this.deploymentStyle = deploymentStyle }
        override fun ec2TagFilters(ec2TagFilters: List<Ec2TagFilter>): FluentBuilder = apply { this.ec2TagFilters = ec2TagFilters }
        override fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder = apply { this.ec2TagSet = ec2TagSet }
        override fun ecsServices(ecsServices: List<EcsService>): FluentBuilder = apply { this.ecsServices = ecsServices }
        override fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder = apply { this.loadBalancerInfo = loadBalancerInfo }
        override fun onPremisesInstanceTagFilters(onPremisesInstanceTagFilters: List<TagFilter>): FluentBuilder = apply { this.onPremisesInstanceTagFilters = onPremisesInstanceTagFilters }
        override fun onPremisesTagSet(onPremisesTagSet: OnPremisesTagSet): FluentBuilder = apply { this.onPremisesTagSet = onPremisesTagSet }
        override fun outdatedInstancesStrategy(outdatedInstancesStrategy: OutdatedInstancesStrategy): FluentBuilder = apply { this.outdatedInstancesStrategy = outdatedInstancesStrategy }
        override fun serviceRoleArn(serviceRoleArn: String): FluentBuilder = apply { this.serviceRoleArn = serviceRoleArn }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun triggerConfigurations(triggerConfigurations: List<TriggerConfig>): FluentBuilder = apply { this.triggerConfigurations = triggerConfigurations }
    }
}
