// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a CreateDeployment operation.
 */
class CreateDeploymentRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS
     * account.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Configuration information for an automatic rollback that is added when a deployment is
     * created.
     */
    val autoRollbackConfiguration: AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * The name of a deployment configuration associated with the IAM user or AWS
     * account.
     * If not specified, the value configured in the deployment group is used as the default.
     * If the deployment group does not have a deployment configuration associated with it,
     * CodeDeployDefault.OneAtATime is used by default.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * The name of the deployment group.
     */
    val deploymentGroupName: String? = builder.deploymentGroupName
    /**
     * A comment about the deployment.
     */
    val description: String? = builder.description
    /**
     * Information about how AWS CodeDeploy handles files that already exist in a deployment
     * target location but weren't part of the previous successful deployment.
     * The fileExistsBehavior parameter takes any of the following
     * values:
     * DISALLOW: The deployment fails. This is also the default behavior if no option
     * is specified.
     * OVERWRITE: The version of the file from the application revision currently
     * being deployed replaces the version already on the instance.
     * RETAIN: The version of the file already on the instance is kept and used as
     * part of the new deployment.
     */
    val fileExistsBehavior: FileExistsBehavior? = builder.fileExistsBehavior
    /**
     * If true, then if an ApplicationStop, BeforeBlockTraffic, or
     * AfterBlockTraffic deployment lifecycle event to an instance fails, then
     * the deployment continues to the next deployment lifecycle event. For example, if
     * ApplicationStop fails, the deployment continues with
     * DownloadBundle. If BeforeBlockTraffic fails, the
     * deployment continues with BlockTraffic. If AfterBlockTraffic
     * fails, the deployment continues with ApplicationStop.
     * If false or not specified, then if a lifecycle event fails during a deployment to an
     * instance, that deployment fails. If deployment to that instance is part of an overall
     * deployment and the number of healthy hosts is not less than the minimum number of
     * healthy hosts, then a deployment to the next instance is attempted.
     * During a deployment, the AWS CodeDeploy agent runs the scripts specified for
     * ApplicationStop, BeforeBlockTraffic, and
     * AfterBlockTraffic in the AppSpec file from the previous successful
     * deployment. (All other scripts are run from the AppSpec file in the current deployment.)
     * If one of these scripts contains an error and does not run successfully, the deployment
     * can fail.
     * If the cause of the failure is a script from the last successful deployment that will
     * never run successfully, create a new deployment and use
     * ignoreApplicationStopFailures to specify that the
     * ApplicationStop, BeforeBlockTraffic, and
     * AfterBlockTraffic failures should be ignored.
     */
    val ignoreApplicationStopFailures: Boolean = builder.ignoreApplicationStopFailures
    /**
     * The type and location of the revision to deploy.
     */
    val revision: RevisionLocation? = builder.revision
    /**
     * Information about the instances that belong to the replacement environment in a
     * blue/green deployment.
     */
    val targetInstances: TargetInstances? = builder.targetInstances
    /**
     * Indicates whether to deploy to all instances or only to instances that are not
     * running the latest application revision.
     */
    val updateOutdatedInstancesOnly: Boolean = builder.updateOutdatedInstancesOnly

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDeploymentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("description=$description,")
        append("fileExistsBehavior=$fileExistsBehavior,")
        append("ignoreApplicationStopFailures=$ignoreApplicationStopFailures,")
        append("revision=$revision,")
        append("targetInstances=$targetInstances,")
        append("updateOutdatedInstancesOnly=$updateOutdatedInstancesOnly)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fileExistsBehavior?.hashCode() ?: 0)
        result = 31 * result + (ignoreApplicationStopFailures.hashCode())
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (targetInstances?.hashCode() ?: 0)
        result = 31 * result + (updateOutdatedInstancesOnly.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDeploymentRequest

        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (description != other.description) return false
        if (fileExistsBehavior != other.fileExistsBehavior) return false
        if (ignoreApplicationStopFailures != other.ignoreApplicationStopFailures) return false
        if (revision != other.revision) return false
        if (targetInstances != other.targetInstances) return false
        if (updateOutdatedInstancesOnly != other.updateOutdatedInstancesOnly) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDeploymentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDeploymentRequest
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Configuration information for an automatic rollback that is added when a deployment is
         * created.
         */
        fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder
        /**
         * The name of a deployment configuration associated with the IAM user or AWS
         * account.
         * If not specified, the value configured in the deployment group is used as the default.
         * If the deployment group does not have a deployment configuration associated with it,
         * CodeDeployDefault.OneAtATime is used by default.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * The name of the deployment group.
         */
        fun deploymentGroupName(deploymentGroupName: String): FluentBuilder
        /**
         * A comment about the deployment.
         */
        fun description(description: String): FluentBuilder
        /**
         * Information about how AWS CodeDeploy handles files that already exist in a deployment
         * target location but weren't part of the previous successful deployment.
         * The fileExistsBehavior parameter takes any of the following
         * values:
         * DISALLOW: The deployment fails. This is also the default behavior if no option
         * is specified.
         * OVERWRITE: The version of the file from the application revision currently
         * being deployed replaces the version already on the instance.
         * RETAIN: The version of the file already on the instance is kept and used as
         * part of the new deployment.
         */
        fun fileExistsBehavior(fileExistsBehavior: FileExistsBehavior): FluentBuilder
        /**
         * If true, then if an ApplicationStop, BeforeBlockTraffic, or
         * AfterBlockTraffic deployment lifecycle event to an instance fails, then
         * the deployment continues to the next deployment lifecycle event. For example, if
         * ApplicationStop fails, the deployment continues with
         * DownloadBundle. If BeforeBlockTraffic fails, the
         * deployment continues with BlockTraffic. If AfterBlockTraffic
         * fails, the deployment continues with ApplicationStop.
         * If false or not specified, then if a lifecycle event fails during a deployment to an
         * instance, that deployment fails. If deployment to that instance is part of an overall
         * deployment and the number of healthy hosts is not less than the minimum number of
         * healthy hosts, then a deployment to the next instance is attempted.
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic in the AppSpec file from the previous successful
         * deployment. (All other scripts are run from the AppSpec file in the current deployment.)
         * If one of these scripts contains an error and does not run successfully, the deployment
         * can fail.
         * If the cause of the failure is a script from the last successful deployment that will
         * never run successfully, create a new deployment and use
         * ignoreApplicationStopFailures to specify that the
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic failures should be ignored.
         */
        fun ignoreApplicationStopFailures(ignoreApplicationStopFailures: Boolean): FluentBuilder
        /**
         * The type and location of the revision to deploy.
         */
        fun revision(revision: RevisionLocation): FluentBuilder
        /**
         * Information about the instances that belong to the replacement environment in a
         * blue/green deployment.
         */
        fun targetInstances(targetInstances: TargetInstances): FluentBuilder
        /**
         * Indicates whether to deploy to all instances or only to instances that are not
         * running the latest application revision.
         */
        fun updateOutdatedInstancesOnly(updateOutdatedInstancesOnly: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         */
        var applicationName: String?
        /**
         * Configuration information for an automatic rollback that is added when a deployment is
         * created.
         */
        var autoRollbackConfiguration: AutoRollbackConfiguration?
        /**
         * The name of a deployment configuration associated with the IAM user or AWS
         * account.
         * If not specified, the value configured in the deployment group is used as the default.
         * If the deployment group does not have a deployment configuration associated with it,
         * CodeDeployDefault.OneAtATime is used by default.
         */
        var deploymentConfigName: String?
        /**
         * The name of the deployment group.
         */
        var deploymentGroupName: String?
        /**
         * A comment about the deployment.
         */
        var description: String?
        /**
         * Information about how AWS CodeDeploy handles files that already exist in a deployment
         * target location but weren't part of the previous successful deployment.
         * The fileExistsBehavior parameter takes any of the following
         * values:
         * DISALLOW: The deployment fails. This is also the default behavior if no option
         * is specified.
         * OVERWRITE: The version of the file from the application revision currently
         * being deployed replaces the version already on the instance.
         * RETAIN: The version of the file already on the instance is kept and used as
         * part of the new deployment.
         */
        var fileExistsBehavior: FileExistsBehavior?
        /**
         * If true, then if an ApplicationStop, BeforeBlockTraffic, or
         * AfterBlockTraffic deployment lifecycle event to an instance fails, then
         * the deployment continues to the next deployment lifecycle event. For example, if
         * ApplicationStop fails, the deployment continues with
         * DownloadBundle. If BeforeBlockTraffic fails, the
         * deployment continues with BlockTraffic. If AfterBlockTraffic
         * fails, the deployment continues with ApplicationStop.
         * If false or not specified, then if a lifecycle event fails during a deployment to an
         * instance, that deployment fails. If deployment to that instance is part of an overall
         * deployment and the number of healthy hosts is not less than the minimum number of
         * healthy hosts, then a deployment to the next instance is attempted.
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic in the AppSpec file from the previous successful
         * deployment. (All other scripts are run from the AppSpec file in the current deployment.)
         * If one of these scripts contains an error and does not run successfully, the deployment
         * can fail.
         * If the cause of the failure is a script from the last successful deployment that will
         * never run successfully, create a new deployment and use
         * ignoreApplicationStopFailures to specify that the
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic failures should be ignored.
         */
        var ignoreApplicationStopFailures: Boolean
        /**
         * The type and location of the revision to deploy.
         */
        var revision: RevisionLocation?
        /**
         * Information about the instances that belong to the replacement environment in a
         * blue/green deployment.
         */
        var targetInstances: TargetInstances?
        /**
         * Indicates whether to deploy to all instances or only to instances that are not
         * running the latest application revision.
         */
        var updateOutdatedInstancesOnly: Boolean

        fun build(): CreateDeploymentRequest
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        fun autoRollbackConfiguration(block: AutoRollbackConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = AutoRollbackConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        fun revision(block: RevisionLocation.DslBuilder.() -> kotlin.Unit) {
            this.revision = RevisionLocation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TargetInstances] inside the given [block]
         */
        fun targetInstances(block: TargetInstances.DslBuilder.() -> kotlin.Unit) {
            this.targetInstances = TargetInstances.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationName: String? = null
        override var autoRollbackConfiguration: AutoRollbackConfiguration? = null
        override var deploymentConfigName: String? = null
        override var deploymentGroupName: String? = null
        override var description: String? = null
        override var fileExistsBehavior: FileExistsBehavior? = null
        override var ignoreApplicationStopFailures: Boolean = false
        override var revision: RevisionLocation? = null
        override var targetInstances: TargetInstances? = null
        override var updateOutdatedInstancesOnly: Boolean = false

        constructor(x: CreateDeploymentRequest) : this() {
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupName = x.deploymentGroupName
            this.description = x.description
            this.fileExistsBehavior = x.fileExistsBehavior
            this.ignoreApplicationStopFailures = x.ignoreApplicationStopFailures
            this.revision = x.revision
            this.targetInstances = x.targetInstances
            this.updateOutdatedInstancesOnly = x.updateOutdatedInstancesOnly
        }

        override fun build(): CreateDeploymentRequest = CreateDeploymentRequest(this)
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder = apply { this.autoRollbackConfiguration = autoRollbackConfiguration }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun deploymentGroupName(deploymentGroupName: String): FluentBuilder = apply { this.deploymentGroupName = deploymentGroupName }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun fileExistsBehavior(fileExistsBehavior: FileExistsBehavior): FluentBuilder = apply { this.fileExistsBehavior = fileExistsBehavior }
        override fun ignoreApplicationStopFailures(ignoreApplicationStopFailures: Boolean): FluentBuilder = apply { this.ignoreApplicationStopFailures = ignoreApplicationStopFailures }
        override fun revision(revision: RevisionLocation): FluentBuilder = apply { this.revision = revision }
        override fun targetInstances(targetInstances: TargetInstances): FluentBuilder = apply { this.targetInstances = targetInstances }
        override fun updateOutdatedInstancesOnly(updateOutdatedInstancesOnly: Boolean): FluentBuilder = apply { this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly }
    }
}
