// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a deployment configuration.
 */
class DeploymentConfigInfo private constructor(builder: BuilderImpl) {
    /**
     * The destination platform type for the deployment (Lambda,
     * Server, or ECS).
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The time at which the deployment configuration was created.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The deployment configuration ID.
     */
    val deploymentConfigId: String? = builder.deploymentConfigId
    /**
     * The deployment configuration name.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * Information about the number or percentage of minimum healthy instance.
     */
    val minimumHealthyHosts: MinimumHealthyHosts? = builder.minimumHealthyHosts
    /**
     * The configuration that specifies how the deployment traffic is routed. Used for
     * deployments with a Lambda or ECS compute platform only.
     */
    val trafficRoutingConfig: TrafficRoutingConfig? = builder.trafficRoutingConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentConfigInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentConfigInfo(")
        append("computePlatform=$computePlatform,")
        append("createTime=$createTime,")
        append("deploymentConfigId=$deploymentConfigId,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("minimumHealthyHosts=$minimumHealthyHosts,")
        append("trafficRoutingConfig=$trafficRoutingConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computePlatform?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigId?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (minimumHealthyHosts?.hashCode() ?: 0)
        result = 31 * result + (trafficRoutingConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentConfigInfo

        if (computePlatform != other.computePlatform) return false
        if (createTime != other.createTime) return false
        if (deploymentConfigId != other.deploymentConfigId) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (minimumHealthyHosts != other.minimumHealthyHosts) return false
        if (trafficRoutingConfig != other.trafficRoutingConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentConfigInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentConfigInfo
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The time at which the deployment configuration was created.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The deployment configuration ID.
         */
        fun deploymentConfigId(deploymentConfigId: String): FluentBuilder
        /**
         * The deployment configuration name.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * Information about the number or percentage of minimum healthy instance.
         */
        fun minimumHealthyHosts(minimumHealthyHosts: MinimumHealthyHosts): FluentBuilder
        /**
         * The configuration that specifies how the deployment traffic is routed. Used for
         * deployments with a Lambda or ECS compute platform only.
         */
        fun trafficRoutingConfig(trafficRoutingConfig: TrafficRoutingConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        var computePlatform: ComputePlatform?
        /**
         * The time at which the deployment configuration was created.
         */
        var createTime: Instant?
        /**
         * The deployment configuration ID.
         */
        var deploymentConfigId: String?
        /**
         * The deployment configuration name.
         */
        var deploymentConfigName: String?
        /**
         * Information about the number or percentage of minimum healthy instance.
         */
        var minimumHealthyHosts: MinimumHealthyHosts?
        /**
         * The configuration that specifies how the deployment traffic is routed. Used for
         * deployments with a Lambda or ECS compute platform only.
         */
        var trafficRoutingConfig: TrafficRoutingConfig?

        fun build(): DeploymentConfigInfo
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts] inside the given [block]
         */
        fun minimumHealthyHosts(block: MinimumHealthyHosts.DslBuilder.() -> kotlin.Unit) {
            this.minimumHealthyHosts = MinimumHealthyHosts.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig] inside the given [block]
         */
        fun trafficRoutingConfig(block: TrafficRoutingConfig.DslBuilder.() -> kotlin.Unit) {
            this.trafficRoutingConfig = TrafficRoutingConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var computePlatform: ComputePlatform? = null
        override var createTime: Instant? = null
        override var deploymentConfigId: String? = null
        override var deploymentConfigName: String? = null
        override var minimumHealthyHosts: MinimumHealthyHosts? = null
        override var trafficRoutingConfig: TrafficRoutingConfig? = null

        constructor(x: DeploymentConfigInfo) : this() {
            this.computePlatform = x.computePlatform
            this.createTime = x.createTime
            this.deploymentConfigId = x.deploymentConfigId
            this.deploymentConfigName = x.deploymentConfigName
            this.minimumHealthyHosts = x.minimumHealthyHosts
            this.trafficRoutingConfig = x.trafficRoutingConfig
        }

        override fun build(): DeploymentConfigInfo = DeploymentConfigInfo(this)
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun deploymentConfigId(deploymentConfigId: String): FluentBuilder = apply { this.deploymentConfigId = deploymentConfigId }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun minimumHealthyHosts(minimumHealthyHosts: MinimumHealthyHosts): FluentBuilder = apply { this.minimumHealthyHosts = minimumHealthyHosts }
        override fun trafficRoutingConfig(trafficRoutingConfig: TrafficRoutingConfig): FluentBuilder = apply { this.trafficRoutingConfig = trafficRoutingConfig }
    }
}
