// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a deployment group.
 */
class DeploymentGroupInfo private constructor(builder: BuilderImpl) {
    /**
     * A list of alarms associated with the deployment group.
     */
    val alarmConfiguration: AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The application name.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Information about the automatic rollback configuration associated with the deployment
     * group.
     */
    val autoRollbackConfiguration: AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * A list of associated Auto Scaling groups.
     */
    val autoScalingGroups: List<AutoScalingGroup>? = builder.autoScalingGroups
    /**
     * Information about blue/green deployment options for a deployment group.
     */
    val blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * The destination platform type for the deployment (Lambda,
     * Server, or ECS).
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The deployment configuration name.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * The deployment group ID.
     */
    val deploymentGroupId: String? = builder.deploymentGroupId
    /**
     * The deployment group name.
     */
    val deploymentGroupName: String? = builder.deploymentGroupName
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to
     * run and whether to route deployment traffic behind a load balancer.
     */
    val deploymentStyle: DeploymentStyle? = builder.deploymentStyle
    /**
     * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
     * with any of the specified tags.
     */
    val ec2TagFilters: List<Ec2TagFilter>? = builder.ec2TagFilters
    /**
     * Information about groups of tags applied to an EC2 instance. The deployment group
     * includes only EC2 instances identified by all of the tag groups. Cannot be used in the
     * same call as ec2TagFilters.
     */
    val ec2TagSet: Ec2TagSet? = builder.ec2TagSet
    /**
     * The target Amazon ECS services in the deployment group. This applies only to
     * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
     * is specified as an Amazon ECS cluster and service name pair using the format
     * <clustername>:<servicename>.
     */
    val ecsServices: List<EcsService>? = builder.ecsServices
    /**
     * Information about the most recent attempted deployment to the deployment group.
     */
    val lastAttemptedDeployment: LastDeploymentInfo? = builder.lastAttemptedDeployment
    /**
     * Information about the most recent successful deployment to the deployment
     * group.
     */
    val lastSuccessfulDeployment: LastDeploymentInfo? = builder.lastSuccessfulDeployment
    /**
     * Information about the load balancer to use in a deployment.
     */
    val loadBalancerInfo: LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * The on-premises instance tags on which to filter. The deployment group includes
     * on-premises instances with any of the specified tags.
     */
    val onPremisesInstanceTagFilters: List<TagFilter>? = builder.onPremisesInstanceTagFilters
    /**
     * Information about groups of tags applied to an on-premises instance. The deployment
     * group includes only on-premises instances identified by all the tag groups. Cannot be
     * used in the same call as onPremisesInstanceTagFilters.
     */
    val onPremisesTagSet: OnPremisesTagSet? = builder.onPremisesTagSet
    /**
     * Indicates what happens when new EC2 instances are launched mid-deployment and do not
     * receive the deployed application revision.
     * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
     * one or more 'auto-update outdated instances' deployments to apply the deployed
     * application revision to the new EC2 instances.
     * If this option is set to IGNORE, CodeDeploy does not initiate a
     * deployment to update the new EC2 instances. This may result in instances having
     * different revisions.
     */
    val outdatedInstancesStrategy: OutdatedInstancesStrategy? = builder.outdatedInstancesStrategy
    /**
     * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make
     * calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a
     * Service Role for AWS CodeDeploy in the AWS CodeDeploy User
     * Guide.
     */
    val serviceRoleArn: String? = builder.serviceRoleArn
    /**
     * Information about the deployment group's target revision, including type and
     * location.
     */
    val targetRevision: RevisionLocation? = builder.targetRevision
    /**
     * Information about triggers associated with the deployment group.
     */
    val triggerConfigurations: List<TriggerConfig>? = builder.triggerConfigurations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentGroupInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentGroupInfo(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("autoScalingGroups=$autoScalingGroups,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("computePlatform=$computePlatform,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupId=$deploymentGroupId,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("deploymentStyle=$deploymentStyle,")
        append("ec2TagFilters=$ec2TagFilters,")
        append("ec2TagSet=$ec2TagSet,")
        append("ecsServices=$ecsServices,")
        append("lastAttemptedDeployment=$lastAttemptedDeployment,")
        append("lastSuccessfulDeployment=$lastSuccessfulDeployment,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("onPremisesInstanceTagFilters=$onPremisesInstanceTagFilters,")
        append("onPremisesTagSet=$onPremisesTagSet,")
        append("outdatedInstancesStrategy=$outdatedInstancesStrategy,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targetRevision=$targetRevision,")
        append("triggerConfigurations=$triggerConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroups?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupId?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (ec2TagFilters?.hashCode() ?: 0)
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (ecsServices?.hashCode() ?: 0)
        result = 31 * result + (lastAttemptedDeployment?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulDeployment?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (onPremisesInstanceTagFilters?.hashCode() ?: 0)
        result = 31 * result + (onPremisesTagSet?.hashCode() ?: 0)
        result = 31 * result + (outdatedInstancesStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targetRevision?.hashCode() ?: 0)
        result = 31 * result + (triggerConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentGroupInfo

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (autoScalingGroups != other.autoScalingGroups) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (computePlatform != other.computePlatform) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupId != other.deploymentGroupId) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (ec2TagFilters != other.ec2TagFilters) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (ecsServices != other.ecsServices) return false
        if (lastAttemptedDeployment != other.lastAttemptedDeployment) return false
        if (lastSuccessfulDeployment != other.lastSuccessfulDeployment) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (onPremisesInstanceTagFilters != other.onPremisesInstanceTagFilters) return false
        if (onPremisesTagSet != other.onPremisesTagSet) return false
        if (outdatedInstancesStrategy != other.outdatedInstancesStrategy) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targetRevision != other.targetRevision) return false
        if (triggerConfigurations != other.triggerConfigurations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentGroupInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentGroupInfo
        /**
         * A list of alarms associated with the deployment group.
         */
        fun alarmConfiguration(alarmConfiguration: AlarmConfiguration): FluentBuilder
        /**
         * The application name.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Information about the automatic rollback configuration associated with the deployment
         * group.
         */
        fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder
        /**
         * A list of associated Auto Scaling groups.
         */
        fun autoScalingGroups(autoScalingGroups: List<AutoScalingGroup>): FluentBuilder
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The deployment configuration name.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * The deployment group ID.
         */
        fun deploymentGroupId(deploymentGroupId: String): FluentBuilder
        /**
         * The deployment group name.
         */
        fun deploymentGroupName(deploymentGroupName: String): FluentBuilder
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder
        /**
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
         * with any of the specified tags.
         */
        fun ec2TagFilters(ec2TagFilters: List<Ec2TagFilter>): FluentBuilder
        /**
         * Information about groups of tags applied to an EC2 instance. The deployment group
         * includes only EC2 instances identified by all of the tag groups. Cannot be used in the
         * same call as ec2TagFilters.
         */
        fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        fun ecsServices(ecsServices: List<EcsService>): FluentBuilder
        /**
         * Information about the most recent attempted deployment to the deployment group.
         */
        fun lastAttemptedDeployment(lastAttemptedDeployment: LastDeploymentInfo): FluentBuilder
        /**
         * Information about the most recent successful deployment to the deployment
         * group.
         */
        fun lastSuccessfulDeployment(lastSuccessfulDeployment: LastDeploymentInfo): FluentBuilder
        /**
         * Information about the load balancer to use in a deployment.
         */
        fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder
        /**
         * The on-premises instance tags on which to filter. The deployment group includes
         * on-premises instances with any of the specified tags.
         */
        fun onPremisesInstanceTagFilters(onPremisesInstanceTagFilters: List<TagFilter>): FluentBuilder
        /**
         * Information about groups of tags applied to an on-premises instance. The deployment
         * group includes only on-premises instances identified by all the tag groups. Cannot be
         * used in the same call as onPremisesInstanceTagFilters.
         */
        fun onPremisesTagSet(onPremisesTagSet: OnPremisesTagSet): FluentBuilder
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        fun outdatedInstancesStrategy(outdatedInstancesStrategy: OutdatedInstancesStrategy): FluentBuilder
        /**
         * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make
         * calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a
         * Service Role for AWS CodeDeploy in the AWS CodeDeploy User
         * Guide.
         */
        fun serviceRoleArn(serviceRoleArn: String): FluentBuilder
        /**
         * Information about the deployment group's target revision, including type and
         * location.
         */
        fun targetRevision(targetRevision: RevisionLocation): FluentBuilder
        /**
         * Information about triggers associated with the deployment group.
         */
        fun triggerConfigurations(triggerConfigurations: List<TriggerConfig>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of alarms associated with the deployment group.
         */
        var alarmConfiguration: AlarmConfiguration?
        /**
         * The application name.
         */
        var applicationName: String?
        /**
         * Information about the automatic rollback configuration associated with the deployment
         * group.
         */
        var autoRollbackConfiguration: AutoRollbackConfiguration?
        /**
         * A list of associated Auto Scaling groups.
         */
        var autoScalingGroups: List<AutoScalingGroup>?
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration?
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        var computePlatform: ComputePlatform?
        /**
         * The deployment configuration name.
         */
        var deploymentConfigName: String?
        /**
         * The deployment group ID.
         */
        var deploymentGroupId: String?
        /**
         * The deployment group name.
         */
        var deploymentGroupName: String?
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        var deploymentStyle: DeploymentStyle?
        /**
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
         * with any of the specified tags.
         */
        var ec2TagFilters: List<Ec2TagFilter>?
        /**
         * Information about groups of tags applied to an EC2 instance. The deployment group
         * includes only EC2 instances identified by all of the tag groups. Cannot be used in the
         * same call as ec2TagFilters.
         */
        var ec2TagSet: Ec2TagSet?
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        var ecsServices: List<EcsService>?
        /**
         * Information about the most recent attempted deployment to the deployment group.
         */
        var lastAttemptedDeployment: LastDeploymentInfo?
        /**
         * Information about the most recent successful deployment to the deployment
         * group.
         */
        var lastSuccessfulDeployment: LastDeploymentInfo?
        /**
         * Information about the load balancer to use in a deployment.
         */
        var loadBalancerInfo: LoadBalancerInfo?
        /**
         * The on-premises instance tags on which to filter. The deployment group includes
         * on-premises instances with any of the specified tags.
         */
        var onPremisesInstanceTagFilters: List<TagFilter>?
        /**
         * Information about groups of tags applied to an on-premises instance. The deployment
         * group includes only on-premises instances identified by all the tag groups. Cannot be
         * used in the same call as onPremisesInstanceTagFilters.
         */
        var onPremisesTagSet: OnPremisesTagSet?
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        var outdatedInstancesStrategy: OutdatedInstancesStrategy?
        /**
         * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make
         * calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a
         * Service Role for AWS CodeDeploy in the AWS CodeDeploy User
         * Guide.
         */
        var serviceRoleArn: String?
        /**
         * Information about the deployment group's target revision, including type and
         * location.
         */
        var targetRevision: RevisionLocation?
        /**
         * Information about triggers associated with the deployment group.
         */
        var triggerConfigurations: List<TriggerConfig>?

        fun build(): DeploymentGroupInfo
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        fun alarmConfiguration(block: AlarmConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.alarmConfiguration = AlarmConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        fun autoRollbackConfiguration(block: AutoRollbackConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = AutoRollbackConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        fun blueGreenDeploymentConfiguration(block: BlueGreenDeploymentConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = BlueGreenDeploymentConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        fun deploymentStyle(block: DeploymentStyle.DslBuilder.() -> kotlin.Unit) {
            this.deploymentStyle = DeploymentStyle.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        fun ec2TagSet(block: Ec2TagSet.DslBuilder.() -> kotlin.Unit) {
            this.ec2TagSet = Ec2TagSet.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LastDeploymentInfo] inside the given [block]
         */
        fun lastAttemptedDeployment(block: LastDeploymentInfo.DslBuilder.() -> kotlin.Unit) {
            this.lastAttemptedDeployment = LastDeploymentInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LastDeploymentInfo] inside the given [block]
         */
        fun lastSuccessfulDeployment(block: LastDeploymentInfo.DslBuilder.() -> kotlin.Unit) {
            this.lastSuccessfulDeployment = LastDeploymentInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        fun loadBalancerInfo(block: LoadBalancerInfo.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancerInfo = LoadBalancerInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet] inside the given [block]
         */
        fun onPremisesTagSet(block: OnPremisesTagSet.DslBuilder.() -> kotlin.Unit) {
            this.onPremisesTagSet = OnPremisesTagSet.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        fun targetRevision(block: RevisionLocation.DslBuilder.() -> kotlin.Unit) {
            this.targetRevision = RevisionLocation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarmConfiguration: AlarmConfiguration? = null
        override var applicationName: String? = null
        override var autoRollbackConfiguration: AutoRollbackConfiguration? = null
        override var autoScalingGroups: List<AutoScalingGroup>? = null
        override var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = null
        override var computePlatform: ComputePlatform? = null
        override var deploymentConfigName: String? = null
        override var deploymentGroupId: String? = null
        override var deploymentGroupName: String? = null
        override var deploymentStyle: DeploymentStyle? = null
        override var ec2TagFilters: List<Ec2TagFilter>? = null
        override var ec2TagSet: Ec2TagSet? = null
        override var ecsServices: List<EcsService>? = null
        override var lastAttemptedDeployment: LastDeploymentInfo? = null
        override var lastSuccessfulDeployment: LastDeploymentInfo? = null
        override var loadBalancerInfo: LoadBalancerInfo? = null
        override var onPremisesInstanceTagFilters: List<TagFilter>? = null
        override var onPremisesTagSet: OnPremisesTagSet? = null
        override var outdatedInstancesStrategy: OutdatedInstancesStrategy? = null
        override var serviceRoleArn: String? = null
        override var targetRevision: RevisionLocation? = null
        override var triggerConfigurations: List<TriggerConfig>? = null

        constructor(x: DeploymentGroupInfo) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.autoScalingGroups = x.autoScalingGroups
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.computePlatform = x.computePlatform
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupId = x.deploymentGroupId
            this.deploymentGroupName = x.deploymentGroupName
            this.deploymentStyle = x.deploymentStyle
            this.ec2TagFilters = x.ec2TagFilters
            this.ec2TagSet = x.ec2TagSet
            this.ecsServices = x.ecsServices
            this.lastAttemptedDeployment = x.lastAttemptedDeployment
            this.lastSuccessfulDeployment = x.lastSuccessfulDeployment
            this.loadBalancerInfo = x.loadBalancerInfo
            this.onPremisesInstanceTagFilters = x.onPremisesInstanceTagFilters
            this.onPremisesTagSet = x.onPremisesTagSet
            this.outdatedInstancesStrategy = x.outdatedInstancesStrategy
            this.serviceRoleArn = x.serviceRoleArn
            this.targetRevision = x.targetRevision
            this.triggerConfigurations = x.triggerConfigurations
        }

        override fun build(): DeploymentGroupInfo = DeploymentGroupInfo(this)
        override fun alarmConfiguration(alarmConfiguration: AlarmConfiguration): FluentBuilder = apply { this.alarmConfiguration = alarmConfiguration }
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder = apply { this.autoRollbackConfiguration = autoRollbackConfiguration }
        override fun autoScalingGroups(autoScalingGroups: List<AutoScalingGroup>): FluentBuilder = apply { this.autoScalingGroups = autoScalingGroups }
        override fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder = apply { this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration }
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun deploymentGroupId(deploymentGroupId: String): FluentBuilder = apply { this.deploymentGroupId = deploymentGroupId }
        override fun deploymentGroupName(deploymentGroupName: String): FluentBuilder = apply { this.deploymentGroupName = deploymentGroupName }
        override fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder = apply { this.deploymentStyle = deploymentStyle }
        override fun ec2TagFilters(ec2TagFilters: List<Ec2TagFilter>): FluentBuilder = apply { this.ec2TagFilters = ec2TagFilters }
        override fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder = apply { this.ec2TagSet = ec2TagSet }
        override fun ecsServices(ecsServices: List<EcsService>): FluentBuilder = apply { this.ecsServices = ecsServices }
        override fun lastAttemptedDeployment(lastAttemptedDeployment: LastDeploymentInfo): FluentBuilder = apply { this.lastAttemptedDeployment = lastAttemptedDeployment }
        override fun lastSuccessfulDeployment(lastSuccessfulDeployment: LastDeploymentInfo): FluentBuilder = apply { this.lastSuccessfulDeployment = lastSuccessfulDeployment }
        override fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder = apply { this.loadBalancerInfo = loadBalancerInfo }
        override fun onPremisesInstanceTagFilters(onPremisesInstanceTagFilters: List<TagFilter>): FluentBuilder = apply { this.onPremisesInstanceTagFilters = onPremisesInstanceTagFilters }
        override fun onPremisesTagSet(onPremisesTagSet: OnPremisesTagSet): FluentBuilder = apply { this.onPremisesTagSet = onPremisesTagSet }
        override fun outdatedInstancesStrategy(outdatedInstancesStrategy: OutdatedInstancesStrategy): FluentBuilder = apply { this.outdatedInstancesStrategy = outdatedInstancesStrategy }
        override fun serviceRoleArn(serviceRoleArn: String): FluentBuilder = apply { this.serviceRoleArn = serviceRoleArn }
        override fun targetRevision(targetRevision: RevisionLocation): FluentBuilder = apply { this.targetRevision = targetRevision }
        override fun triggerConfigurations(triggerConfigurations: List<TriggerConfig>): FluentBuilder = apply { this.triggerConfigurations = triggerConfigurations }
    }
}
