// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a deployment.
 */
class DeploymentInfo private constructor(builder: BuilderImpl) {
    /**
     * Provides information about the results of a deployment, such as whether instances in
     * the original environment in a blue/green deployment were not terminated.
     */
    val additionalDeploymentStatusInfo: String? = builder.additionalDeploymentStatusInfo
    /**
     * The application name.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Information about the automatic rollback configuration associated with the
     * deployment.
     */
    val autoRollbackConfiguration: AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * Information about blue/green deployment options for this deployment.
     */
    val blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * A timestamp that indicates when the deployment was complete.
     */
    val completeTime: Instant? = builder.completeTime
    /**
     * The destination platform type for the deployment (Lambda,
     * Server, or ECS).
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * A timestamp that indicates when the deployment was created.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The means by which the deployment was created:
     * user: A user created the deployment.
     * autoscaling: Amazon EC2 Auto Scaling created the
     * deployment.
     * codeDeployRollback: A rollback process created the
     * deployment.
     * CodeDeployAutoUpdate: An auto-update process created the
     * deployment when it detected outdated EC2 instances.
     */
    val creator: DeploymentCreator? = builder.creator
    /**
     * The deployment configuration name.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * The deployment group name.
     */
    val deploymentGroupName: String? = builder.deploymentGroupName
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A summary of the deployment status of the instances in the deployment.
     */
    val deploymentOverview: DeploymentOverview? = builder.deploymentOverview
    /**
     * Messages that contain information about the status of a deployment.
     */
    val deploymentStatusMessages: List<String>? = builder.deploymentStatusMessages
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to
     * run and whether to route deployment traffic behind a load balancer.
     */
    val deploymentStyle: DeploymentStyle? = builder.deploymentStyle
    /**
     * A comment about the deployment.
     */
    val description: String? = builder.description
    /**
     * Information about any error associated with this deployment.
     */
    val errorInformation: ErrorInformation? = builder.errorInformation
    /**
     * The unique ID for an external resource (for example, a CloudFormation stack ID) that
     * is linked to this deployment.
     */
    val externalId: String? = builder.externalId
    /**
     * Information about how AWS CodeDeploy handles files that already exist in a deployment
     * target location but weren't part of the previous successful deployment.
     * DISALLOW: The deployment fails. This is also the default behavior
     * if no option is specified.
     * OVERWRITE: The version of the file from the application revision
     * currently being deployed replaces the version already on the instance.
     * RETAIN: The version of the file already on the instance is kept
     * and used as part of the new deployment.
     */
    val fileExistsBehavior: FileExistsBehavior? = builder.fileExistsBehavior
    /**
     * If true, then if an ApplicationStop, BeforeBlockTraffic, or
     * AfterBlockTraffic deployment lifecycle event to an instance fails, then
     * the deployment continues to the next deployment lifecycle event. For example, if
     * ApplicationStop fails, the deployment continues with DownloadBundle. If
     * BeforeBlockTraffic fails, the deployment continues with
     * BlockTraffic. If AfterBlockTraffic fails, the deployment
     * continues with ApplicationStop.
     * If false or not specified, then if a lifecycle event fails during a deployment to an
     * instance, that deployment fails. If deployment to that instance is part of an overall
     * deployment and the number of healthy hosts is not less than the minimum number of
     * healthy hosts, then a deployment to the next instance is attempted.
     * During a deployment, the AWS CodeDeploy agent runs the scripts specified for
     * ApplicationStop, BeforeBlockTraffic, and
     * AfterBlockTraffic in the AppSpec file from the previous successful
     * deployment. (All other scripts are run from the AppSpec file in the current deployment.)
     * If one of these scripts contains an error and does not run successfully, the deployment
     * can fail.
     * If the cause of the failure is a script from the last successful deployment that will
     * never run successfully, create a new deployment and use
     * ignoreApplicationStopFailures to specify that the
     * ApplicationStop, BeforeBlockTraffic, and
     * AfterBlockTraffic failures should be ignored.
     */
    val ignoreApplicationStopFailures: Boolean = builder.ignoreApplicationStopFailures
    /**
     * Indicates whether the wait period set for the termination of instances in the original
     * environment has started. Status is 'false' if the KEEP_ALIVE option is specified.
     * Otherwise, 'true' as soon as the termination wait period starts.
     */
    val instanceTerminationWaitTimeStarted: Boolean = builder.instanceTerminationWaitTimeStarted
    /**
     * Information about the load balancer used in the deployment.
     */
    val loadBalancerInfo: LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * Information about the application revision that was deployed to the deployment group
     * before the most recent successful deployment.
     */
    val previousRevision: RevisionLocation? = builder.previousRevision
    /**
     * Information about deployments related to the specified deployment.
     */
    val relatedDeployments: RelatedDeployments? = builder.relatedDeployments
    /**
     * Information about the location of stored application artifacts and the service from
     * which to retrieve them.
     */
    val revision: RevisionLocation? = builder.revision
    /**
     * Information about a deployment rollback.
     */
    val rollbackInfo: RollbackInfo? = builder.rollbackInfo
    /**
     * A timestamp that indicates when the deployment was deployed to the deployment
     * group.
     * In some cases, the reported value of the start time might be later than the complete
     * time. This is due to differences in the clock settings of backend servers that
     * participate in the deployment process.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The current state of the deployment as a whole.
     */
    val status: DeploymentStatus? = builder.status
    /**
     * Information about the instances that belong to the replacement environment in a
     * blue/green deployment.
     */
    val targetInstances: TargetInstances? = builder.targetInstances
    /**
     * Indicates whether only instances that are not running the latest application revision
     * are to be deployed to.
     */
    val updateOutdatedInstancesOnly: Boolean = builder.updateOutdatedInstancesOnly

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentInfo(")
        append("additionalDeploymentStatusInfo=$additionalDeploymentStatusInfo,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("completeTime=$completeTime,")
        append("computePlatform=$computePlatform,")
        append("createTime=$createTime,")
        append("creator=$creator,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("deploymentId=$deploymentId,")
        append("deploymentOverview=$deploymentOverview,")
        append("deploymentStatusMessages=$deploymentStatusMessages,")
        append("deploymentStyle=$deploymentStyle,")
        append("description=$description,")
        append("errorInformation=$errorInformation,")
        append("externalId=$externalId,")
        append("fileExistsBehavior=$fileExistsBehavior,")
        append("ignoreApplicationStopFailures=$ignoreApplicationStopFailures,")
        append("instanceTerminationWaitTimeStarted=$instanceTerminationWaitTimeStarted,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("previousRevision=$previousRevision,")
        append("relatedDeployments=$relatedDeployments,")
        append("revision=$revision,")
        append("rollbackInfo=$rollbackInfo,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("targetInstances=$targetInstances,")
        append("updateOutdatedInstancesOnly=$updateOutdatedInstancesOnly)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalDeploymentStatusInfo?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (completeTime?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (creator?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentOverview?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatusMessages?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorInformation?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (fileExistsBehavior?.hashCode() ?: 0)
        result = 31 * result + (ignoreApplicationStopFailures.hashCode())
        result = 31 * result + (instanceTerminationWaitTimeStarted.hashCode())
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (previousRevision?.hashCode() ?: 0)
        result = 31 * result + (relatedDeployments?.hashCode() ?: 0)
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (rollbackInfo?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetInstances?.hashCode() ?: 0)
        result = 31 * result + (updateOutdatedInstancesOnly.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentInfo

        if (additionalDeploymentStatusInfo != other.additionalDeploymentStatusInfo) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (completeTime != other.completeTime) return false
        if (computePlatform != other.computePlatform) return false
        if (createTime != other.createTime) return false
        if (creator != other.creator) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentOverview != other.deploymentOverview) return false
        if (deploymentStatusMessages != other.deploymentStatusMessages) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (description != other.description) return false
        if (errorInformation != other.errorInformation) return false
        if (externalId != other.externalId) return false
        if (fileExistsBehavior != other.fileExistsBehavior) return false
        if (ignoreApplicationStopFailures != other.ignoreApplicationStopFailures) return false
        if (instanceTerminationWaitTimeStarted != other.instanceTerminationWaitTimeStarted) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (previousRevision != other.previousRevision) return false
        if (relatedDeployments != other.relatedDeployments) return false
        if (revision != other.revision) return false
        if (rollbackInfo != other.rollbackInfo) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (targetInstances != other.targetInstances) return false
        if (updateOutdatedInstancesOnly != other.updateOutdatedInstancesOnly) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentInfo
        /**
         * Provides information about the results of a deployment, such as whether instances in
         * the original environment in a blue/green deployment were not terminated.
         */
        fun additionalDeploymentStatusInfo(additionalDeploymentStatusInfo: String): FluentBuilder
        /**
         * The application name.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Information about the automatic rollback configuration associated with the
         * deployment.
         */
        fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder
        /**
         * Information about blue/green deployment options for this deployment.
         */
        fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder
        /**
         * A timestamp that indicates when the deployment was complete.
         */
        fun completeTime(completeTime: Instant): FluentBuilder
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * A timestamp that indicates when the deployment was created.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The means by which the deployment was created:
         * user: A user created the deployment.
         * autoscaling: Amazon EC2 Auto Scaling created the
         * deployment.
         * codeDeployRollback: A rollback process created the
         * deployment.
         * CodeDeployAutoUpdate: An auto-update process created the
         * deployment when it detected outdated EC2 instances.
         */
        fun creator(creator: DeploymentCreator): FluentBuilder
        /**
         * The deployment configuration name.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * The deployment group name.
         */
        fun deploymentGroupName(deploymentGroupName: String): FluentBuilder
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A summary of the deployment status of the instances in the deployment.
         */
        fun deploymentOverview(deploymentOverview: DeploymentOverview): FluentBuilder
        /**
         * Messages that contain information about the status of a deployment.
         */
        fun deploymentStatusMessages(deploymentStatusMessages: List<String>): FluentBuilder
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder
        /**
         * A comment about the deployment.
         */
        fun description(description: String): FluentBuilder
        /**
         * Information about any error associated with this deployment.
         */
        fun errorInformation(errorInformation: ErrorInformation): FluentBuilder
        /**
         * The unique ID for an external resource (for example, a CloudFormation stack ID) that
         * is linked to this deployment.
         */
        fun externalId(externalId: String): FluentBuilder
        /**
         * Information about how AWS CodeDeploy handles files that already exist in a deployment
         * target location but weren't part of the previous successful deployment.
         * DISALLOW: The deployment fails. This is also the default behavior
         * if no option is specified.
         * OVERWRITE: The version of the file from the application revision
         * currently being deployed replaces the version already on the instance.
         * RETAIN: The version of the file already on the instance is kept
         * and used as part of the new deployment.
         */
        fun fileExistsBehavior(fileExistsBehavior: FileExistsBehavior): FluentBuilder
        /**
         * If true, then if an ApplicationStop, BeforeBlockTraffic, or
         * AfterBlockTraffic deployment lifecycle event to an instance fails, then
         * the deployment continues to the next deployment lifecycle event. For example, if
         * ApplicationStop fails, the deployment continues with DownloadBundle. If
         * BeforeBlockTraffic fails, the deployment continues with
         * BlockTraffic. If AfterBlockTraffic fails, the deployment
         * continues with ApplicationStop.
         * If false or not specified, then if a lifecycle event fails during a deployment to an
         * instance, that deployment fails. If deployment to that instance is part of an overall
         * deployment and the number of healthy hosts is not less than the minimum number of
         * healthy hosts, then a deployment to the next instance is attempted.
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic in the AppSpec file from the previous successful
         * deployment. (All other scripts are run from the AppSpec file in the current deployment.)
         * If one of these scripts contains an error and does not run successfully, the deployment
         * can fail.
         * If the cause of the failure is a script from the last successful deployment that will
         * never run successfully, create a new deployment and use
         * ignoreApplicationStopFailures to specify that the
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic failures should be ignored.
         */
        fun ignoreApplicationStopFailures(ignoreApplicationStopFailures: Boolean): FluentBuilder
        /**
         * Indicates whether the wait period set for the termination of instances in the original
         * environment has started. Status is 'false' if the KEEP_ALIVE option is specified.
         * Otherwise, 'true' as soon as the termination wait period starts.
         */
        fun instanceTerminationWaitTimeStarted(instanceTerminationWaitTimeStarted: Boolean): FluentBuilder
        /**
         * Information about the load balancer used in the deployment.
         */
        fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder
        /**
         * Information about the application revision that was deployed to the deployment group
         * before the most recent successful deployment.
         */
        fun previousRevision(previousRevision: RevisionLocation): FluentBuilder
        /**
         * Information about deployments related to the specified deployment.
         */
        fun relatedDeployments(relatedDeployments: RelatedDeployments): FluentBuilder
        /**
         * Information about the location of stored application artifacts and the service from
         * which to retrieve them.
         */
        fun revision(revision: RevisionLocation): FluentBuilder
        /**
         * Information about a deployment rollback.
         */
        fun rollbackInfo(rollbackInfo: RollbackInfo): FluentBuilder
        /**
         * A timestamp that indicates when the deployment was deployed to the deployment
         * group.
         * In some cases, the reported value of the start time might be later than the complete
         * time. This is due to differences in the clock settings of backend servers that
         * participate in the deployment process.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The current state of the deployment as a whole.
         */
        fun status(status: DeploymentStatus): FluentBuilder
        /**
         * Information about the instances that belong to the replacement environment in a
         * blue/green deployment.
         */
        fun targetInstances(targetInstances: TargetInstances): FluentBuilder
        /**
         * Indicates whether only instances that are not running the latest application revision
         * are to be deployed to.
         */
        fun updateOutdatedInstancesOnly(updateOutdatedInstancesOnly: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Provides information about the results of a deployment, such as whether instances in
         * the original environment in a blue/green deployment were not terminated.
         */
        var additionalDeploymentStatusInfo: String?
        /**
         * The application name.
         */
        var applicationName: String?
        /**
         * Information about the automatic rollback configuration associated with the
         * deployment.
         */
        var autoRollbackConfiguration: AutoRollbackConfiguration?
        /**
         * Information about blue/green deployment options for this deployment.
         */
        var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration?
        /**
         * A timestamp that indicates when the deployment was complete.
         */
        var completeTime: Instant?
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        var computePlatform: ComputePlatform?
        /**
         * A timestamp that indicates when the deployment was created.
         */
        var createTime: Instant?
        /**
         * The means by which the deployment was created:
         * user: A user created the deployment.
         * autoscaling: Amazon EC2 Auto Scaling created the
         * deployment.
         * codeDeployRollback: A rollback process created the
         * deployment.
         * CodeDeployAutoUpdate: An auto-update process created the
         * deployment when it detected outdated EC2 instances.
         */
        var creator: DeploymentCreator?
        /**
         * The deployment configuration name.
         */
        var deploymentConfigName: String?
        /**
         * The deployment group name.
         */
        var deploymentGroupName: String?
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * A summary of the deployment status of the instances in the deployment.
         */
        var deploymentOverview: DeploymentOverview?
        /**
         * Messages that contain information about the status of a deployment.
         */
        var deploymentStatusMessages: List<String>?
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        var deploymentStyle: DeploymentStyle?
        /**
         * A comment about the deployment.
         */
        var description: String?
        /**
         * Information about any error associated with this deployment.
         */
        var errorInformation: ErrorInformation?
        /**
         * The unique ID for an external resource (for example, a CloudFormation stack ID) that
         * is linked to this deployment.
         */
        var externalId: String?
        /**
         * Information about how AWS CodeDeploy handles files that already exist in a deployment
         * target location but weren't part of the previous successful deployment.
         * DISALLOW: The deployment fails. This is also the default behavior
         * if no option is specified.
         * OVERWRITE: The version of the file from the application revision
         * currently being deployed replaces the version already on the instance.
         * RETAIN: The version of the file already on the instance is kept
         * and used as part of the new deployment.
         */
        var fileExistsBehavior: FileExistsBehavior?
        /**
         * If true, then if an ApplicationStop, BeforeBlockTraffic, or
         * AfterBlockTraffic deployment lifecycle event to an instance fails, then
         * the deployment continues to the next deployment lifecycle event. For example, if
         * ApplicationStop fails, the deployment continues with DownloadBundle. If
         * BeforeBlockTraffic fails, the deployment continues with
         * BlockTraffic. If AfterBlockTraffic fails, the deployment
         * continues with ApplicationStop.
         * If false or not specified, then if a lifecycle event fails during a deployment to an
         * instance, that deployment fails. If deployment to that instance is part of an overall
         * deployment and the number of healthy hosts is not less than the minimum number of
         * healthy hosts, then a deployment to the next instance is attempted.
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic in the AppSpec file from the previous successful
         * deployment. (All other scripts are run from the AppSpec file in the current deployment.)
         * If one of these scripts contains an error and does not run successfully, the deployment
         * can fail.
         * If the cause of the failure is a script from the last successful deployment that will
         * never run successfully, create a new deployment and use
         * ignoreApplicationStopFailures to specify that the
         * ApplicationStop, BeforeBlockTraffic, and
         * AfterBlockTraffic failures should be ignored.
         */
        var ignoreApplicationStopFailures: Boolean
        /**
         * Indicates whether the wait period set for the termination of instances in the original
         * environment has started. Status is 'false' if the KEEP_ALIVE option is specified.
         * Otherwise, 'true' as soon as the termination wait period starts.
         */
        var instanceTerminationWaitTimeStarted: Boolean
        /**
         * Information about the load balancer used in the deployment.
         */
        var loadBalancerInfo: LoadBalancerInfo?
        /**
         * Information about the application revision that was deployed to the deployment group
         * before the most recent successful deployment.
         */
        var previousRevision: RevisionLocation?
        /**
         * Information about deployments related to the specified deployment.
         */
        var relatedDeployments: RelatedDeployments?
        /**
         * Information about the location of stored application artifacts and the service from
         * which to retrieve them.
         */
        var revision: RevisionLocation?
        /**
         * Information about a deployment rollback.
         */
        var rollbackInfo: RollbackInfo?
        /**
         * A timestamp that indicates when the deployment was deployed to the deployment
         * group.
         * In some cases, the reported value of the start time might be later than the complete
         * time. This is due to differences in the clock settings of backend servers that
         * participate in the deployment process.
         */
        var startTime: Instant?
        /**
         * The current state of the deployment as a whole.
         */
        var status: DeploymentStatus?
        /**
         * Information about the instances that belong to the replacement environment in a
         * blue/green deployment.
         */
        var targetInstances: TargetInstances?
        /**
         * Indicates whether only instances that are not running the latest application revision
         * are to be deployed to.
         */
        var updateOutdatedInstancesOnly: Boolean

        fun build(): DeploymentInfo
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        fun autoRollbackConfiguration(block: AutoRollbackConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = AutoRollbackConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        fun blueGreenDeploymentConfiguration(block: BlueGreenDeploymentConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = BlueGreenDeploymentConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentOverview] inside the given [block]
         */
        fun deploymentOverview(block: DeploymentOverview.DslBuilder.() -> kotlin.Unit) {
            this.deploymentOverview = DeploymentOverview.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        fun deploymentStyle(block: DeploymentStyle.DslBuilder.() -> kotlin.Unit) {
            this.deploymentStyle = DeploymentStyle.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.ErrorInformation] inside the given [block]
         */
        fun errorInformation(block: ErrorInformation.DslBuilder.() -> kotlin.Unit) {
            this.errorInformation = ErrorInformation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        fun loadBalancerInfo(block: LoadBalancerInfo.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancerInfo = LoadBalancerInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        fun previousRevision(block: RevisionLocation.DslBuilder.() -> kotlin.Unit) {
            this.previousRevision = RevisionLocation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RelatedDeployments] inside the given [block]
         */
        fun relatedDeployments(block: RelatedDeployments.DslBuilder.() -> kotlin.Unit) {
            this.relatedDeployments = RelatedDeployments.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        fun revision(block: RevisionLocation.DslBuilder.() -> kotlin.Unit) {
            this.revision = RevisionLocation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RollbackInfo] inside the given [block]
         */
        fun rollbackInfo(block: RollbackInfo.DslBuilder.() -> kotlin.Unit) {
            this.rollbackInfo = RollbackInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TargetInstances] inside the given [block]
         */
        fun targetInstances(block: TargetInstances.DslBuilder.() -> kotlin.Unit) {
            this.targetInstances = TargetInstances.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalDeploymentStatusInfo: String? = null
        override var applicationName: String? = null
        override var autoRollbackConfiguration: AutoRollbackConfiguration? = null
        override var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = null
        override var completeTime: Instant? = null
        override var computePlatform: ComputePlatform? = null
        override var createTime: Instant? = null
        override var creator: DeploymentCreator? = null
        override var deploymentConfigName: String? = null
        override var deploymentGroupName: String? = null
        override var deploymentId: String? = null
        override var deploymentOverview: DeploymentOverview? = null
        override var deploymentStatusMessages: List<String>? = null
        override var deploymentStyle: DeploymentStyle? = null
        override var description: String? = null
        override var errorInformation: ErrorInformation? = null
        override var externalId: String? = null
        override var fileExistsBehavior: FileExistsBehavior? = null
        override var ignoreApplicationStopFailures: Boolean = false
        override var instanceTerminationWaitTimeStarted: Boolean = false
        override var loadBalancerInfo: LoadBalancerInfo? = null
        override var previousRevision: RevisionLocation? = null
        override var relatedDeployments: RelatedDeployments? = null
        override var revision: RevisionLocation? = null
        override var rollbackInfo: RollbackInfo? = null
        override var startTime: Instant? = null
        override var status: DeploymentStatus? = null
        override var targetInstances: TargetInstances? = null
        override var updateOutdatedInstancesOnly: Boolean = false

        constructor(x: DeploymentInfo) : this() {
            this.additionalDeploymentStatusInfo = x.additionalDeploymentStatusInfo
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.completeTime = x.completeTime
            this.computePlatform = x.computePlatform
            this.createTime = x.createTime
            this.creator = x.creator
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupName = x.deploymentGroupName
            this.deploymentId = x.deploymentId
            this.deploymentOverview = x.deploymentOverview
            this.deploymentStatusMessages = x.deploymentStatusMessages
            this.deploymentStyle = x.deploymentStyle
            this.description = x.description
            this.errorInformation = x.errorInformation
            this.externalId = x.externalId
            this.fileExistsBehavior = x.fileExistsBehavior
            this.ignoreApplicationStopFailures = x.ignoreApplicationStopFailures
            this.instanceTerminationWaitTimeStarted = x.instanceTerminationWaitTimeStarted
            this.loadBalancerInfo = x.loadBalancerInfo
            this.previousRevision = x.previousRevision
            this.relatedDeployments = x.relatedDeployments
            this.revision = x.revision
            this.rollbackInfo = x.rollbackInfo
            this.startTime = x.startTime
            this.status = x.status
            this.targetInstances = x.targetInstances
            this.updateOutdatedInstancesOnly = x.updateOutdatedInstancesOnly
        }

        override fun build(): DeploymentInfo = DeploymentInfo(this)
        override fun additionalDeploymentStatusInfo(additionalDeploymentStatusInfo: String): FluentBuilder = apply { this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo }
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder = apply { this.autoRollbackConfiguration = autoRollbackConfiguration }
        override fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder = apply { this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration }
        override fun completeTime(completeTime: Instant): FluentBuilder = apply { this.completeTime = completeTime }
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun creator(creator: DeploymentCreator): FluentBuilder = apply { this.creator = creator }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun deploymentGroupName(deploymentGroupName: String): FluentBuilder = apply { this.deploymentGroupName = deploymentGroupName }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun deploymentOverview(deploymentOverview: DeploymentOverview): FluentBuilder = apply { this.deploymentOverview = deploymentOverview }
        override fun deploymentStatusMessages(deploymentStatusMessages: List<String>): FluentBuilder = apply { this.deploymentStatusMessages = deploymentStatusMessages }
        override fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder = apply { this.deploymentStyle = deploymentStyle }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun errorInformation(errorInformation: ErrorInformation): FluentBuilder = apply { this.errorInformation = errorInformation }
        override fun externalId(externalId: String): FluentBuilder = apply { this.externalId = externalId }
        override fun fileExistsBehavior(fileExistsBehavior: FileExistsBehavior): FluentBuilder = apply { this.fileExistsBehavior = fileExistsBehavior }
        override fun ignoreApplicationStopFailures(ignoreApplicationStopFailures: Boolean): FluentBuilder = apply { this.ignoreApplicationStopFailures = ignoreApplicationStopFailures }
        override fun instanceTerminationWaitTimeStarted(instanceTerminationWaitTimeStarted: Boolean): FluentBuilder = apply { this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted }
        override fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder = apply { this.loadBalancerInfo = loadBalancerInfo }
        override fun previousRevision(previousRevision: RevisionLocation): FluentBuilder = apply { this.previousRevision = previousRevision }
        override fun relatedDeployments(relatedDeployments: RelatedDeployments): FluentBuilder = apply { this.relatedDeployments = relatedDeployments }
        override fun revision(revision: RevisionLocation): FluentBuilder = apply { this.revision = revision }
        override fun rollbackInfo(rollbackInfo: RollbackInfo): FluentBuilder = apply { this.rollbackInfo = rollbackInfo }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun status(status: DeploymentStatus): FluentBuilder = apply { this.status = status }
        override fun targetInstances(targetInstances: TargetInstances): FluentBuilder = apply { this.targetInstances = targetInstances }
        override fun updateOutdatedInstancesOnly(updateOutdatedInstancesOnly: Boolean): FluentBuilder = apply { this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly }
    }
}
