// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the deployment status of the instances in the deployment.
 */
class DeploymentOverview private constructor(builder: BuilderImpl) {
    /**
     * The number of instances in the deployment in a failed state.
     */
    val failed: Long = builder.failed
    /**
     * The number of instances in which the deployment is in progress.
     */
    val inProgress: Long = builder.inProgress
    /**
     * The number of instances in the deployment in a pending state.
     */
    val pending: Long = builder.pending
    /**
     * The number of instances in a replacement environment ready to receive traffic in a
     * blue/green deployment.
     */
    val ready: Long = builder.ready
    /**
     * The number of instances in the deployment in a skipped state.
     */
    val skipped: Long = builder.skipped
    /**
     * The number of instances in the deployment to which revisions have been successfully
     * deployed.
     */
    val succeeded: Long = builder.succeeded

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentOverview = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentOverview(")
        append("failed=$failed,")
        append("inProgress=$inProgress,")
        append("pending=$pending,")
        append("ready=$ready,")
        append("skipped=$skipped,")
        append("succeeded=$succeeded)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failed.hashCode()
        result = 31 * result + (inProgress.hashCode())
        result = 31 * result + (pending.hashCode())
        result = 31 * result + (ready.hashCode())
        result = 31 * result + (skipped.hashCode())
        result = 31 * result + (succeeded.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentOverview

        if (failed != other.failed) return false
        if (inProgress != other.inProgress) return false
        if (pending != other.pending) return false
        if (ready != other.ready) return false
        if (skipped != other.skipped) return false
        if (succeeded != other.succeeded) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentOverview = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentOverview
        /**
         * The number of instances in the deployment in a failed state.
         */
        fun failed(failed: Long): FluentBuilder
        /**
         * The number of instances in which the deployment is in progress.
         */
        fun inProgress(inProgress: Long): FluentBuilder
        /**
         * The number of instances in the deployment in a pending state.
         */
        fun pending(pending: Long): FluentBuilder
        /**
         * The number of instances in a replacement environment ready to receive traffic in a
         * blue/green deployment.
         */
        fun ready(ready: Long): FluentBuilder
        /**
         * The number of instances in the deployment in a skipped state.
         */
        fun skipped(skipped: Long): FluentBuilder
        /**
         * The number of instances in the deployment to which revisions have been successfully
         * deployed.
         */
        fun succeeded(succeeded: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of instances in the deployment in a failed state.
         */
        var failed: Long
        /**
         * The number of instances in which the deployment is in progress.
         */
        var inProgress: Long
        /**
         * The number of instances in the deployment in a pending state.
         */
        var pending: Long
        /**
         * The number of instances in a replacement environment ready to receive traffic in a
         * blue/green deployment.
         */
        var ready: Long
        /**
         * The number of instances in the deployment in a skipped state.
         */
        var skipped: Long
        /**
         * The number of instances in the deployment to which revisions have been successfully
         * deployed.
         */
        var succeeded: Long

        fun build(): DeploymentOverview
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var failed: Long = 0L
        override var inProgress: Long = 0L
        override var pending: Long = 0L
        override var ready: Long = 0L
        override var skipped: Long = 0L
        override var succeeded: Long = 0L

        constructor(x: DeploymentOverview) : this() {
            this.failed = x.failed
            this.inProgress = x.inProgress
            this.pending = x.pending
            this.ready = x.ready
            this.skipped = x.skipped
            this.succeeded = x.succeeded
        }

        override fun build(): DeploymentOverview = DeploymentOverview(this)
        override fun failed(failed: Long): FluentBuilder = apply { this.failed = failed }
        override fun inProgress(inProgress: Long): FluentBuilder = apply { this.inProgress = inProgress }
        override fun pending(pending: Long): FluentBuilder = apply { this.pending = pending }
        override fun ready(ready: Long): FluentBuilder = apply { this.ready = ready }
        override fun skipped(skipped: Long): FluentBuilder = apply { this.skipped = skipped }
        override fun succeeded(succeeded: Long): FluentBuilder = apply { this.succeeded = succeeded }
    }
}
