// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about how traffic is rerouted to instances in a replacement environment in
 * a blue/green deployment.
 */
class DeploymentReadyOption private constructor(builder: BuilderImpl) {
    /**
     * Information about when to reroute traffic from an original environment to a
     * replacement environment in a blue/green deployment.
     * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately
     * after the new application revision is installed on the instances in the
     * replacement environment.
     * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless
     * traffic rerouting is started using ContinueDeployment. If
     * traffic rerouting is not started before the end of the specified wait period,
     * the deployment status is changed to Stopped.
     */
    val actionOnTimeout: DeploymentReadyAction? = builder.actionOnTimeout
    /**
     * The number of minutes to wait before the status of a blue/green deployment is changed
     * to Stopped if rerouting is not started manually. Applies only to the
     * STOP_DEPLOYMENT option for actionOnTimeout.
     */
    val waitTimeInMinutes: Int = builder.waitTimeInMinutes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentReadyOption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentReadyOption(")
        append("actionOnTimeout=$actionOnTimeout,")
        append("waitTimeInMinutes=$waitTimeInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionOnTimeout?.hashCode() ?: 0
        result = 31 * result + (waitTimeInMinutes)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentReadyOption

        if (actionOnTimeout != other.actionOnTimeout) return false
        if (waitTimeInMinutes != other.waitTimeInMinutes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentReadyOption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentReadyOption
        /**
         * Information about when to reroute traffic from an original environment to a
         * replacement environment in a blue/green deployment.
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately
         * after the new application revision is installed on the instances in the
         * replacement environment.
         * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless
         * traffic rerouting is started using ContinueDeployment. If
         * traffic rerouting is not started before the end of the specified wait period,
         * the deployment status is changed to Stopped.
         */
        fun actionOnTimeout(actionOnTimeout: DeploymentReadyAction): FluentBuilder
        /**
         * The number of minutes to wait before the status of a blue/green deployment is changed
         * to Stopped if rerouting is not started manually. Applies only to the
         * STOP_DEPLOYMENT option for actionOnTimeout.
         */
        fun waitTimeInMinutes(waitTimeInMinutes: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about when to reroute traffic from an original environment to a
         * replacement environment in a blue/green deployment.
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately
         * after the new application revision is installed on the instances in the
         * replacement environment.
         * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless
         * traffic rerouting is started using ContinueDeployment. If
         * traffic rerouting is not started before the end of the specified wait period,
         * the deployment status is changed to Stopped.
         */
        var actionOnTimeout: DeploymentReadyAction?
        /**
         * The number of minutes to wait before the status of a blue/green deployment is changed
         * to Stopped if rerouting is not started manually. Applies only to the
         * STOP_DEPLOYMENT option for actionOnTimeout.
         */
        var waitTimeInMinutes: Int

        fun build(): DeploymentReadyOption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionOnTimeout: DeploymentReadyAction? = null
        override var waitTimeInMinutes: Int = 0

        constructor(x: DeploymentReadyOption) : this() {
            this.actionOnTimeout = x.actionOnTimeout
            this.waitTimeInMinutes = x.waitTimeInMinutes
        }

        override fun build(): DeploymentReadyOption = DeploymentReadyOption(this)
        override fun actionOnTimeout(actionOnTimeout: DeploymentReadyAction): FluentBuilder = apply { this.actionOnTimeout = actionOnTimeout }
        override fun waitTimeInMinutes(waitTimeInMinutes: Int): FluentBuilder = apply { this.waitTimeInMinutes = waitTimeInMinutes }
    }
}
