// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the deployment target.
 */
class DeploymentTarget private constructor(builder: BuilderImpl) {
    /**
     * Information about the target to be updated by an AWS CloudFormation blue/green
     * deployment. This target type is used for all deployments initiated by a CloudFormation
     * stack update.
     */
    val cloudFormationTarget: CloudFormationTarget? = builder.cloudFormationTarget
    /**
     * The deployment type that is specific to the deployment's compute platform or
     * deployments initiated by a CloudFormation stack update.
     */
    val deploymentTargetType: DeploymentTargetType? = builder.deploymentTargetType
    /**
     * Information about the target for a deployment that uses the Amazon ECS compute
     * platform.
     */
    val ecsTarget: EcsTarget? = builder.ecsTarget
    /**
     * Information about the target for a deployment that uses the EC2/On-premises compute
     * platform.
     */
    val instanceTarget: InstanceTarget? = builder.instanceTarget
    /**
     * Information about the target for a deployment that uses the AWS Lambda compute
     * platform.
     */
    val lambdaTarget: LambdaTarget? = builder.lambdaTarget

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentTarget(")
        append("cloudFormationTarget=$cloudFormationTarget,")
        append("deploymentTargetType=$deploymentTargetType,")
        append("ecsTarget=$ecsTarget,")
        append("instanceTarget=$instanceTarget,")
        append("lambdaTarget=$lambdaTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFormationTarget?.hashCode() ?: 0
        result = 31 * result + (deploymentTargetType?.hashCode() ?: 0)
        result = 31 * result + (ecsTarget?.hashCode() ?: 0)
        result = 31 * result + (instanceTarget?.hashCode() ?: 0)
        result = 31 * result + (lambdaTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentTarget

        if (cloudFormationTarget != other.cloudFormationTarget) return false
        if (deploymentTargetType != other.deploymentTargetType) return false
        if (ecsTarget != other.ecsTarget) return false
        if (instanceTarget != other.instanceTarget) return false
        if (lambdaTarget != other.lambdaTarget) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentTarget
        /**
         * Information about the target to be updated by an AWS CloudFormation blue/green
         * deployment. This target type is used for all deployments initiated by a CloudFormation
         * stack update.
         */
        fun cloudFormationTarget(cloudFormationTarget: CloudFormationTarget): FluentBuilder
        /**
         * The deployment type that is specific to the deployment's compute platform or
         * deployments initiated by a CloudFormation stack update.
         */
        fun deploymentTargetType(deploymentTargetType: DeploymentTargetType): FluentBuilder
        /**
         * Information about the target for a deployment that uses the Amazon ECS compute
         * platform.
         */
        fun ecsTarget(ecsTarget: EcsTarget): FluentBuilder
        /**
         * Information about the target for a deployment that uses the EC2/On-premises compute
         * platform.
         */
        fun instanceTarget(instanceTarget: InstanceTarget): FluentBuilder
        /**
         * Information about the target for a deployment that uses the AWS Lambda compute
         * platform.
         */
        fun lambdaTarget(lambdaTarget: LambdaTarget): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the target to be updated by an AWS CloudFormation blue/green
         * deployment. This target type is used for all deployments initiated by a CloudFormation
         * stack update.
         */
        var cloudFormationTarget: CloudFormationTarget?
        /**
         * The deployment type that is specific to the deployment's compute platform or
         * deployments initiated by a CloudFormation stack update.
         */
        var deploymentTargetType: DeploymentTargetType?
        /**
         * Information about the target for a deployment that uses the Amazon ECS compute
         * platform.
         */
        var ecsTarget: EcsTarget?
        /**
         * Information about the target for a deployment that uses the EC2/On-premises compute
         * platform.
         */
        var instanceTarget: InstanceTarget?
        /**
         * Information about the target for a deployment that uses the AWS Lambda compute
         * platform.
         */
        var lambdaTarget: LambdaTarget?

        fun build(): DeploymentTarget
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget] inside the given [block]
         */
        fun cloudFormationTarget(block: CloudFormationTarget.DslBuilder.() -> kotlin.Unit) {
            this.cloudFormationTarget = CloudFormationTarget.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.EcsTarget] inside the given [block]
         */
        fun ecsTarget(block: EcsTarget.DslBuilder.() -> kotlin.Unit) {
            this.ecsTarget = EcsTarget.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.InstanceTarget] inside the given [block]
         */
        fun instanceTarget(block: InstanceTarget.DslBuilder.() -> kotlin.Unit) {
            this.instanceTarget = InstanceTarget.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LambdaTarget] inside the given [block]
         */
        fun lambdaTarget(block: LambdaTarget.DslBuilder.() -> kotlin.Unit) {
            this.lambdaTarget = LambdaTarget.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudFormationTarget: CloudFormationTarget? = null
        override var deploymentTargetType: DeploymentTargetType? = null
        override var ecsTarget: EcsTarget? = null
        override var instanceTarget: InstanceTarget? = null
        override var lambdaTarget: LambdaTarget? = null

        constructor(x: DeploymentTarget) : this() {
            this.cloudFormationTarget = x.cloudFormationTarget
            this.deploymentTargetType = x.deploymentTargetType
            this.ecsTarget = x.ecsTarget
            this.instanceTarget = x.instanceTarget
            this.lambdaTarget = x.lambdaTarget
        }

        override fun build(): DeploymentTarget = DeploymentTarget(this)
        override fun cloudFormationTarget(cloudFormationTarget: CloudFormationTarget): FluentBuilder = apply { this.cloudFormationTarget = cloudFormationTarget }
        override fun deploymentTargetType(deploymentTargetType: DeploymentTargetType): FluentBuilder = apply { this.deploymentTargetType = deploymentTargetType }
        override fun ecsTarget(ecsTarget: EcsTarget): FluentBuilder = apply { this.ecsTarget = ecsTarget }
        override fun instanceTarget(instanceTarget: InstanceTarget): FluentBuilder = apply { this.instanceTarget = instanceTarget }
        override fun lambdaTarget(lambdaTarget: LambdaTarget): FluentBuilder = apply { this.lambdaTarget = lambdaTarget }
    }
}
