// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Diagnostic information about executable scripts that are part of a deployment.
 */
class Diagnostics private constructor(builder: BuilderImpl) {
    /**
     * The associated error code:
     * Success: The specified script ran.
     * ScriptMissing: The specified script was not found in the specified
     * location.
     * ScriptNotExecutable: The specified script is not a recognized executable file
     * type.
     * ScriptTimedOut: The specified script did not finish running in the specified
     * time period.
     * ScriptFailed: The specified script failed to run as expected.
     * UnknownError: The specified script did not run for an unknown reason.
     */
    val errorCode: LifecycleErrorCode? = builder.errorCode
    /**
     * The last portion of the diagnostic log.
     * If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
     */
    val logTail: String? = builder.logTail
    /**
     * The message associated with the error.
     */
    val message: String? = builder.message
    /**
     * The name of the script.
     */
    val scriptName: String? = builder.scriptName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Diagnostics = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Diagnostics(")
        append("errorCode=$errorCode,")
        append("logTail=$logTail,")
        append("message=$message,")
        append("scriptName=$scriptName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (logTail?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (scriptName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Diagnostics

        if (errorCode != other.errorCode) return false
        if (logTail != other.logTail) return false
        if (message != other.message) return false
        if (scriptName != other.scriptName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Diagnostics = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Diagnostics
        /**
         * The associated error code:
         * Success: The specified script ran.
         * ScriptMissing: The specified script was not found in the specified
         * location.
         * ScriptNotExecutable: The specified script is not a recognized executable file
         * type.
         * ScriptTimedOut: The specified script did not finish running in the specified
         * time period.
         * ScriptFailed: The specified script failed to run as expected.
         * UnknownError: The specified script did not run for an unknown reason.
         */
        fun errorCode(errorCode: LifecycleErrorCode): FluentBuilder
        /**
         * The last portion of the diagnostic log.
         * If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
         */
        fun logTail(logTail: String): FluentBuilder
        /**
         * The message associated with the error.
         */
        fun message(message: String): FluentBuilder
        /**
         * The name of the script.
         */
        fun scriptName(scriptName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The associated error code:
         * Success: The specified script ran.
         * ScriptMissing: The specified script was not found in the specified
         * location.
         * ScriptNotExecutable: The specified script is not a recognized executable file
         * type.
         * ScriptTimedOut: The specified script did not finish running in the specified
         * time period.
         * ScriptFailed: The specified script failed to run as expected.
         * UnknownError: The specified script did not run for an unknown reason.
         */
        var errorCode: LifecycleErrorCode?
        /**
         * The last portion of the diagnostic log.
         * If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
         */
        var logTail: String?
        /**
         * The message associated with the error.
         */
        var message: String?
        /**
         * The name of the script.
         */
        var scriptName: String?

        fun build(): Diagnostics
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var errorCode: LifecycleErrorCode? = null
        override var logTail: String? = null
        override var message: String? = null
        override var scriptName: String? = null

        constructor(x: Diagnostics) : this() {
            this.errorCode = x.errorCode
            this.logTail = x.logTail
            this.message = x.message
            this.scriptName = x.scriptName
        }

        override fun build(): Diagnostics = Diagnostics(this)
        override fun errorCode(errorCode: LifecycleErrorCode): FluentBuilder = apply { this.errorCode = errorCode }
        override fun logTail(logTail: String): FluentBuilder = apply { this.logTail = logTail }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun scriptName(scriptName: String): FluentBuilder = apply { this.scriptName = scriptName }
    }
}
