// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Contains the service and cluster names used to identify an Amazon ECS deployment's
 * target.
 */
class EcsService private constructor(builder: BuilderImpl) {
    /**
     * The name of the cluster that the Amazon ECS service is associated with.
     */
    val clusterName: String? = builder.clusterName
    /**
     * The name of the target Amazon ECS service.
     */
    val serviceName: String? = builder.serviceName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EcsService = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EcsService(")
        append("clusterName=$clusterName,")
        append("serviceName=$serviceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EcsService

        if (clusterName != other.clusterName) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EcsService = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EcsService
        /**
         * The name of the cluster that the Amazon ECS service is associated with.
         */
        fun clusterName(clusterName: String): FluentBuilder
        /**
         * The name of the target Amazon ECS service.
         */
        fun serviceName(serviceName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the cluster that the Amazon ECS service is associated with.
         */
        var clusterName: String?
        /**
         * The name of the target Amazon ECS service.
         */
        var serviceName: String?

        fun build(): EcsService
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterName: String? = null
        override var serviceName: String? = null

        constructor(x: EcsService) : this() {
            this.clusterName = x.clusterName
            this.serviceName = x.serviceName
        }

        override fun build(): EcsService = EcsService(this)
        override fun clusterName(clusterName: String): FluentBuilder = apply { this.clusterName = clusterName }
        override fun serviceName(serviceName: String): FluentBuilder = apply { this.serviceName = serviceName }
    }
}
