// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target of an Amazon ECS deployment.
 */
class EcsTarget private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The date and time when the target Amazon ECS application was updated by a deployment.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the deployment to this target Amazon ECS application.
     */
    val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The status an Amazon ECS deployment's target ECS application.
     */
    val status: TargetStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    val targetArn: String? = builder.targetArn
    /**
     * The unique ID of a deployment target that has a type of ecsTarget.
     */
    val targetId: String? = builder.targetId
    /**
     * The ECSTaskSet objects associated with the ECS target.
     */
    val taskSetsInfo: List<EcsTaskSet>? = builder.taskSetsInfo

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EcsTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EcsTarget(")
        append("deploymentId=$deploymentId,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("targetId=$targetId,")
        append("taskSetsInfo=$taskSetsInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (taskSetsInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EcsTarget

        if (deploymentId != other.deploymentId) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (targetId != other.targetId) return false
        if (taskSetsInfo != other.taskSetsInfo) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EcsTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EcsTarget
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The date and time when the target Amazon ECS application was updated by a deployment.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The lifecycle events of the deployment to this target Amazon ECS application.
         */
        fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder
        /**
         * The status an Amazon ECS deployment's target ECS application.
         */
        fun status(status: TargetStatus): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        fun targetArn(targetArn: String): FluentBuilder
        /**
         * The unique ID of a deployment target that has a type of ecsTarget.
         */
        fun targetId(targetId: String): FluentBuilder
        /**
         * The ECSTaskSet objects associated with the ECS target.
         */
        fun taskSetsInfo(taskSetsInfo: List<EcsTaskSet>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * The date and time when the target Amazon ECS application was updated by a deployment.
         */
        var lastUpdatedAt: Instant?
        /**
         * The lifecycle events of the deployment to this target Amazon ECS application.
         */
        var lifecycleEvents: List<LifecycleEvent>?
        /**
         * The status an Amazon ECS deployment's target ECS application.
         */
        var status: TargetStatus?
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        var targetArn: String?
        /**
         * The unique ID of a deployment target that has a type of ecsTarget.
         */
        var targetId: String?
        /**
         * The ECSTaskSet objects associated with the ECS target.
         */
        var taskSetsInfo: List<EcsTaskSet>?

        fun build(): EcsTarget
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var lastUpdatedAt: Instant? = null
        override var lifecycleEvents: List<LifecycleEvent>? = null
        override var status: TargetStatus? = null
        override var targetArn: String? = null
        override var targetId: String? = null
        override var taskSetsInfo: List<EcsTaskSet>? = null

        constructor(x: EcsTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.status = x.status
            this.targetArn = x.targetArn
            this.targetId = x.targetId
            this.taskSetsInfo = x.taskSetsInfo
        }

        override fun build(): EcsTarget = EcsTarget(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder = apply { this.lifecycleEvents = lifecycleEvents }
        override fun status(status: TargetStatus): FluentBuilder = apply { this.status = status }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
        override fun targetId(targetId: String): FluentBuilder = apply { this.targetId = targetId }
        override fun taskSetsInfo(taskSetsInfo: List<EcsTaskSet>): FluentBuilder = apply { this.taskSetsInfo = taskSetsInfo }
    }
}
