// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a set of Amazon ECS tasks in an AWS CodeDeploy deployment. An
 * Amazon ECS task set includes details such as the desired number of tasks, how many tasks
 * are running, and whether the task set serves production traffic. An AWS CodeDeploy
 * application that uses the Amazon ECS compute platform deploys a containerized
 * application in an Amazon ECS service as a task set.
 */
class EcsTaskSet private constructor(builder: BuilderImpl) {
    /**
     * The number of tasks in a task set. During a deployment that uses the Amazon ECS
     * compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this
     * value to determine how many tasks to create. After the updated task set is created,
     * CodeDeploy shifts traffic to the new task set.
     */
    val desiredCount: Long = builder.desiredCount
    /**
     * A unique ID of an ECSTaskSet.
     */
    val identifer: String? = builder.identifer
    /**
     * The number of tasks in the task set that are in the PENDING status
     * during an Amazon ECS deployment. A task in the PENDING state is preparing
     * to enter the RUNNING state. A task set enters the PENDING
     * status when it launches for the first time, or when it is restarted after being in the
     * STOPPED state.
     */
    val pendingCount: Long = builder.pendingCount
    /**
     * The number of tasks in the task set that are in the RUNNING status
     * during an Amazon ECS deployment. A task in the RUNNING state is running and
     * ready for use.
     */
    val runningCount: Long = builder.runningCount
    /**
     * The status of the task set. There are three valid task set statuses:
     * PRIMARY: Indicates the task set is serving production traffic.
     * ACTIVE: Indicates the task set is not serving production traffic.
     * DRAINING: Indicates the tasks in the task set are being stopped and
     * their corresponding targets are being deregistered from their target group.
     */
    val status: String? = builder.status
    /**
     * The target group associated with the task set. The target group is used by AWS
     * CodeDeploy to manage traffic to a task set.
     */
    val targetGroup: TargetGroupInfo? = builder.targetGroup
    /**
     * A label that identifies whether the ECS task set is an original target
     * (BLUE) or a replacement target (GREEN).
     */
    val taskSetLabel: TargetLabel? = builder.taskSetLabel
    /**
     * The percentage of traffic served by this task set.
     */
    val trafficWeight: Double = builder.trafficWeight

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EcsTaskSet = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EcsTaskSet(")
        append("desiredCount=$desiredCount,")
        append("identifer=$identifer,")
        append("pendingCount=$pendingCount,")
        append("runningCount=$runningCount,")
        append("status=$status,")
        append("targetGroup=$targetGroup,")
        append("taskSetLabel=$taskSetLabel,")
        append("trafficWeight=$trafficWeight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredCount.hashCode()
        result = 31 * result + (identifer?.hashCode() ?: 0)
        result = 31 * result + (pendingCount.hashCode())
        result = 31 * result + (runningCount.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetGroup?.hashCode() ?: 0)
        result = 31 * result + (taskSetLabel?.hashCode() ?: 0)
        result = 31 * result + (trafficWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EcsTaskSet

        if (desiredCount != other.desiredCount) return false
        if (identifer != other.identifer) return false
        if (pendingCount != other.pendingCount) return false
        if (runningCount != other.runningCount) return false
        if (status != other.status) return false
        if (targetGroup != other.targetGroup) return false
        if (taskSetLabel != other.taskSetLabel) return false
        if (trafficWeight != other.trafficWeight) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EcsTaskSet = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EcsTaskSet
        /**
         * The number of tasks in a task set. During a deployment that uses the Amazon ECS
         * compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this
         * value to determine how many tasks to create. After the updated task set is created,
         * CodeDeploy shifts traffic to the new task set.
         */
        fun desiredCount(desiredCount: Long): FluentBuilder
        /**
         * A unique ID of an ECSTaskSet.
         */
        fun identifer(identifer: String): FluentBuilder
        /**
         * The number of tasks in the task set that are in the PENDING status
         * during an Amazon ECS deployment. A task in the PENDING state is preparing
         * to enter the RUNNING state. A task set enters the PENDING
         * status when it launches for the first time, or when it is restarted after being in the
         * STOPPED state.
         */
        fun pendingCount(pendingCount: Long): FluentBuilder
        /**
         * The number of tasks in the task set that are in the RUNNING status
         * during an Amazon ECS deployment. A task in the RUNNING state is running and
         * ready for use.
         */
        fun runningCount(runningCount: Long): FluentBuilder
        /**
         * The status of the task set. There are three valid task set statuses:
         * PRIMARY: Indicates the task set is serving production traffic.
         * ACTIVE: Indicates the task set is not serving production traffic.
         * DRAINING: Indicates the tasks in the task set are being stopped and
         * their corresponding targets are being deregistered from their target group.
         */
        fun status(status: String): FluentBuilder
        /**
         * The target group associated with the task set. The target group is used by AWS
         * CodeDeploy to manage traffic to a task set.
         */
        fun targetGroup(targetGroup: TargetGroupInfo): FluentBuilder
        /**
         * A label that identifies whether the ECS task set is an original target
         * (BLUE) or a replacement target (GREEN).
         */
        fun taskSetLabel(taskSetLabel: TargetLabel): FluentBuilder
        /**
         * The percentage of traffic served by this task set.
         */
        fun trafficWeight(trafficWeight: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of tasks in a task set. During a deployment that uses the Amazon ECS
         * compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this
         * value to determine how many tasks to create. After the updated task set is created,
         * CodeDeploy shifts traffic to the new task set.
         */
        var desiredCount: Long
        /**
         * A unique ID of an ECSTaskSet.
         */
        var identifer: String?
        /**
         * The number of tasks in the task set that are in the PENDING status
         * during an Amazon ECS deployment. A task in the PENDING state is preparing
         * to enter the RUNNING state. A task set enters the PENDING
         * status when it launches for the first time, or when it is restarted after being in the
         * STOPPED state.
         */
        var pendingCount: Long
        /**
         * The number of tasks in the task set that are in the RUNNING status
         * during an Amazon ECS deployment. A task in the RUNNING state is running and
         * ready for use.
         */
        var runningCount: Long
        /**
         * The status of the task set. There are three valid task set statuses:
         * PRIMARY: Indicates the task set is serving production traffic.
         * ACTIVE: Indicates the task set is not serving production traffic.
         * DRAINING: Indicates the tasks in the task set are being stopped and
         * their corresponding targets are being deregistered from their target group.
         */
        var status: String?
        /**
         * The target group associated with the task set. The target group is used by AWS
         * CodeDeploy to manage traffic to a task set.
         */
        var targetGroup: TargetGroupInfo?
        /**
         * A label that identifies whether the ECS task set is an original target
         * (BLUE) or a replacement target (GREEN).
         */
        var taskSetLabel: TargetLabel?
        /**
         * The percentage of traffic served by this task set.
         */
        var trafficWeight: Double

        fun build(): EcsTaskSet
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TargetGroupInfo] inside the given [block]
         */
        fun targetGroup(block: TargetGroupInfo.DslBuilder.() -> kotlin.Unit) {
            this.targetGroup = TargetGroupInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var desiredCount: Long = 0L
        override var identifer: String? = null
        override var pendingCount: Long = 0L
        override var runningCount: Long = 0L
        override var status: String? = null
        override var targetGroup: TargetGroupInfo? = null
        override var taskSetLabel: TargetLabel? = null
        override var trafficWeight: Double = 0.0

        constructor(x: EcsTaskSet) : this() {
            this.desiredCount = x.desiredCount
            this.identifer = x.identifer
            this.pendingCount = x.pendingCount
            this.runningCount = x.runningCount
            this.status = x.status
            this.targetGroup = x.targetGroup
            this.taskSetLabel = x.taskSetLabel
            this.trafficWeight = x.trafficWeight
        }

        override fun build(): EcsTaskSet = EcsTaskSet(this)
        override fun desiredCount(desiredCount: Long): FluentBuilder = apply { this.desiredCount = desiredCount }
        override fun identifer(identifer: String): FluentBuilder = apply { this.identifer = identifer }
        override fun pendingCount(pendingCount: Long): FluentBuilder = apply { this.pendingCount = pendingCount }
        override fun runningCount(runningCount: Long): FluentBuilder = apply { this.runningCount = runningCount }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun targetGroup(targetGroup: TargetGroupInfo): FluentBuilder = apply { this.targetGroup = targetGroup }
        override fun taskSetLabel(taskSetLabel: TargetLabel): FluentBuilder = apply { this.taskSetLabel = taskSetLabel }
        override fun trafficWeight(trafficWeight: Double): FluentBuilder = apply { this.trafficWeight = trafficWeight }
    }
}
