// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a load balancer in Elastic Load Balancing to use in a deployment.
 * Instances are registered directly with a load balancer, and traffic is routed to the
 * load balancer.
 */
class ElbInfo private constructor(builder: BuilderImpl) {
    /**
     * For blue/green deployments, the name of the load balancer that is used to route
     * traffic from original instances to replacement instances in a blue/green deployment. For
     * in-place deployments, the name of the load balancer that instances are deregistered from
     * so they are not serving traffic during a deployment, and then re-registered with after
     * the deployment is complete.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ElbInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ElbInfo(")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ElbInfo

        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ElbInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ElbInfo
        /**
         * For blue/green deployments, the name of the load balancer that is used to route
         * traffic from original instances to replacement instances in a blue/green deployment. For
         * in-place deployments, the name of the load balancer that instances are deregistered from
         * so they are not serving traffic during a deployment, and then re-registered with after
         * the deployment is complete.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * For blue/green deployments, the name of the load balancer that is used to route
         * traffic from original instances to replacement instances in a blue/green deployment. For
         * in-place deployments, the name of the load balancer that instances are deregistered from
         * so they are not serving traffic during a deployment, and then re-registered with after
         * the deployment is complete.
         */
        var name: String?

        fun build(): ElbInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null

        constructor(x: ElbInfo) : this() {
            this.name = x.name
        }

        override fun build(): ElbInfo = ElbInfo(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
