// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the location of application artifacts stored in GitHub.
 */
class GitHubLocation private constructor(builder: BuilderImpl) {
    /**
     * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the
     * application revision.
     */
    val commitId: String? = builder.commitId
    /**
     * The GitHub account and repository pair that stores a reference to the commit that
     * represents the bundled artifacts for the application revision.
     * Specified as account/repository.
     */
    val repository: String? = builder.repository

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GitHubLocation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GitHubLocation(")
        append("commitId=$commitId,")
        append("repository=$repository)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commitId?.hashCode() ?: 0
        result = 31 * result + (repository?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GitHubLocation

        if (commitId != other.commitId) return false
        if (repository != other.repository) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GitHubLocation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GitHubLocation
        /**
         * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the
         * application revision.
         */
        fun commitId(commitId: String): FluentBuilder
        /**
         * The GitHub account and repository pair that stores a reference to the commit that
         * represents the bundled artifacts for the application revision.
         * Specified as account/repository.
         */
        fun repository(repository: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the
         * application revision.
         */
        var commitId: String?
        /**
         * The GitHub account and repository pair that stores a reference to the commit that
         * represents the bundled artifacts for the application revision.
         * Specified as account/repository.
         */
        var repository: String?

        fun build(): GitHubLocation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var commitId: String? = null
        override var repository: String? = null

        constructor(x: GitHubLocation) : this() {
            this.commitId = x.commitId
            this.repository = x.repository
        }

        override fun build(): GitHubLocation = GitHubLocation(this)
        override fun commitId(commitId: String): FluentBuilder = apply { this.commitId = commitId }
        override fun repository(repository: String): FluentBuilder = apply { this.repository = repository }
    }
}
