// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an on-premises instance.
 */
class InstanceInfo private constructor(builder: BuilderImpl) {
    /**
     * If the on-premises instance was deregistered, the time at which the on-premises
     * instance was deregistered.
     */
    val deregisterTime: Instant? = builder.deregisterTime
    /**
     * The ARN of the IAM session associated with the on-premises instance.
     */
    val iamSessionArn: String? = builder.iamSessionArn
    /**
     * The IAM user ARN associated with the on-premises instance.
     */
    val iamUserArn: String? = builder.iamUserArn
    /**
     * The ARN of the on-premises instance.
     */
    val instanceArn: String? = builder.instanceArn
    /**
     * The name of the on-premises instance.
     */
    val instanceName: String? = builder.instanceName
    /**
     * The time at which the on-premises instance was registered.
     */
    val registerTime: Instant? = builder.registerTime
    /**
     * The tags currently associated with the on-premises instance.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceInfo(")
        append("deregisterTime=$deregisterTime,")
        append("iamSessionArn=$iamSessionArn,")
        append("iamUserArn=$iamUserArn,")
        append("instanceArn=$instanceArn,")
        append("instanceName=$instanceName,")
        append("registerTime=$registerTime,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deregisterTime?.hashCode() ?: 0
        result = 31 * result + (iamSessionArn?.hashCode() ?: 0)
        result = 31 * result + (iamUserArn?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        result = 31 * result + (registerTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceInfo

        if (deregisterTime != other.deregisterTime) return false
        if (iamSessionArn != other.iamSessionArn) return false
        if (iamUserArn != other.iamUserArn) return false
        if (instanceArn != other.instanceArn) return false
        if (instanceName != other.instanceName) return false
        if (registerTime != other.registerTime) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceInfo
        /**
         * If the on-premises instance was deregistered, the time at which the on-premises
         * instance was deregistered.
         */
        fun deregisterTime(deregisterTime: Instant): FluentBuilder
        /**
         * The ARN of the IAM session associated with the on-premises instance.
         */
        fun iamSessionArn(iamSessionArn: String): FluentBuilder
        /**
         * The IAM user ARN associated with the on-premises instance.
         */
        fun iamUserArn(iamUserArn: String): FluentBuilder
        /**
         * The ARN of the on-premises instance.
         */
        fun instanceArn(instanceArn: String): FluentBuilder
        /**
         * The name of the on-premises instance.
         */
        fun instanceName(instanceName: String): FluentBuilder
        /**
         * The time at which the on-premises instance was registered.
         */
        fun registerTime(registerTime: Instant): FluentBuilder
        /**
         * The tags currently associated with the on-premises instance.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If the on-premises instance was deregistered, the time at which the on-premises
         * instance was deregistered.
         */
        var deregisterTime: Instant?
        /**
         * The ARN of the IAM session associated with the on-premises instance.
         */
        var iamSessionArn: String?
        /**
         * The IAM user ARN associated with the on-premises instance.
         */
        var iamUserArn: String?
        /**
         * The ARN of the on-premises instance.
         */
        var instanceArn: String?
        /**
         * The name of the on-premises instance.
         */
        var instanceName: String?
        /**
         * The time at which the on-premises instance was registered.
         */
        var registerTime: Instant?
        /**
         * The tags currently associated with the on-premises instance.
         */
        var tags: List<Tag>?

        fun build(): InstanceInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deregisterTime: Instant? = null
        override var iamSessionArn: String? = null
        override var iamUserArn: String? = null
        override var instanceArn: String? = null
        override var instanceName: String? = null
        override var registerTime: Instant? = null
        override var tags: List<Tag>? = null

        constructor(x: InstanceInfo) : this() {
            this.deregisterTime = x.deregisterTime
            this.iamSessionArn = x.iamSessionArn
            this.iamUserArn = x.iamUserArn
            this.instanceArn = x.instanceArn
            this.instanceName = x.instanceName
            this.registerTime = x.registerTime
            this.tags = x.tags
        }

        override fun build(): InstanceInfo = InstanceInfo(this)
        override fun deregisterTime(deregisterTime: Instant): FluentBuilder = apply { this.deregisterTime = deregisterTime }
        override fun iamSessionArn(iamSessionArn: String): FluentBuilder = apply { this.iamSessionArn = iamSessionArn }
        override fun iamUserArn(iamUserArn: String): FluentBuilder = apply { this.iamUserArn = iamUserArn }
        override fun instanceArn(instanceArn: String): FluentBuilder = apply { this.instanceArn = instanceArn }
        override fun instanceName(instanceName: String): FluentBuilder = apply { this.instanceName = instanceName }
        override fun registerTime(registerTime: Instant): FluentBuilder = apply { this.registerTime = registerTime }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
