// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A target Amazon EC2 or on-premises instance during a deployment that uses the
 * EC2/On-premises compute platform.
 */
class InstanceTarget private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A label that identifies whether the instance is an original target
     * (BLUE) or a replacement target (GREEN).
     */
    val instanceLabel: TargetLabel? = builder.instanceLabel
    /**
     * The date and time when the target instance was updated by a deployment.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the deployment to this target instance.
     */
    val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The status an EC2/On-premises deployment's target instance.
     */
    val status: TargetStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    val targetArn: String? = builder.targetArn
    /**
     * The unique ID of a deployment target that has a type of instanceTarget.
     */
    val targetId: String? = builder.targetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceTarget(")
        append("deploymentId=$deploymentId,")
        append("instanceLabel=$instanceLabel,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("targetId=$targetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (instanceLabel?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceTarget

        if (deploymentId != other.deploymentId) return false
        if (instanceLabel != other.instanceLabel) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (targetId != other.targetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceTarget
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A label that identifies whether the instance is an original target
         * (BLUE) or a replacement target (GREEN).
         */
        fun instanceLabel(instanceLabel: TargetLabel): FluentBuilder
        /**
         * The date and time when the target instance was updated by a deployment.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The lifecycle events of the deployment to this target instance.
         */
        fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder
        /**
         * The status an EC2/On-premises deployment's target instance.
         */
        fun status(status: TargetStatus): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        fun targetArn(targetArn: String): FluentBuilder
        /**
         * The unique ID of a deployment target that has a type of instanceTarget.
         */
        fun targetId(targetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * A label that identifies whether the instance is an original target
         * (BLUE) or a replacement target (GREEN).
         */
        var instanceLabel: TargetLabel?
        /**
         * The date and time when the target instance was updated by a deployment.
         */
        var lastUpdatedAt: Instant?
        /**
         * The lifecycle events of the deployment to this target instance.
         */
        var lifecycleEvents: List<LifecycleEvent>?
        /**
         * The status an EC2/On-premises deployment's target instance.
         */
        var status: TargetStatus?
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        var targetArn: String?
        /**
         * The unique ID of a deployment target that has a type of instanceTarget.
         */
        var targetId: String?

        fun build(): InstanceTarget
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var instanceLabel: TargetLabel? = null
        override var lastUpdatedAt: Instant? = null
        override var lifecycleEvents: List<LifecycleEvent>? = null
        override var status: TargetStatus? = null
        override var targetArn: String? = null
        override var targetId: String? = null

        constructor(x: InstanceTarget) : this() {
            this.deploymentId = x.deploymentId
            this.instanceLabel = x.instanceLabel
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.status = x.status
            this.targetArn = x.targetArn
            this.targetId = x.targetId
        }

        override fun build(): InstanceTarget = InstanceTarget(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun instanceLabel(instanceLabel: TargetLabel): FluentBuilder = apply { this.instanceLabel = instanceLabel }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder = apply { this.lifecycleEvents = lifecycleEvents }
        override fun status(status: TargetStatus): FluentBuilder = apply { this.status = status }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
        override fun targetId(targetId: String): FluentBuilder = apply { this.targetId = targetId }
    }
}
