// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a Lambda function specified in a deployment.
 */
class LambdaFunctionInfo private constructor(builder: BuilderImpl) {
    /**
     * The version of a Lambda function that production traffic points to.
     */
    val currentVersion: String? = builder.currentVersion
    /**
     * The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases in the
     * AWS Lambda Developer Guide.
     */
    val functionAlias: String? = builder.functionAlias
    /**
     * The name of a Lambda function.
     */
    val functionName: String? = builder.functionName
    /**
     * The version of a Lambda function that production traffic points to after the Lambda
     * function is deployed.
     */
    val targetVersion: String? = builder.targetVersion
    /**
     * The percentage of production traffic that the target version of a Lambda function
     * receives.
     */
    val targetVersionWeight: Double = builder.targetVersionWeight

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaFunctionInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionInfo(")
        append("currentVersion=$currentVersion,")
        append("functionAlias=$functionAlias,")
        append("functionName=$functionName,")
        append("targetVersion=$targetVersion,")
        append("targetVersionWeight=$targetVersionWeight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentVersion?.hashCode() ?: 0
        result = 31 * result + (functionAlias?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (targetVersion?.hashCode() ?: 0)
        result = 31 * result + (targetVersionWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaFunctionInfo

        if (currentVersion != other.currentVersion) return false
        if (functionAlias != other.functionAlias) return false
        if (functionName != other.functionName) return false
        if (targetVersion != other.targetVersion) return false
        if (targetVersionWeight != other.targetVersionWeight) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaFunctionInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaFunctionInfo
        /**
         * The version of a Lambda function that production traffic points to.
         */
        fun currentVersion(currentVersion: String): FluentBuilder
        /**
         * The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases in the
         * AWS Lambda Developer Guide.
         */
        fun functionAlias(functionAlias: String): FluentBuilder
        /**
         * The name of a Lambda function.
         */
        fun functionName(functionName: String): FluentBuilder
        /**
         * The version of a Lambda function that production traffic points to after the Lambda
         * function is deployed.
         */
        fun targetVersion(targetVersion: String): FluentBuilder
        /**
         * The percentage of production traffic that the target version of a Lambda function
         * receives.
         */
        fun targetVersionWeight(targetVersionWeight: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The version of a Lambda function that production traffic points to.
         */
        var currentVersion: String?
        /**
         * The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases in the
         * AWS Lambda Developer Guide.
         */
        var functionAlias: String?
        /**
         * The name of a Lambda function.
         */
        var functionName: String?
        /**
         * The version of a Lambda function that production traffic points to after the Lambda
         * function is deployed.
         */
        var targetVersion: String?
        /**
         * The percentage of production traffic that the target version of a Lambda function
         * receives.
         */
        var targetVersionWeight: Double

        fun build(): LambdaFunctionInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currentVersion: String? = null
        override var functionAlias: String? = null
        override var functionName: String? = null
        override var targetVersion: String? = null
        override var targetVersionWeight: Double = 0.0

        constructor(x: LambdaFunctionInfo) : this() {
            this.currentVersion = x.currentVersion
            this.functionAlias = x.functionAlias
            this.functionName = x.functionName
            this.targetVersion = x.targetVersion
            this.targetVersionWeight = x.targetVersionWeight
        }

        override fun build(): LambdaFunctionInfo = LambdaFunctionInfo(this)
        override fun currentVersion(currentVersion: String): FluentBuilder = apply { this.currentVersion = currentVersion }
        override fun functionAlias(functionAlias: String): FluentBuilder = apply { this.functionAlias = functionAlias }
        override fun functionName(functionName: String): FluentBuilder = apply { this.functionName = functionName }
        override fun targetVersion(targetVersion: String): FluentBuilder = apply { this.targetVersion = targetVersion }
        override fun targetVersionWeight(targetVersionWeight: Double): FluentBuilder = apply { this.targetVersionWeight = targetVersionWeight }
    }
}
