// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target AWS Lambda function during an AWS Lambda deployment.
 */
class LambdaTarget private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A LambdaFunctionInfo object that describes a target Lambda function.
     */
    val lambdaFunctionInfo: LambdaFunctionInfo? = builder.lambdaFunctionInfo
    /**
     * The date and time when the target Lambda function was updated by a deployment.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the deployment to this target Lambda function.
     */
    val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The status an AWS Lambda deployment's target Lambda function.
     */
    val status: TargetStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    val targetArn: String? = builder.targetArn
    /**
     * The unique ID of a deployment target that has a type of lambdaTarget.
     */
    val targetId: String? = builder.targetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaTarget(")
        append("deploymentId=$deploymentId,")
        append("lambdaFunctionInfo=$lambdaFunctionInfo,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("targetId=$targetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lambdaFunctionInfo?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaTarget

        if (deploymentId != other.deploymentId) return false
        if (lambdaFunctionInfo != other.lambdaFunctionInfo) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (targetId != other.targetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaTarget
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A LambdaFunctionInfo object that describes a target Lambda function.
         */
        fun lambdaFunctionInfo(lambdaFunctionInfo: LambdaFunctionInfo): FluentBuilder
        /**
         * The date and time when the target Lambda function was updated by a deployment.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The lifecycle events of the deployment to this target Lambda function.
         */
        fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder
        /**
         * The status an AWS Lambda deployment's target Lambda function.
         */
        fun status(status: TargetStatus): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        fun targetArn(targetArn: String): FluentBuilder
        /**
         * The unique ID of a deployment target that has a type of lambdaTarget.
         */
        fun targetId(targetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * A LambdaFunctionInfo object that describes a target Lambda function.
         */
        var lambdaFunctionInfo: LambdaFunctionInfo?
        /**
         * The date and time when the target Lambda function was updated by a deployment.
         */
        var lastUpdatedAt: Instant?
        /**
         * The lifecycle events of the deployment to this target Lambda function.
         */
        var lifecycleEvents: List<LifecycleEvent>?
        /**
         * The status an AWS Lambda deployment's target Lambda function.
         */
        var status: TargetStatus?
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        var targetArn: String?
        /**
         * The unique ID of a deployment target that has a type of lambdaTarget.
         */
        var targetId: String?

        fun build(): LambdaTarget
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo] inside the given [block]
         */
        fun lambdaFunctionInfo(block: LambdaFunctionInfo.DslBuilder.() -> kotlin.Unit) {
            this.lambdaFunctionInfo = LambdaFunctionInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var lambdaFunctionInfo: LambdaFunctionInfo? = null
        override var lastUpdatedAt: Instant? = null
        override var lifecycleEvents: List<LifecycleEvent>? = null
        override var status: TargetStatus? = null
        override var targetArn: String? = null
        override var targetId: String? = null

        constructor(x: LambdaTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lambdaFunctionInfo = x.lambdaFunctionInfo
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.status = x.status
            this.targetArn = x.targetArn
            this.targetId = x.targetId
        }

        override fun build(): LambdaTarget = LambdaTarget(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun lambdaFunctionInfo(lambdaFunctionInfo: LambdaFunctionInfo): FluentBuilder = apply { this.lambdaFunctionInfo = lambdaFunctionInfo }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun lifecycleEvents(lifecycleEvents: List<LifecycleEvent>): FluentBuilder = apply { this.lifecycleEvents = lifecycleEvents }
        override fun status(status: TargetStatus): FluentBuilder = apply { this.status = status }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
        override fun targetId(targetId: String): FluentBuilder = apply { this.targetId = targetId }
    }
}
