// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the most recent attempted or successful deployment to a deployment
 * group.
 */
class LastDeploymentInfo private constructor(builder: BuilderImpl) {
    /**
     * A timestamp that indicates when the most recent deployment to the deployment group
     * started.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A timestamp that indicates when the most recent deployment to the deployment group was
     * complete.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The status of the most recent deployment.
     */
    val status: DeploymentStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LastDeploymentInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LastDeploymentInfo(")
        append("createTime=$createTime,")
        append("deploymentId=$deploymentId,")
        append("endTime=$endTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LastDeploymentInfo

        if (createTime != other.createTime) return false
        if (deploymentId != other.deploymentId) return false
        if (endTime != other.endTime) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LastDeploymentInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LastDeploymentInfo
        /**
         * A timestamp that indicates when the most recent deployment to the deployment group
         * started.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A timestamp that indicates when the most recent deployment to the deployment group was
         * complete.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The status of the most recent deployment.
         */
        fun status(status: DeploymentStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A timestamp that indicates when the most recent deployment to the deployment group
         * started.
         */
        var createTime: Instant?
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * A timestamp that indicates when the most recent deployment to the deployment group was
         * complete.
         */
        var endTime: Instant?
        /**
         * The status of the most recent deployment.
         */
        var status: DeploymentStatus?

        fun build(): LastDeploymentInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createTime: Instant? = null
        override var deploymentId: String? = null
        override var endTime: Instant? = null
        override var status: DeploymentStatus? = null

        constructor(x: LastDeploymentInfo) : this() {
            this.createTime = x.createTime
            this.deploymentId = x.deploymentId
            this.endTime = x.endTime
            this.status = x.status
        }

        override fun build(): LastDeploymentInfo = LastDeploymentInfo(this)
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun status(status: DeploymentStatus): FluentBuilder = apply { this.status = status }
    }
}
