// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a deployment lifecycle event.
 */
class LifecycleEvent private constructor(builder: BuilderImpl) {
    /**
     * Diagnostic information about the deployment lifecycle event.
     */
    val diagnostics: Diagnostics? = builder.diagnostics
    /**
     * A timestamp that indicates when the deployment lifecycle event ended.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The deployment lifecycle event name, such as ApplicationStop,
     * BeforeInstall, AfterInstall,
     * ApplicationStart, or ValidateService.
     */
    val lifecycleEventName: String? = builder.lifecycleEventName
    /**
     * A timestamp that indicates when the deployment lifecycle event started.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The deployment lifecycle event status:
     * Pending: The deployment lifecycle event is pending.
     * InProgress: The deployment lifecycle event is in progress.
     * Succeeded: The deployment lifecycle event ran successfully.
     * Failed: The deployment lifecycle event has failed.
     * Skipped: The deployment lifecycle event has been skipped.
     * Unknown: The deployment lifecycle event is unknown.
     */
    val status: LifecycleEventStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LifecycleEvent = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleEvent(")
        append("diagnostics=$diagnostics,")
        append("endTime=$endTime,")
        append("lifecycleEventName=$lifecycleEventName,")
        append("startTime=$startTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = diagnostics?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEventName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LifecycleEvent

        if (diagnostics != other.diagnostics) return false
        if (endTime != other.endTime) return false
        if (lifecycleEventName != other.lifecycleEventName) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LifecycleEvent = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LifecycleEvent
        /**
         * Diagnostic information about the deployment lifecycle event.
         */
        fun diagnostics(diagnostics: Diagnostics): FluentBuilder
        /**
         * A timestamp that indicates when the deployment lifecycle event ended.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The deployment lifecycle event name, such as ApplicationStop,
         * BeforeInstall, AfterInstall,
         * ApplicationStart, or ValidateService.
         */
        fun lifecycleEventName(lifecycleEventName: String): FluentBuilder
        /**
         * A timestamp that indicates when the deployment lifecycle event started.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The deployment lifecycle event status:
         * Pending: The deployment lifecycle event is pending.
         * InProgress: The deployment lifecycle event is in progress.
         * Succeeded: The deployment lifecycle event ran successfully.
         * Failed: The deployment lifecycle event has failed.
         * Skipped: The deployment lifecycle event has been skipped.
         * Unknown: The deployment lifecycle event is unknown.
         */
        fun status(status: LifecycleEventStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Diagnostic information about the deployment lifecycle event.
         */
        var diagnostics: Diagnostics?
        /**
         * A timestamp that indicates when the deployment lifecycle event ended.
         */
        var endTime: Instant?
        /**
         * The deployment lifecycle event name, such as ApplicationStop,
         * BeforeInstall, AfterInstall,
         * ApplicationStart, or ValidateService.
         */
        var lifecycleEventName: String?
        /**
         * A timestamp that indicates when the deployment lifecycle event started.
         */
        var startTime: Instant?
        /**
         * The deployment lifecycle event status:
         * Pending: The deployment lifecycle event is pending.
         * InProgress: The deployment lifecycle event is in progress.
         * Succeeded: The deployment lifecycle event ran successfully.
         * Failed: The deployment lifecycle event has failed.
         * Skipped: The deployment lifecycle event has been skipped.
         * Unknown: The deployment lifecycle event is unknown.
         */
        var status: LifecycleEventStatus?

        fun build(): LifecycleEvent
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Diagnostics] inside the given [block]
         */
        fun diagnostics(block: Diagnostics.DslBuilder.() -> kotlin.Unit) {
            this.diagnostics = Diagnostics.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var diagnostics: Diagnostics? = null
        override var endTime: Instant? = null
        override var lifecycleEventName: String? = null
        override var startTime: Instant? = null
        override var status: LifecycleEventStatus? = null

        constructor(x: LifecycleEvent) : this() {
            this.diagnostics = x.diagnostics
            this.endTime = x.endTime
            this.lifecycleEventName = x.lifecycleEventName
            this.startTime = x.startTime
            this.status = x.status
        }

        override fun build(): LifecycleEvent = LifecycleEvent(this)
        override fun diagnostics(diagnostics: Diagnostics): FluentBuilder = apply { this.diagnostics = diagnostics }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun lifecycleEventName(lifecycleEventName: String): FluentBuilder = apply { this.lifecycleEventName = lifecycleEventName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun status(status: LifecycleEventStatus): FluentBuilder = apply { this.status = status }
    }
}
