// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a ListApplicationRevisions operation.
 */
class ListApplicationRevisionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS
     * account.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Whether to list revisions based on whether the revision is the target revision of a
     * deployment group:
     * include: List revisions that are target revisions of a deployment
     * group.
     * exclude: Do not list revisions that are target revisions of a
     * deployment group.
     * ignore: List all revisions.
     */
    val deployed: ListStateFilterAction? = builder.deployed
    /**
     * An identifier returned from the previous ListApplicationRevisions call.
     * It can be used to return the next set of applications in the list.
     */
    val nextToken: String? = builder.nextToken
    /**
     * An Amazon S3 bucket name to limit the search for revisions.
     * If set to null, all of the user's buckets are searched.
     */
    val s3Bucket: String? = builder.s3Bucket
    /**
     * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     */
    val s3KeyPrefix: String? = builder.s3KeyPrefix
    /**
     * The column name to use to sort the list results:
     * registerTime: Sort by the time the revisions were registered with
     * AWS CodeDeploy.
     * firstUsedTime: Sort by the time the revisions were first used in
     * a deployment.
     * lastUsedTime: Sort by the time the revisions were last used in a
     * deployment.
     * If not specified or set to null, the results are returned in an arbitrary order.
     */
    val sortBy: ApplicationRevisionSortBy? = builder.sortBy
    /**
     * The order in which to sort the list results:
     * ascending: ascending order.
     * descending: descending order.
     * If not specified, the results are sorted in ascending order.
     * If set to null, the results are sorted in an arbitrary order.
     */
    val sortOrder: SortOrder? = builder.sortOrder

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListApplicationRevisionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListApplicationRevisionsRequest(")
        append("applicationName=$applicationName,")
        append("deployed=$deployed,")
        append("nextToken=$nextToken,")
        append("s3Bucket=$s3Bucket,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (deployed?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListApplicationRevisionsRequest

        if (applicationName != other.applicationName) return false
        if (deployed != other.deployed) return false
        if (nextToken != other.nextToken) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListApplicationRevisionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListApplicationRevisionsRequest
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Whether to list revisions based on whether the revision is the target revision of a
         * deployment group:
         * include: List revisions that are target revisions of a deployment
         * group.
         * exclude: Do not list revisions that are target revisions of a
         * deployment group.
         * ignore: List all revisions.
         */
        fun deployed(deployed: ListStateFilterAction): FluentBuilder
        /**
         * An identifier returned from the previous ListApplicationRevisions call.
         * It can be used to return the next set of applications in the list.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * An Amazon S3 bucket name to limit the search for revisions.
         * If set to null, all of the user's buckets are searched.
         */
        fun s3Bucket(s3Bucket: String): FluentBuilder
        /**
         * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         */
        fun s3KeyPrefix(s3KeyPrefix: String): FluentBuilder
        /**
         * The column name to use to sort the list results:
         * registerTime: Sort by the time the revisions were registered with
         * AWS CodeDeploy.
         * firstUsedTime: Sort by the time the revisions were first used in
         * a deployment.
         * lastUsedTime: Sort by the time the revisions were last used in a
         * deployment.
         * If not specified or set to null, the results are returned in an arbitrary order.
         */
        fun sortBy(sortBy: ApplicationRevisionSortBy): FluentBuilder
        /**
         * The order in which to sort the list results:
         * ascending: ascending order.
         * descending: descending order.
         * If not specified, the results are sorted in ascending order.
         * If set to null, the results are sorted in an arbitrary order.
         */
        fun sortOrder(sortOrder: SortOrder): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         */
        var applicationName: String?
        /**
         * Whether to list revisions based on whether the revision is the target revision of a
         * deployment group:
         * include: List revisions that are target revisions of a deployment
         * group.
         * exclude: Do not list revisions that are target revisions of a
         * deployment group.
         * ignore: List all revisions.
         */
        var deployed: ListStateFilterAction?
        /**
         * An identifier returned from the previous ListApplicationRevisions call.
         * It can be used to return the next set of applications in the list.
         */
        var nextToken: String?
        /**
         * An Amazon S3 bucket name to limit the search for revisions.
         * If set to null, all of the user's buckets are searched.
         */
        var s3Bucket: String?
        /**
         * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         */
        var s3KeyPrefix: String?
        /**
         * The column name to use to sort the list results:
         * registerTime: Sort by the time the revisions were registered with
         * AWS CodeDeploy.
         * firstUsedTime: Sort by the time the revisions were first used in
         * a deployment.
         * lastUsedTime: Sort by the time the revisions were last used in a
         * deployment.
         * If not specified or set to null, the results are returned in an arbitrary order.
         */
        var sortBy: ApplicationRevisionSortBy?
        /**
         * The order in which to sort the list results:
         * ascending: ascending order.
         * descending: descending order.
         * If not specified, the results are sorted in ascending order.
         * If set to null, the results are sorted in an arbitrary order.
         */
        var sortOrder: SortOrder?

        fun build(): ListApplicationRevisionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationName: String? = null
        override var deployed: ListStateFilterAction? = null
        override var nextToken: String? = null
        override var s3Bucket: String? = null
        override var s3KeyPrefix: String? = null
        override var sortBy: ApplicationRevisionSortBy? = null
        override var sortOrder: SortOrder? = null

        constructor(x: ListApplicationRevisionsRequest) : this() {
            this.applicationName = x.applicationName
            this.deployed = x.deployed
            this.nextToken = x.nextToken
            this.s3Bucket = x.s3Bucket
            this.s3KeyPrefix = x.s3KeyPrefix
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        override fun build(): ListApplicationRevisionsRequest = ListApplicationRevisionsRequest(this)
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun deployed(deployed: ListStateFilterAction): FluentBuilder = apply { this.deployed = deployed }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun s3Bucket(s3Bucket: String): FluentBuilder = apply { this.s3Bucket = s3Bucket }
        override fun s3KeyPrefix(s3KeyPrefix: String): FluentBuilder = apply { this.s3KeyPrefix = s3KeyPrefix }
        override fun sortBy(sortBy: ApplicationRevisionSortBy): FluentBuilder = apply { this.sortBy = sortBy }
        override fun sortOrder(sortOrder: SortOrder): FluentBuilder = apply { this.sortOrder = sortOrder }
    }
}
