// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a ListDeploymentInstances operation.
 */
class ListDeploymentInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A subset of instances to list by status:
     * Pending: Include those instances with pending deployments.
     * InProgress: Include those instances where deployments are still
     * in progress.
     * Succeeded: Include those instances with successful
     * deployments.
     * Failed: Include those instances with failed deployments.
     * Skipped: Include those instances with skipped deployments.
     * Unknown: Include those instances with deployments in an unknown
     * state.
     */
    val instanceStatusFilter: List<InstanceStatus>? = builder.instanceStatusFilter
    /**
     * The set of instances in a blue/green deployment, either those in the original
     * environment ("BLUE") or those in the replacement environment ("GREEN"), for which you
     * want to view instance information.
     */
    val instanceTypeFilter: List<InstanceType>? = builder.instanceTypeFilter
    /**
     * An identifier returned from the previous list deployment instances call. It can be
     * used to return the next set of deployment instances in the list.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDeploymentInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeploymentInstancesRequest(")
        append("deploymentId=$deploymentId,")
        append("instanceStatusFilter=$instanceStatusFilter,")
        append("instanceTypeFilter=$instanceTypeFilter,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (instanceStatusFilter?.hashCode() ?: 0)
        result = 31 * result + (instanceTypeFilter?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDeploymentInstancesRequest

        if (deploymentId != other.deploymentId) return false
        if (instanceStatusFilter != other.instanceStatusFilter) return false
        if (instanceTypeFilter != other.instanceTypeFilter) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDeploymentInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDeploymentInstancesRequest
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A subset of instances to list by status:
         * Pending: Include those instances with pending deployments.
         * InProgress: Include those instances where deployments are still
         * in progress.
         * Succeeded: Include those instances with successful
         * deployments.
         * Failed: Include those instances with failed deployments.
         * Skipped: Include those instances with skipped deployments.
         * Unknown: Include those instances with deployments in an unknown
         * state.
         */
        fun instanceStatusFilter(instanceStatusFilter: List<InstanceStatus>): FluentBuilder
        /**
         * The set of instances in a blue/green deployment, either those in the original
         * environment ("BLUE") or those in the replacement environment ("GREEN"), for which you
         * want to view instance information.
         */
        fun instanceTypeFilter(instanceTypeFilter: List<InstanceType>): FluentBuilder
        /**
         * An identifier returned from the previous list deployment instances call. It can be
         * used to return the next set of deployment instances in the list.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * A subset of instances to list by status:
         * Pending: Include those instances with pending deployments.
         * InProgress: Include those instances where deployments are still
         * in progress.
         * Succeeded: Include those instances with successful
         * deployments.
         * Failed: Include those instances with failed deployments.
         * Skipped: Include those instances with skipped deployments.
         * Unknown: Include those instances with deployments in an unknown
         * state.
         */
        var instanceStatusFilter: List<InstanceStatus>?
        /**
         * The set of instances in a blue/green deployment, either those in the original
         * environment ("BLUE") or those in the replacement environment ("GREEN"), for which you
         * want to view instance information.
         */
        var instanceTypeFilter: List<InstanceType>?
        /**
         * An identifier returned from the previous list deployment instances call. It can be
         * used to return the next set of deployment instances in the list.
         */
        var nextToken: String?

        fun build(): ListDeploymentInstancesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var instanceStatusFilter: List<InstanceStatus>? = null
        override var instanceTypeFilter: List<InstanceType>? = null
        override var nextToken: String? = null

        constructor(x: ListDeploymentInstancesRequest) : this() {
            this.deploymentId = x.deploymentId
            this.instanceStatusFilter = x.instanceStatusFilter
            this.instanceTypeFilter = x.instanceTypeFilter
            this.nextToken = x.nextToken
        }

        override fun build(): ListDeploymentInstancesRequest = ListDeploymentInstancesRequest(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun instanceStatusFilter(instanceStatusFilter: List<InstanceStatus>): FluentBuilder = apply { this.instanceStatusFilter = instanceStatusFilter }
        override fun instanceTypeFilter(instanceTypeFilter: List<InstanceType>): FluentBuilder = apply { this.instanceTypeFilter = instanceTypeFilter }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
